/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.exception.library.RightsUnsuficientsForOperationException;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.library.LibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementStatisticsService;
import org.squashtest.tm.service.statistics.requirement.RequirementStatisticsBundle;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.generic.LibraryNavigationController;
import org.squashtest.tm.web.internal.controller.requirement.RequirementFormModel;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.RequirementLibraryTreeNodeBuilder;

@Controller
@RequestMapping(value={"/requirement-browser"})
public class RequirementLibraryNavigationController
extends LibraryNavigationController<RequirementLibrary, RequirementFolder, RequirementLibraryNode> {
    private static final String MODEL_ATTRIBUTE_ADD_REQUIREMENT = "add-requirement";
    private static final String FILENAME = "filename";
    private static final String LIBRARIES = "libraries";
    private static final String NODES = "nodes";
    @Inject
    @Named(value="requirement.driveNodeBuilder")
    private Provider<DriveNodeBuilder<RequirementLibraryNode>> driveNodeBuilder;
    @Inject
    private Provider<RequirementLibraryTreeNodeBuilder> requirementLibraryTreeNodeBuilder;
    @Inject
    private RequirementLibraryNavigationService requirementLibraryNavigationService;
    @Inject
    private RequirementStatisticsService requirementStatisticsService;
    @Inject
    private WorkspaceDisplayService requirementWorkspaceDisplayService;
    @Inject
    private RequirementLibraryFinderService requirementLibraryFinder;

    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @RequestMapping(value={"/drives/{libraryId}/content/new-requirement"}, method={RequestMethod.POST})
    public JsTreeNode addNewRequirementToLibraryRootContent(@PathVariable long libraryId, @RequestBody RequirementFormModel requirementModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)requirementModel, MODEL_ATTRIBUTE_ADD_REQUIREMENT);
        RequirementFormModel.RequirementFormModelValidator validator = new RequirementFormModel.RequirementFormModelValidator(this.getMessageSource());
        validator.validate(requirementModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
        Requirement req = this.requirementLibraryNavigationService.addRequirementToRequirementLibrary(libraryId, requirementModel.toDTO(), this.activeMilestoneAsList());
        return this.createTreeNodeFromLibraryNode((RequirementLibraryNode)req);
    }

    private List<Long> activeMilestoneAsList() {
        ArrayList<Long> milestoneIds = new ArrayList<Long>();
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            milestoneIds.add(((Milestone)activeMilestone.get()).getId());
        }
        return milestoneIds;
    }

    @ResponseBody
    @RequestMapping(value={"/folders/{folderId}/content/new-requirement"}, method={RequestMethod.POST})
    public JsTreeNode addNewRequirementToFolderContent(@PathVariable long folderId, @RequestBody RequirementFormModel requirementModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)requirementModel, MODEL_ATTRIBUTE_ADD_REQUIREMENT);
        RequirementFormModel.RequirementFormModelValidator validator = new RequirementFormModel.RequirementFormModelValidator(this.getMessageSource());
        validator.validate(requirementModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
        Requirement req = this.requirementLibraryNavigationService.addRequirementToRequirementFolder(folderId, requirementModel.toDTO(), this.activeMilestoneAsList());
        return this.createTreeNodeFromLibraryNode((RequirementLibraryNode)req);
    }

    @ResponseBody
    @RequestMapping(value={"/requirements/{requirementId}/content/new-requirement"}, method={RequestMethod.POST})
    public JsTreeNode addNewRequirementToRequirementContent(@PathVariable(value="requirementId") long requirementId, @RequestBody RequirementFormModel requirementModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)requirementModel, MODEL_ATTRIBUTE_ADD_REQUIREMENT);
        RequirementFormModel.RequirementFormModelValidator validator = new RequirementFormModel.RequirementFormModelValidator(this.getMessageSource());
        validator.validate(requirementModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
        Requirement req = this.requirementLibraryNavigationService.addRequirementToRequirement(requirementId, requirementModel.toDTO(), this.activeMilestoneAsList());
        return this.createTreeNodeFromLibraryNode((RequirementLibraryNode)req);
    }

    @ResponseBody
    @RequestMapping(value={"/requirements/{requirementId}/content/new"}, method={RequestMethod.POST}, params={"nodeIds[]"})
    public List<JsTreeNode> copyNodeIntoRequirement(@RequestParam(value="nodeIds[]") Long[] nodeIds, @PathVariable(value="requirementId") long requirementId) {
        ArrayList tojsonList;
        try {
            List nodeList = this.requirementLibraryNavigationService.copyNodesToRequirement(requirementId, nodeIds);
            tojsonList = new ArrayList(nodeList);
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
        return this.createJsTreeModel(tojsonList);
    }

    @ResponseBody
    @RequestMapping(value={"/requirements/{requirementId}/content/{nodeIds}"}, method={RequestMethod.PUT})
    public void moveNode(@PathVariable(value="nodeIds") Long[] nodeIds, @PathVariable(value="requirementId") long requirementId) {
        try {
            this.requirementLibraryNavigationService.moveNodesToRequirement(requirementId, nodeIds);
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @ResponseBody
    @RequestMapping(value={"/requirements/{requirementId}/content/{nodeIds}/{position}"}, method={RequestMethod.PUT})
    public void moveNode(@PathVariable(value="nodeIds") Long[] nodeIds, @PathVariable(value="requirementId") long requirementId, @PathVariable(value="position") int position) {
        try {
            this.requirementLibraryNavigationService.moveNodesToRequirement(requirementId, nodeIds, position);
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @ResponseBody
    @RequestMapping(value={"/requirements/{requirementId}/content"}, method={RequestMethod.GET})
    public List<JsTreeNode> getChildrenRequirementsTreeModel(@PathVariable(value="requirementId") long requirementId) {
        Long activeMilestoneId = (Long)this.activeMilestoneHolder.getActiveMilestoneId().get();
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        Collection nodes = this.workspaceDisplayService().getNodeContent(Long.valueOf(requirementId), currentUser, "Requirement", activeMilestoneId);
        return new ArrayList<JsTreeNode>(nodes);
    }

    @Override
    protected LibraryNavigationService<RequirementLibrary, RequirementFolder, RequirementLibraryNode> getLibraryNavigationService() {
        return this.requirementLibraryNavigationService;
    }

    @Override
    protected JsTreeNode createTreeNodeFromLibraryNode(RequirementLibraryNode resource) {
        RequirementLibraryTreeNodeBuilder builder = (RequirementLibraryTreeNodeBuilder)this.requirementLibraryTreeNodeBuilder.get();
        return this.applyActiveMilestoneFilter(builder).setNode(resource).build();
    }

    private RequirementLibraryTreeNodeBuilder applyActiveMilestoneFilter(RequirementLibraryTreeNodeBuilder builder) {
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            builder.filterByMilestone((Milestone)activeMilestone.get());
        }
        return builder;
    }

    @ResponseBody
    @RequestMapping(value={"/exports"}, method={RequestMethod.GET})
    public FileSystemResource exportRequirementExcel(@RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".xls");
        File export = this.requirementLibraryNavigationService.exportRequirementAsExcel(libraryIds, nodeIds, keepRteFormat.booleanValue(), this.getMessageSource());
        return new FileSystemResource(export);
    }

    @ResponseBody
    @RequestMapping(value={"/searchExports"}, method={RequestMethod.GET})
    public FileSystemResource searchExportRequirementExcel(@RequestParam(value="filename") String filename, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, @RequestParam(value="type") String type, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".xls");
        File export = this.requirementLibraryNavigationService.searchExportRequirementAsExcel(nodeIds, keepRteFormat.booleanValue(), this.getMessageSource(), type);
        return new FileSystemResource(export);
    }

    @ResponseBody
    @RequestMapping(value={"/drives"}, method={RequestMethod.GET}, params={"linkables"})
    public List<JsTreeNode> getLinkablesRootModel() {
        List<Long> linkableRequirementLibraryIds = this.requirementLibraryFinder.findLinkableRequirementLibraries().stream().map(RequirementLibrary::getId).collect(Collectors.toList());
        return this.createLinkableLibrariesModel(linkableRequirementLibraryIds);
    }

    @ResponseBody
    @RequestMapping(value={"/statistics"}, method={RequestMethod.GET}, produces={"application/json"}, params={"libraries", "nodes"})
    public RequirementStatisticsBundle getStatisticsAsJson(@RequestParam(value="libraries", defaultValue="") Collection<Long> libraryIds, @RequestParam(value="nodes", defaultValue="") Collection<Long> nodeIds) {
        return this.requirementLibraryNavigationService.getStatisticsForSelection(libraryIds, nodeIds);
    }

    @RequestMapping(value={"/dashboard"}, method={RequestMethod.GET}, produces={"text/html"}, params={"libraries", "nodes"})
    public String getDashboard(Model model, @RequestParam(value="libraries") Collection<Long> libraryIds, @RequestParam(value="nodes") Collection<Long> nodeIds) {
        RequirementStatisticsBundle stats = this.requirementLibraryNavigationService.getStatisticsForSelection(libraryIds, nodeIds);
        model.addAttribute("statistics", (Object)stats);
        return "fragment/requirements/requirement-dashboard";
    }

    @ResponseBody
    @RequestMapping(value={"/statistics"}, method={RequestMethod.GET}, produces={"application/json"})
    public RequirementStatisticsBundle getMilestoneStatisticsAsJson() {
        List nodeIds = this.requirementLibraryNavigationService.findAllRequirementIdsInMilestone((Milestone)this.activeMilestoneHolder.getActiveMilestone().orElse(null));
        return this.requirementLibraryNavigationService.getStatisticsForSelection(new ArrayList(), (Collection)nodeIds);
    }

    @RequestMapping(value={"/dashboard-favorite"}, method={RequestMethod.GET}, produces={"text/html"})
    public String getFavoriteDashboard(Model model) {
        boolean shouldShowDashboard = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.REQUIREMENT);
        boolean canShowDashboard = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.REQUIREMENT);
        model.addAttribute("shouldShowDashboard", (Object)shouldShowDashboard);
        model.addAttribute("canShowDashboard", (Object)canShowDashboard);
        return "fragment/dashboard/favorite-dashboard";
    }

    @RequestMapping(value={"/dashboard"}, method={RequestMethod.GET}, produces={"text/html"})
    public String getMilestoneDashboard(Model model) {
        boolean shouldShowDashboard = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.REQUIREMENT);
        boolean canShowDashboard = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.REQUIREMENT);
        model.addAttribute("shouldShowDashboard", (Object)shouldShowDashboard);
        model.addAttribute("canShowDashboard", (Object)canShowDashboard);
        Milestone activeMilestone = this.activeMilestoneHolder.getActiveMilestone().orElse(null);
        model.addAttribute("milestone", (Object)activeMilestone);
        model.addAttribute("isMilestoneDashboard", (Object)true);
        if (!shouldShowDashboard || !canShowDashboard) {
            List nodeIds = this.requirementLibraryNavigationService.findAllRequirementIdsInMilestone(activeMilestone);
            RequirementStatisticsBundle stats = this.requirementLibraryNavigationService.getStatisticsForSelection(new ArrayList(), (Collection)nodeIds);
            model.addAttribute("statistics", (Object)stats);
        }
        return "fragment/requirements/requirement-milestone-dashboard";
    }

    @ResponseBody
    @RequestMapping(value={"/validation-statistics"}, method={RequestMethod.POST}, produces={"application/json"}, params={"selectedIds", "criticality", "validation"})
    public Collection<Long> getValidationRequirementIds(@RequestParam Collection<Long> selectedIds, @RequestParam RequirementCriticality criticality, @RequestParam Collection<String> validation) {
        return this.requirementStatisticsService.gatherRequirementIdsFromValidation(selectedIds, criticality, validation);
    }

    @Override
    protected WorkspaceDisplayService workspaceDisplayService() {
        return this.requirementWorkspaceDisplayService;
    }
}

