/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement;

import java.util.Set;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;

@Controller
@RequestMapping(value={"/requirement-libraries/{libraryId}"})
public class RequirementLibraryModificationController {
    @Inject
    private RequirementLibraryNavigationService requirementLibraryNavigationService;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentsHelper;
    @Inject
    private CustomReportDashboardService customReportDashboardService;

    @RequestMapping(method={RequestMethod.GET})
    public final ModelAndView showRequirementLibrary(@PathVariable long libraryId) {
        RequirementLibrary lib = (RequirementLibrary)this.requirementLibraryNavigationService.findLibrary(libraryId);
        ModelAndView mav = new ModelAndView("fragment/requirements/requirement-library");
        Set<Attachment> attachments = this.attachmentsHelper.findAttachments((AttachmentHolder)lib);
        mav.addObject("library", (Object)lib);
        mav.addObject("attachments", attachments);
        mav.addObject("workspaceName", (Object)"requirement");
        boolean shouldShowDashboard = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.REQUIREMENT);
        boolean canShowDashboard = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.REQUIREMENT);
        mav.addObject("shouldShowDashboard", (Object)shouldShowDashboard);
        mav.addObject("canShowDashboard", (Object)canShowDashboard);
        return mav;
    }
}

