/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.requirement.NewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.service.internal.dto.RawValueModel;

public class RequirementFormModel {
    private String name;
    private String description;
    private RequirementCriticality criticality;
    private String category;
    private String reference;
    private RawValueModel.RawValueModelMap customFields;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RequirementCriticality getCriticality() {
        return this.criticality;
    }

    public void setCriticality(RequirementCriticality criticality) {
        this.criticality = criticality;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public RawValueModel.RawValueModelMap getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(RawValueModel.RawValueModelMap customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public NewRequirementVersionDto toDTO() {
        NewRequirementVersionDto dto = new NewRequirementVersionDto();
        dto.setName(this.name);
        dto.setReference(this.reference);
        dto.setCategory(this.category);
        dto.setCriticality(this.criticality);
        dto.setDescription(this.description);
        HashMap<Long, RawValue> cufs = new HashMap<Long, RawValue>(this.customFields.size());
        for (Map.Entry entry : this.customFields.entrySet()) {
            cufs.put((Long)entry.getKey(), ((RawValueModel)entry.getValue()).toRawValue());
        }
        dto.setCustomFields(cufs);
        return dto;
    }

    public static class RequirementFormModelValidator
    implements Validator {
        private static final String MESSAGE_LENGTH_MAX = "message.lengthMax";
        private static final String MESSAGE_NOT_BLANK = "message.notBlank";
        private MessageSource messageSource;

        public void setMessageSource(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public RequirementFormModelValidator(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public boolean supports(Class<?> clazz) {
            return clazz.equals(NewRequirementVersionDto.class);
        }

        public void validate(Object target, Errors errors) {
            Locale locale = LocaleContextHolder.getLocale();
            String notBlank = this.messageSource.getMessage(MESSAGE_NOT_BLANK, null, locale);
            String lengthMax = this.messageSource.getMessage(MESSAGE_LENGTH_MAX, new Object[]{"50"}, locale);
            RequirementFormModel model = (RequirementFormModel)target;
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)MESSAGE_NOT_BLANK, (String)notBlank);
            if (model.criticality == null) {
                errors.rejectValue("criticality", MESSAGE_NOT_BLANK, notBlank);
            }
            if (model.category == null) {
                errors.rejectValue("category", MESSAGE_NOT_BLANK, notBlank);
            }
            if (model.reference != null && model.reference.length() > 50) {
                errors.rejectValue("reference", MESSAGE_LENGTH_MAX, lengthMax);
            }
            for (Map.Entry entry : model.getCustomFields().entrySet()) {
                RawValueModel value = (RawValueModel)entry.getValue();
                if (!value.isEmpty()) continue;
                errors.rejectValue("customFields[" + entry.getKey() + "]", MESSAGE_NOT_BLANK, notBlank);
            }
        }
    }
}

