/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement;

import java.util.HashMap;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.requirement.LinkedRequirementVersion;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneModelUtils;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

class LinkedRequirementVersionsTableModelHelper
extends DataTableModelBuilder<LinkedRequirementVersion> {
    private InternationalizationHelper helper;
    private Locale locale = LocaleContextHolder.getLocale();
    private static final int INT_MAX_DESCRIPTION_LENGTH = 50;

    public LinkedRequirementVersionsTableModelHelper(InternationalizationHelper helper) {
        this.helper = helper;
    }

    @Override
    protected Object buildItemData(LinkedRequirementVersion rv) {
        HashMap<String, String> row = new HashMap<String, String>(11);
        row.put("rv-id", rv.getId().toString());
        row.put("rv-index", Long.toString(this.getCurrentIndex()));
        row.put("project-name", HtmlUtils.htmlEscape((String)rv.getProject().getName()));
        row.put("rv-reference", HtmlUtils.htmlEscape((String)rv.getReference()));
        row.put("rv-name", HtmlUtils.htmlEscape((String)rv.getName()));
        row.put("rv-version", Integer.toString(rv.getVersionNumber()));
        row.put("rv-role", this.formatRole(rv.getRole()));
        row.put("milestone-dates", MilestoneModelUtils.timeIntervalToString(rv.getMilestones(), this.helper, this.locale));
        row.put("empty-edit-holder", null);
        row.put("empty-delete-holder", null);
        row.put("milestone", HtmlUtils.htmlEscape((String)MilestoneModelUtils.milestoneLabelsOrderByDate(rv.getMilestones())));
        row.put("rv-description", HTMLCleanupUtils.getCleanedBriefText(rv.getDescription(), 50));
        return row;
    }

    private String formatRole(String role) {
        return this.helper.getMessage(role, null, role, this.locale);
    }
}

