/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.collections.MultiMap;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.exception.requirement.link.LinkedRequirementVersionException;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneModelService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.requirement.LinkedRequirementVersionsTableModelHelper;
import org.squashtest.tm.web.internal.helper.JsTreeHelper;
import org.squashtest.tm.web.internal.helper.LinkedRequirementVersionActionSummaryBuilder;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/requirement-versions/{requirementVersionId}/linked-requirement-versions"})
public class LinkedRequirementVersionsManagerController {
    private static final String IS_RELATED_ID_A_NODE_ID = "isRelatedIdANodeId";
    private static final String REQ_VERSION_LINK_TYPE_ID = "reqVersionLinkTypeId";
    private static final String REQ_VERSION_LINK_TYPE_DIRECTION = "reqVersionLinkTypeDirection";
    private static final String REQUIREMENT_VERSION_ID = "requirementVersionId";
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private RequirementVersionManagerService requirementVersionFinder;
    @Inject
    private LinkedRequirementVersionManagerService linkedReqVersionManager;
    @Inject
    private RequirementLibraryFinderService requirementLibraryFinder;
    @Inject
    private RequirementLibraryNavigationService requirementFinder;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    @Named(value="requirement.driveNodeBuilder")
    private Provider<DriveNodeBuilder<RequirementLibraryNode>> driveNodeBuilder;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private WorkspaceDisplayService requirementWorkspaceDisplayService;
    @Inject
    protected UserAccountService userAccountService;
    @Inject
    protected MilestoneModelService milestoneModelService;
    @Inject
    protected ProjectFinder projectFinder;
    private final DatatableMapper<String> linkedReqVersionMapper = new NameBasedMapper(6).mapAttribute("project-name", "name", Project.class).mapAttribute("rv-reference", "reference", RequirementVersion.class).mapAttribute("rv-name", "name", RequirementVersion.class).mapAttribute("rv-version", "versionNumber", RequirementVersion.class).map("rv-role", "role").map("milestone-dates", "endDate");

    @RequestMapping(value={"/table"}, method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getLinkedRequirementVersionsTableModel(@PathVariable long requirementVersionId, DataTableDrawParameters params) {
        DataTableSorting pas = new DataTableSorting(params, this.linkedReqVersionMapper);
        return this.buildLinkedRequirementVersionsModel(requirementVersionId, pas, params.getsEcho());
    }

    protected DataTableModel buildLinkedRequirementVersionsModel(long requirementVersionId, PagingAndSorting pas, String sEcho) {
        PagedCollectionHolder holder = this.linkedReqVersionManager.findAllByRequirementVersion(requirementVersionId, pas);
        return new LinkedRequirementVersionsTableModelHelper(this.i18nHelper).buildDataModel(holder, sEcho);
    }

    @ResponseBody
    @RequestMapping(value={"/{requirementVersionIdsToUnbind}"}, method={RequestMethod.DELETE})
    public void removeLinkedRequirementVersionsFromRequirementVersion(@PathVariable long requirementVersionId, @PathVariable List<Long> requirementVersionIdsToUnbind) {
        this.linkedReqVersionManager.removeLinkedRequirementVersionsFromRequirementVersion(requirementVersionId, requirementVersionIdsToUnbind);
    }

    @RequestMapping(value={"/manager"}, method={RequestMethod.GET})
    public String showManager(@PathVariable long requirementVersionId, Model model, @CookieValue(value="jstree_open", required=false, defaultValue="") String[] openedNodes) {
        RequirementVersion requirementVersion = this.requirementVersionFinder.findById(requirementVersionId);
        PermissionsUtils.checkPermission((PermissionEvaluationService)this.permissionService, (SecurityCheckableObject[])new SecurityCheckableObject[]{new SecurityCheckableObject((Object)requirementVersion, "LINK")});
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(requirementVersion);
        MultiMap expansionCandidates = JsTreeHelper.mapIdsByType(openedNodes);
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List projectIds = this.projectFinder.findAllReadableIds(currentUser);
        Optional activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId();
        Collection linkableLibrariesModel = this.requirementWorkspaceDisplayService.findAllLibraries(projectIds, currentUser, expansionCandidates, (Long)activeMilestoneId.get());
        DefaultPagingAndSorting pas = new DefaultPagingAndSorting("Project.name");
        DataTableModel linkedReqVersionsModel = this.buildLinkedReqVersionsModel(requirementVersionId, (PagingAndSorting)pas, "");
        model.addAttribute("requirement", (Object)requirementVersion.getRequirement());
        model.addAttribute("requirementVersion", (Object)requirementVersion);
        model.addAttribute("linkableLibrariesModel", (Object)linkableLibrariesModel);
        model.addAttribute("linkedReqVersionsModel", (Object)linkedReqVersionsModel);
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        return "page/requirement-workspace/show-linked-requirement-version-manager";
    }

    protected DataTableModel buildLinkedReqVersionsModel(long requirementVersionId, PagingAndSorting pas, String sEcho) {
        PagedCollectionHolder holder = this.linkedReqVersionManager.findAllByRequirementVersion(requirementVersionId, pas);
        return new LinkedRequirementVersionsTableModelHelper(this.i18nHelper).buildDataModel(holder, sEcho);
    }

    @ResponseBody
    @RequestMapping(value={"/{requirementNodesIds}"}, method={RequestMethod.POST}, params={"reqVersionLinkTypeId", "reqVersionLinkTypeDirection"})
    public Map<String, Object> addLinkWithVersionIdAndNodeId(@PathVariable(value="requirementVersionId") long requirementVersionId, @PathVariable(value="requirementNodesIds") List<Long> requirementNodesIds, @RequestParam(value="reqVersionLinkTypeId") long reqVersionLinkTypeId, @RequestParam(value="reqVersionLinkTypeDirection") boolean reqVersionLinkTypeDirection) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Long ids : requirementNodesIds) {
            Collection rejections = this.linkedReqVersionManager.addLinkWithNodeIds(Long.valueOf(requirementVersionId), ids, reqVersionLinkTypeId, reqVersionLinkTypeDirection);
            map.putAll(this.buildSummary(rejections));
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value={"/{relatedId}"}, method={RequestMethod.POST}, params={"isRelatedIdANodeId", "reqVersionLinkTypeId", "reqVersionLinkTypeDirection"})
    public void updateLinkTypeAndDirection(@PathVariable(value="requirementVersionId") long requirementVersionId, @PathVariable(value="relatedId") List<Long> paramRelatedIds, @RequestParam(value="isRelatedIdANodeId") boolean isRelatedIdANodeId, @RequestParam(value="reqVersionLinkTypeId") long reqVersionLinkTypeId, @RequestParam(value="reqVersionLinkTypeDirection") boolean reqVersionLinkTypeDirection) {
        new HashMap();
        for (Long paramRelatedId : paramRelatedIds) {
            long relatedId = paramRelatedId;
            this.linkedReqVersionManager.updateLinkTypeAndDirection(requirementVersionId, relatedId, isRelatedIdANodeId, reqVersionLinkTypeId, reqVersionLinkTypeDirection);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/{relatedIds}"}, params={"isRelatedIdANodeId"}, method={RequestMethod.GET}, produces={"application/json"})
    public Map<String, String> getRequirementVersionInformation(@PathVariable List<Long> relatedIds, @RequestParam(value="isRelatedIdANodeId") boolean isRelatedIdANodeId) {
        return this.linkedReqVersionManager.getRequirementVersionInformation(relatedIds, isRelatedIdANodeId);
    }

    @ResponseBody
    @RequestMapping(value={"/requirement-versions-link-types"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RequirementVersionLinkType> getAllRequirementVersionLinkTypes(Locale locale) {
        return this.internationalizeLinkTypesRoles(this.linkedReqVersionManager.getAllReqVersionLinkTypes(), locale);
    }

    private Map<String, Object> buildSummary(Collection<LinkedRequirementVersionException> rejections) {
        return LinkedRequirementVersionActionSummaryBuilder.buildAddActionSummary(rejections);
    }

    private List<RequirementVersionLinkType> internationalizeLinkTypesRoles(List<RequirementVersionLinkType> listToInternationalize, Locale locale) {
        ArrayList<RequirementVersionLinkType> internationalizedList = new ArrayList<RequirementVersionLinkType>();
        for (RequirementVersionLinkType typeToCopy : listToInternationalize) {
            RequirementVersionLinkType internationalizedCopy = typeToCopy.createCopy();
            internationalizedCopy.setRole1(this.i18nHelper.getMessage(internationalizedCopy.getRole1(), null, internationalizedCopy.getRole1(), locale));
            internationalizedCopy.setRole2(this.i18nHelper.getMessage(internationalizedCopy.getRole2(), null, internationalizedCopy.getRole2(), locale));
            internationalizedList.add(internationalizedCopy);
        }
        return internationalizedList;
    }
}

