/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.report;

import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.web.internal.report.ReportsRegistry;

@Controller
@RequestMapping(value={"/report-workspace"})
public class ReportWorkspaceController {
    @Inject
    private ReportsRegistry reportsRegistry;
    @Inject
    private CustomReportLibraryNodeService customReportLibraryNodeService;
    @Inject
    private ConfigurationService configurationService;

    @RequestMapping(method={RequestMethod.GET})
    public String showReportWorkspace(Model model) {
        this.populateModelWithReportsRegistry(model);
        String userLicenseInformation = this.configurationService.findConfiguration("activated.user.excess");
        String dateLicenseInformation = this.configurationService.findConfiguration("plugin.license.expiration");
        model.addAttribute("userLicenseInformation", (Object)userLicenseInformation);
        model.addAttribute("dateLicenseInformation", dateLicenseInformation == null || dateLicenseInformation.isEmpty() ? null : Integer.valueOf(dateLicenseInformation));
        return "report-workspace.html";
    }

    @RequestMapping(value={"/{parentId}"}, method={RequestMethod.GET})
    public String showReportWorkspaceFromCustomReport(@PathVariable Long parentId, Model model) {
        CustomReportLibraryNode crln = this.customReportLibraryNodeService.findCustomReportLibraryNodeById(parentId);
        if (crln.getEntityType().getTypeName().equals("REPORT")) {
            ReportDefinition def = (ReportDefinition)crln.getEntity();
            model.addAttribute("pluginNamespace", (Object)def.getPluginNamespace());
        }
        this.populateModelWithReportsRegistry(model);
        model.addAttribute("parentId", (Object)parentId);
        return "report-workspace.html";
    }

    private void populateModelWithReportsRegistry(Model model) {
        model.addAttribute("categories", this.reportsRegistry.getSortedCategories());
        model.addAttribute("reports", this.reportsRegistry.getSortedReportsByCategory());
    }

    @ModelAttribute(value="hilightedWorkspace")
    String getHighlightedWorkspace() {
        return "report";
    }
}

