/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.report;

import com.lowagie.text.pdf.codec.Base64;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.form.Input;
import org.squashtest.tm.api.report.form.InputType;
import org.squashtest.tm.api.report.form.OptionInput;
import org.squashtest.tm.api.report.form.RadioButtonsGroup;
import org.squashtest.tm.api.report.form.composite.TagPickerOption;
import org.squashtest.tm.domain.IdCollector;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.projectfilter.ProjectFilter;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.customfield.CustomFieldManagerService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.dto.FilterModel;
import org.squashtest.tm.service.project.ProjectFilterModificationService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.report.ReportModificationService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.helper.ReportHelper;
import org.squashtest.tm.web.internal.report.ReportsRegistry;
import org.squashtest.tm.web.internal.report.criteria.ConciseFormToCriteriaConverter;
import org.squashtest.tm.web.internal.report.criteria.FormToCriteriaConverter;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/reports/{namespace}"})
public class ReportController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportController.class);
    @Inject
    private ReportHelper reportHelper;
    @Inject
    private ReportsRegistry reportsRegistry;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private CustomFieldManagerService customFieldFinder;
    @Inject
    private ReportModificationService reportModificationService;
    @Inject
    @Value(value="${report.criteria.project.multiselect:false}")
    private boolean projectMultiselect;
    @Inject
    private UserAccountService userService;
    @Inject
    private CustomReportLibraryNodeService customReportLibraryNodeService;
    @Inject
    private ProjectFilterModificationService projectFilterService;

    @ResponseBody
    @RequestMapping(value={"/panel/content/new-report/{parentId}"}, method={RequestMethod.POST}, consumes={"application/json"})
    public String saveReport(@PathVariable String namespace, @RequestBody ReportDefinition reportDefinition, @PathVariable(value="parentId") long parentId) {
        reportDefinition.setPluginNamespace(namespace);
        reportDefinition.setOwner(this.userService.findCurrentUser());
        CustomReportLibraryNode node = this.customReportLibraryNodeService.createNewNode(Long.valueOf(parentId), (CustomReportTreeEntity)reportDefinition);
        return node.getId().toString();
    }

    @ResponseBody
    @RequestMapping(value={"/panel/content/update/{id}"}, method={RequestMethod.POST}, consumes={"application/json"})
    public String updateReportDefinition(@PathVariable String namespace, @RequestBody ReportDefinition definition, @PathVariable(value="id") long id) {
        ReportDefinition oldDef = this.customReportLibraryNodeService.findReportDefinitionByNodeId(Long.valueOf(id));
        definition.setPluginNamespace(namespace);
        definition.setOwner(this.userService.findCurrentUser());
        definition.setId(oldDef.getId());
        this.reportModificationService.updateDefinition(definition, oldDef);
        return String.valueOf(id);
    }

    @RequestMapping(value={"/panel"}, method={RequestMethod.GET})
    public String showReportPanel(@PathVariable String namespace, Model model) {
        this.populateModel(namespace, model);
        return "report-panel.html";
    }

    @RequestMapping(value={"/panel/{parentId}"}, method={RequestMethod.GET})
    public String showReportPanelInCustomReport(@PathVariable String namespace, Model model, @PathVariable(value="parentId") long parentId, Locale locale) {
        this.populateModel(namespace, model);
        model.addAttribute("parentId", (Object)parentId);
        CustomReportLibraryNode crln = this.customReportLibraryNodeService.findCustomReportLibraryNodeById(Long.valueOf(parentId));
        if (crln.getEntityType().getTypeName().equals("REPORT")) {
            ReportDefinition def = (ReportDefinition)crln.getEntity();
            model.addAttribute("reportDef", (Object)JsonHelper.serialize(def));
            model.addAttribute("reportDefDescription", (Object)HTMLCleanupUtils.cleanHtml(def.getDescription()));
            model.addAttribute("reportDefSummary", (Object)HTMLCleanupUtils.cleanHtml(def.getSummary()));
            Map<String, Object> form = null;
            try {
                form = JsonHelper.deserialize(def.getParameters());
            }
            catch (IOException e) {
                LOGGER.error("the report : " + def.getName() + " has corrupted parameters.", (Throwable)e);
            }
            Report report = this.reportsRegistry.findReport(namespace);
            List projects = this.projectFinder.findAllOrderedByName();
            if (def.getPluginNamespace().equalsIgnoreCase(namespace)) {
                Map<String, Criteria> crit = new ConciseFormToCriteriaConverter(report, projects).convert(form);
                model.addAttribute("reportAttributes", this.reportHelper.getAttributesForReport(report, crit));
            }
        }
        return "report-panel.html";
    }

    private FilterModel findProjectsModels() {
        ProjectFilter filter = this.projectFilterService.findProjectFilterByUserLogin();
        if (filter.isEnabled()) {
            return new FilterModel(filter, this.projectFinder.findAllOrderedByName());
        }
        return new FilterModel(this.projectFinder.findAllOrderedByName());
    }

    private void populateModel(String namespace, Model model) {
        model.addAttribute("projectMultiselect", (Object)this.projectMultiselect);
        model.addAttribute("projectFilterModel", (Object)this.findProjectsModels());
        Report report = this.reportsRegistry.findReport(namespace);
        model.addAttribute("report", (Object)report);
        this.populateTagsIfRequired(report, model);
    }

    @Deprecated
    @RequestMapping(value={"/views/{viewIndex}/formats/{format}"}, method={RequestMethod.GET}, params={"parameters"})
    public ModelAndView generateReportViewUsingGet(@PathVariable String namespace, @PathVariable int viewIndex, @PathVariable String format, @RequestParam(value="parameters") String parameters) throws IOException {
        Map<String, Object> form = JsonHelper.deserialize(parameters);
        Map<String, Criteria> crit = new FormToCriteriaConverter().convert(form);
        Report report = this.reportsRegistry.findReport(namespace);
        return report.buildModelAndView(viewIndex, format, crit);
    }

    @RequestMapping(value={"/views/{viewIndex}/formats/{format}"}, method={RequestMethod.GET}, params={"json"})
    public ModelAndView getReportView(@PathVariable String namespace, @PathVariable int viewIndex, @PathVariable String format, @RequestParam(value="json") String parameters) throws IOException {
        ModelAndView mav;
        Map<String, Object> form = JsonHelper.deserialize(parameters);
        Report report = this.reportsRegistry.findReport(namespace);
        List projects = this.projectFinder.findAllOrderedByName();
        Map<String, Criteria> crit = new ConciseFormToCriteriaConverter(report, projects).convert(form);
        if ("docx".equals(format)) {
            Map model = report.buildModelAndView(viewIndex, format, crit).getModel();
            mav = new ModelAndView("docx.html");
            mav.addObject("model", model.get("data"));
            mav.addObject("html", model.get("html"));
            mav.addObject("fileName", model.get("fileName"));
            mav.addObject("namespace", (Object)namespace);
            mav.addObject("viewIndx", (Object)viewIndex);
        } else {
            mav = report.buildModelAndView(viewIndex, format, crit);
        }
        return mav;
    }

    @RequestMapping(value={"/views/{viewIndex}/docxtemplate"}, method={RequestMethod.GET})
    public void getTemplate(@PathVariable String namespace, @PathVariable int viewIndex, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Report report = this.reportsRegistry.findReport(namespace);
        report.getViews()[viewIndex].getSpringView().render(null, request, response);
    }

    public static byte[] decompress(byte[] str) throws IOException {
        int len;
        byte[] buf = new byte[str.length * 10];
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(str));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = gis.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        return out.toByteArray();
    }

    public static byte[] base64Decoding(String str) {
        return Base64.decode((String)str);
    }

    @RequestMapping(value={"/ie9"}, method={RequestMethod.POST})
    public void ie9Sucks(HttpServletResponse response, @RequestParam(value="b64") String b64, @RequestParam(value="fileName") String fileName) throws IOException {
        File tempFile;
        block8: {
            tempFile = File.createTempFile(fileName, ".tmp");
            tempFile.deleteOnExit();
            byte[] decoded = ReportController.base64Decoding(b64);
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(tempFile);
                    fos.write(decoded);
                }
                catch (IOException ex) {
                    LOGGER.error(ex.getMessage(), (Throwable)ex);
                    if (fos != null) {
                        fos.close();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    fos.close();
                }
                throw throwable;
            }
            if (fos != null) {
                fos.close();
            }
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(tempFile));
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".docx");
        IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        response.flushBuffer();
        ((InputStream)in).close();
    }

    private void populateTagsIfRequired(Report report, Model model) {
        Input[] inputArray = report.getForm();
        int n = inputArray.length;
        int n2 = 0;
        while (n2 < n) {
            Input input = inputArray[n2];
            if (input.getType() == InputType.RADIO_BUTTONS_GROUP) {
                RadioButtonsGroup container = (RadioButtonsGroup)input;
                this.fillAvailableTags(container, model);
            }
            ++n2;
        }
    }

    private void fillAvailableTags(RadioButtonsGroup container, Model model) {
        for (OptionInput opt : container.getOptions()) {
            if (!(opt instanceof TagPickerOption)) continue;
            String entityType = ((TagPickerOption)opt).getPickerBoundEntity();
            List<String> availableTags = this.getPossibleTagValues(entityType);
            if (availableTags.isEmpty()) {
                availableTags = null;
            }
            model.addAttribute("availableTags", availableTags);
            return;
        }
    }

    public List<String> getPossibleTagValues(String boundEntity) {
        List projectIds = (List)CollectionUtils.collect((Collection)this.projectFinder.findAllOrderedByName(), (Transformer)new IdCollector());
        return this.customFieldFinder.getAvailableTagsForEntity(boundEntity, projectIds);
    }
}

