/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.projectfilter;

import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.projectfilter.ProjectFilter;
import org.squashtest.tm.service.internal.dto.FilterModel;
import org.squashtest.tm.service.project.ProjectFilterModificationService;

@Controller
@RequestMapping(value={"/global-filter"})
public class ProjectFilterController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectFilterController.class);
    @Inject
    private ProjectFilterModificationService projectFilterService;

    @ResponseBody
    @RequestMapping(value={"/filter"}, method={RequestMethod.GET})
    public FilterModel getProjects() {
        ProjectFilter filter = this.projectFilterService.findProjectFilterByUserLogin();
        List allProjects = this.projectFilterService.getAllProjects();
        return new FilterModel(filter, allProjects);
    }

    @ResponseBody
    @RequestMapping(value={"/filter"}, method={RequestMethod.POST})
    public void updateProjectFilter(@RequestBody ProjectFilterModel projectFilterModel) {
        List<Long> ids = projectFilterModel == null ? new LinkedList<Long>() : projectFilterModel.getProjectIds();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("UserPreferenceController : {} projects selected", (Object)ids.size());
        }
        this.projectFilterService.saveOrUpdateProjectFilter(ids, true);
    }

    @ResponseBody
    @RequestMapping(value={"/filter-status"}, params={"isEnabled"}, method={RequestMethod.POST})
    public void setProjectFilterStatus(@RequestParam(value="isEnabled") boolean isEnabled) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("UserPreferenceController : filter enabled to " + isEnabled);
        }
        this.projectFilterService.updateProjectFilterStatus(isEnabled);
    }

    @ResponseBody
    @RequestMapping(value={"/filter-status"}, method={RequestMethod.GET})
    public FilterModel getProjectFilterStatus() {
        ProjectFilter filter = this.projectFilterService.findProjectFilterByUserLogin();
        FilterModel model = new FilterModel();
        model.setEnabled(filter.getActivated().booleanValue());
        return model;
    }

    public static class ProjectFilterModel {
        private List<Long> projectIds;

        public void setProjectIds(List<Long> projectIds) {
            this.projectIds = projectIds;
        }

        public List<Long> getProjectIds() {
            return this.projectIds;
        }
    }
}

