/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.project;

import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.project.ProjectTemplateFinder;
import org.squashtest.tm.service.project.ProjectTemplateManagerService;
import org.squashtest.tm.web.internal.controller.project.GenericProjectController;
import org.squashtest.tm.web.internal.model.json.JsonTemplateFromProject;
import org.squashtest.tm.web.internal.model.json.JsonUrl;

@Controller
@RequestMapping(value={"/project-templates"})
public class ProjectTemplateController {
    @Inject
    private ProjectTemplateFinder projectFinder;
    @Inject
    private ProjectTemplateManagerService projectTemplateManagerService;
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericProjectController.class);

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, params={"dropdownList"})
    public List<NamedReference> getTemplateDropdownModel() {
        return this.projectFinder.findAllReferences();
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    public JsonUrl createTemplateFromProject(@Valid @RequestBody JsonTemplateFromProject jsonTemplateFromProject) {
        try {
            this.projectTemplateManagerService.addTemplateFromProject(jsonTemplateFromProject.getProjectTemplate(), jsonTemplateFromProject.getTemplateId(), jsonTemplateFromProject.getParams());
        }
        catch (NameAlreadyInUseException ex) {
            ex.setObjectName("add-template-from-project");
            throw ex;
        }
        return this.getUrlToProjectInfoPage((GenericProject)jsonTemplateFromProject.getProjectTemplate());
    }

    private JsonUrl getUrlToProjectInfoPage(GenericProject project) {
        UriComponents uri = ServletUriComponentsBuilder.fromCurrentContextPath().path("/administration/projects/{id}/info").buildAndExpand(new Object[]{project.getId()});
        return new JsonUrl(uri.toString());
    }
}

