/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.project;

import java.text.MessageFormat;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.project.ProjectManagerService;
import org.squashtest.tm.web.internal.model.json.JsonProjectFromTemplate;

@Controller
@RequestMapping(value={"/projects"})
public class ProjectController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectController.class);
    @Inject
    private ProjectManagerService projectManager;
    @Inject
    private GenericProjectManagerService genericProjectManager;

    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.PUT})
    public void coerceProjectIntoTemplate(@RequestBody Map<String, Object> payload, @PathVariable long projectId) {
        long payloadProjectId;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PUTting project/{} with payload {}", (Object)projectId, payload);
        }
        if ((payloadProjectId = (long)((Integer)payload.get("templateId")).intValue()) != projectId) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot coerce Project into ProjectTemplate : project id {0} is not the same as template id {1}", projectId, payloadProjectId));
        }
        this.genericProjectManager.coerceProjectIntoTemplate(projectId);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    public void createProjectFromTemplate(@Valid @RequestBody JsonProjectFromTemplate jsonProjectFromTemplate) {
        try {
            if (jsonProjectFromTemplate.isFromTemplate()) {
                this.projectManager.addProjectFromTemplate(jsonProjectFromTemplate.getProject(), jsonProjectFromTemplate.getTemplateId(), jsonProjectFromTemplate.getParams());
            } else {
                this.genericProjectManager.persist((GenericProject)jsonProjectFromTemplate.getProject());
            }
        }
        catch (NameAlreadyInUseException ex) {
            ex.setObjectName("add-project-from-template");
            throw ex;
        }
    }
}

