/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.project;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriComponents;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.api.wizard.WorkspaceWizard;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.core.foundation.collection.Filtering;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndMultiSorting;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.SinglePageCollectionHolder;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.LibraryPluginBinding;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.NoBugTrackerBindingException;
import org.squashtest.tm.exception.user.LoginDoNotExistException;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.internal.project.ProjectHelper;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.testautomation.TestAutomationProjectFinderService;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;
import org.squashtest.tm.web.internal.controller.administration.PartyPermissionDatatableModelHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableFiltering;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableMultiSorting;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.model.json.JsonGeneralInfo;
import org.squashtest.tm.web.internal.model.json.JsonUrl;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;
import org.squashtest.tm.web.internal.plugins.manager.automationworkflow.AutomationWorkflowPluginManager;
import org.squashtest.tm.web.internal.plugins.manager.wizard.WorkspaceWizardManager;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/generic-projects"})
public class GenericProjectController {
    private static final String LABEL = "label";
    private static final String ACTIVE = "active";
    private static final String HABILITATION = "habilitation";
    private static final String BUGTRACKER = "bugtracker";
    private static final String AUTOMATION = "automation";
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private GenericProjectManagerService projectManager;
    @Inject
    private BugTrackerFinderService bugtrackerFinderService;
    @Inject
    private TestAutomationProjectFinderService testAutomationProjectFinder;
    @Inject
    private WorkspaceWizardManager pluginManager;
    @Inject
    private AutomationWorkflowPluginManager workflowPluginManager;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private TestAutomationServerManagerService testAutomationServerManagerService;
    @Inject
    private TaskExecutor taskExecutor;
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericProjectController.class);
    private static final String PROJECT_ID_URL = "/{projectId}";
    private static final String PROJECT_BUGTRACKER_NAME_UNDEFINED = "project.bugtracker.name.undefined";
    private DatatableMapper<String> allProjectsMapper = new NameBasedMapper(9).map("name", "name").map("label", "label").map("active", "active").map("created-on", "audit.createdOn").map("created-by", "audit.createdBy").map("last-mod-on", "audit.lastModifiedOn").map("last-mod-by", "audit.lastModifiedBy").map("habilitation", "habilitation").map("bugtracker", "bugtracker").map("automation", "automation");
    private DatatableMapper<String> partyPermissionMapper = new NameBasedMapper(5).map("party-index", "index").map("party-id", "id").map("party-name", "name").map("party-type", "type").map("permission-group.qualifiedName", "qualifiedName");

    @ResponseBody
    @RequestMapping(value={""}, params={"sEcho"}, method={RequestMethod.GET})
    public DataTableModel getProjectsTableModel(DataTableDrawParameters params, Locale locale) {
        DataTableMultiSorting sorter = new DataTableMultiSorting(params, this.allProjectsMapper);
        DataTableFiltering filtering = new DataTableFiltering(params);
        PagedCollectionHolder holder = this.projectManager.findSortedProjects((PagingAndMultiSorting)sorter, (Filtering)filtering);
        return new ProjectDataTableModelHelper(locale, this.messageSource, this.projectManager).buildDataModel(holder, params.getsEcho());
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    public void createNewProject(@Valid @RequestBody Project project) {
        try {
            this.projectManager.persist((GenericProject)project);
        }
        catch (NameAlreadyInUseException ex) {
            ex.setObjectName("add-project-from-template");
            throw ex;
        }
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @RequestMapping(value={"/new-template"}, method={RequestMethod.POST})
    public JsonUrl createNewTemplate(@RequestBody @Valid ProjectTemplate template) {
        try {
            this.projectManager.persist((GenericProject)template);
        }
        catch (NameAlreadyInUseException ex) {
            ex.setObjectName("add-template");
            throw ex;
        }
        return this.getUrlToProjectInfoPage((GenericProject)template);
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.POST}, params={"id=project-label", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String changeLabel(@RequestParam(value="value") String projectLabel, @PathVariable long projectId) {
        this.projectManager.changeLabel(projectId, projectLabel);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("project " + projectId + ": updated label to " + projectLabel);
        }
        return HtmlUtils.htmlEscape((String)projectLabel);
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.POST}, params={"newName"})
    @ResponseBody
    public Object changeName(@PathVariable long projectId, @RequestParam String newName) {
        this.projectManager.changeName(projectId, newName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Project modification : renaming {} as {}", (Object)projectId, (Object)newName);
        }
        return new RenameModel(HtmlUtils.htmlEscape((String)newName));
    }

    @RequestMapping(value={"/{projectId}/associate-template"}, method={RequestMethod.POST})
    @ResponseBody
    public void associateTemplate(@PathVariable long projectId, @RequestParam long templateId) {
        this.projectManager.associateToTemplate(projectId, templateId);
        LOGGER.info("Project modification : associating {} with template {}", (Object)projectId, (Object)templateId);
    }

    @RequestMapping(value={"/{projectId}/disassociate-template"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void disassociateTemplate(@PathVariable long projectId) {
        this.projectManager.disassociateFromTemplate(projectId);
        LOGGER.info("Disassociating project of ID {} from its template.", (Object)projectId);
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.POST}, params={"isActive"})
    @ResponseBody
    public Active changeActive(@PathVariable long projectId, @RequestParam boolean isActive) {
        this.projectManager.changeActive(projectId, isActive);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Project modification : change project {} is active = {}", (Object)projectId, (Object)isActive);
        }
        return new Active(isActive);
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.POST}, params={"id=project-bugtracker", "value"})
    @ResponseBody
    public String changeBugtracker(@RequestParam(value="value") Long bugtrackerId, @PathVariable long projectId, Locale locale) {
        String toReturn;
        if (bugtrackerId > 0L) {
            toReturn = HtmlUtils.htmlEscape((String)this.bugtrackerFinderService.findBugtrackerName(bugtrackerId));
            this.projectManager.changeBugTracker(projectId, bugtrackerId);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Project {} : bugtracker changed, new value : {}", (Object)projectId, (Object)bugtrackerId);
            }
        } else {
            toReturn = this.messageSource.internationalize(PROJECT_BUGTRACKER_NAME_UNDEFINED, locale);
            this.projectManager.removeBugTracker(projectId);
        }
        return toReturn;
    }

    @RequestMapping(value={"/{projectId}/bugtracker/projectName"}, method={RequestMethod.POST})
    @ResponseBody
    public List<String> changeBugtrackerProjectName(@RequestBody List<String> projectBugTrackerNames, @PathVariable long projectId) {
        this.projectManager.changeBugTrackerProjectName(projectId, projectBugTrackerNames);
        return projectBugTrackerNames;
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.POST}, params={"id=project-description", "value"})
    @ResponseBody
    public String changeDescription(@RequestParam(value="value") String projectDescription, @PathVariable long projectId) {
        this.projectManager.changeDescription(projectId, projectDescription);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("project " + projectId + ": updated description to " + projectDescription);
        }
        return HTMLCleanupUtils.cleanHtml(projectDescription);
    }

    @RequestMapping(value={"/{projectId}/bugtracker/projectName"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getBugtrackerProject(@PathVariable long projectId) {
        GenericProject project = this.projectManager.findById(projectId);
        if (project.isBugtrackerConnected()) {
            return project.getBugtrackerBinding().getProjectNames();
        }
        throw new NoBugTrackerBindingException();
    }

    @RequestMapping(value={"/{projectId}/general"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonGeneralInfo refreshGeneralInfos(@PathVariable long projectId) {
        GenericProject project = this.projectManager.findById(projectId);
        return new JsonGeneralInfo((AuditableMixin)project);
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteProject(@PathVariable long projectId) {
        this.projectManager.deleteProject(projectId);
    }

    @RequestMapping(value={"/{projectId}/description"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getDescription(@PathVariable long projectId) {
        GenericProject genericProject = this.projectManager.findById(projectId);
        return HTMLCleanupUtils.cleanHtml(genericProject.getDescription());
    }

    @RequestMapping(value={"/{projectId}/unbound-parties"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> getPermissionPopup(@PathVariable long projectId) {
        List partyList = this.projectManager.findPartyWithoutPermissionByProject(projectId);
        ArrayList<Map<String, Object>> partiesModel = new ArrayList<Map<String, Object>>(partyList.size());
        for (Party p : partyList) {
            HashMap<String, Object> newModel = new HashMap<String, Object>();
            newModel.put(LABEL, HTMLCleanupUtils.cleanAndUnescapeHTML(p.getName()));
            newModel.put("value", HTMLCleanupUtils.cleanAndUnescapeHTML(p.getName()));
            newModel.put("id", p.getId());
            partiesModel.add(newModel);
        }
        return partiesModel;
    }

    @ResponseBody
    @RequestMapping(value={"/{projectId}/parties/{partyId}/permissions/{permission}"}, method={RequestMethod.PUT})
    public void addNewPermissionWithPartyId(@PathVariable long partyId, @PathVariable long projectId, @PathVariable String permission) {
        Party party = this.projectManager.findPartyById(partyId);
        if (party == null) {
            throw new LoginDoNotExistException();
        }
        this.projectManager.addNewPermissionToProject(party.getId().longValue(), projectId, permission);
    }

    @RequestMapping(value={"/{projectId}/party-permissions"}, method={RequestMethod.GET})
    @ResponseBody
    public DataTableModel getPartyPermissionTable(DataTableDrawParameters params, @PathVariable(value="projectId") long projectId, Locale locale) {
        DataTableSorting sorting = new DataTableSorting(params, this.partyPermissionMapper);
        DataTableFiltering filtering = new DataTableFiltering(params);
        PagedCollectionHolder partyPermissions = this.projectManager.findPartyPermissionsBeanByProject((PagingAndSorting)sorting, (Filtering)filtering, projectId);
        return new PartyPermissionDatatableModelHelper(locale, this.messageSource).buildDataModel(partyPermissions, params.getsEcho());
    }

    @ResponseBody
    @RequestMapping(value={"/{projectId}/parties/{partyId}/permissions/{permission}"}, method={RequestMethod.POST})
    public void addNewPartyPermission(@PathVariable long partyId, @PathVariable long projectId, @PathVariable String permission) {
        this.projectManager.addNewPermissionToProject(partyId, projectId, permission);
    }

    @ResponseBody
    @RequestMapping(value={"/{projectId}/parties/{partyId}/permissions"}, method={RequestMethod.DELETE})
    public void removePartyPermission(@PathVariable long partyId, @PathVariable long projectId) {
        this.projectManager.removeProjectPermission(partyId, projectId);
    }

    @RequestMapping(value={"/{projectId}/test-automation-server"}, method={RequestMethod.POST}, params={"serverId"})
    @ResponseBody
    public TestAutomationServer bindTestAutomationServer(@PathVariable(value="projectId") long projectId, @RequestParam(value="serverId") long serverId) {
        if (serverId == 0L) {
            this.projectManager.bindTestAutomationServer(projectId, null);
            return null;
        }
        this.projectManager.bindTestAutomationServer(projectId, Long.valueOf(serverId));
        return this.testAutomationServerManagerService.findById(serverId);
    }

    @RequestMapping(value={"/{projectId}/test-automation-projects"}, method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getAutomatedProjectsTableModel(@PathVariable long projectId, DataTableDrawParameters params) {
        return this.internalAutomatedProjectsTableModel(projectId, params);
    }

    private DataTableModel internalAutomatedProjectsTableModel(long projectId, DataTableDrawParameters params) {
        List taProjects = this.projectManager.findBoundTestAutomationProjects(projectId);
        SinglePageCollectionHolder holder = new SinglePageCollectionHolder((Collection)taProjects);
        Map jobUrls = this.testAutomationProjectFinder.findProjectUrls((Collection)taProjects);
        return new TestAutomationTableModel(jobUrls).buildDataModel(holder, params.getsEcho());
    }

    @RequestMapping(value={"/{projectId}/test-automation-projects/new"}, method={RequestMethod.POST})
    @ResponseBody
    public void addTestAutomationProject(@PathVariable long projectId, @RequestBody TestAutomationProject[] projects) throws BindException {
        this.projectManager.bindTestAutomationProjects(projectId, Arrays.asList(projects));
    }

    @RequestMapping(value={"/{projectId}/test-automation-projects/{taProjectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindProject(@PathVariable long projectId, @PathVariable long taProjectId) {
        this.projectManager.unbindTestAutomationProject(projectId, taProjectId);
    }

    @RequestMapping(value={"/{projectId}/available-ta-projects"}, method={RequestMethod.GET}, params={"login", "password"})
    @ResponseBody
    public Collection<TestAutomationProject> getAvailableTAProjectsWithCredentials(@RequestParam(value="login") String login, @RequestParam(value="password") String password, @PathVariable long projectId) throws BindException {
        return this.projectManager.findAllAvailableTaProjectsWithCredentials(projectId, login, password);
    }

    @RequestMapping(value={"/{projectId}/available-ta-projects"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<TestAutomationProject> getAvailableTAProjects(@PathVariable long projectId) throws BindException {
        return this.projectManager.findAllAvailableTaProjects(projectId);
    }

    @ResponseBody
    @RequestMapping(value={"/{projectId}/bdd-impl-technology"}, method={RequestMethod.POST})
    public void changeBddImplTechnology(@PathVariable long projectId, @RequestParam String bddImplTechnology) {
        this.projectManager.changeBddImplTechnology(projectId, bddImplTechnology);
    }

    @ResponseBody
    @RequestMapping(value={"/{projectId}/bdd-script-language"}, method={RequestMethod.POST})
    public void changeBddScriptLanguage(@PathVariable long projectId, @RequestParam String bddScriptLanguage) {
        this.projectManager.changeBddScriptLanguage(projectId, bddScriptLanguage);
    }

    @ResponseBody
    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.POST}, params={"id=automated-suites-lifetime", "value"})
    public String changeAutomatedSuitesLifetime(@PathVariable long projectId, @RequestParam(value="value") String automatedSuitesLifetime) {
        Integer newLifetime = this.projectManager.changeAutomatedSuitesLifetime(projectId, automatedSuitesLifetime);
        if (Objects.isNull(newLifetime)) {
            return "";
        }
        return String.valueOf(newLifetime);
    }

    @RequestMapping(value={"/{projectId}/scm-repository"}, method={RequestMethod.POST})
    @ResponseBody
    public void bindScmRepository(@PathVariable long projectId, @RequestParam long scmRepositoryId) {
        this.projectManager.bindScmRepository(projectId, scmRepositoryId);
    }

    @RequestMapping(value={"/{projectId}/scm-repository"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindScmRepository(@PathVariable long projectId) {
        this.projectManager.unbindScmRepository(projectId);
    }

    @RequestMapping(value={"/{projectId}/plugins"}, method={RequestMethod.DELETE}, params={"saveConf"})
    @ResponseBody
    public void disablePluginAutomationWorkflow(@PathVariable long projectId, @RequestParam(value="saveConf") Boolean saveConf) {
        LibraryPluginBinding lpb = this.projectDao.findPluginForProject(Long.valueOf(projectId), PluginType.AUTOMATION);
        if (lpb != null) {
            WorkspaceWizard plugin = this.pluginManager.findById(lpb.getPluginId());
            if (saveConf.booleanValue()) {
                this.projectManager.disablePluginAndSaveConf(projectId, Collections.singletonList(WorkspaceType.TEST_CASE_WORKSPACE), plugin.getId());
            } else {
                this.projectManager.disablePluginForWorkspace(projectId, Collections.singletonList(WorkspaceType.TEST_CASE_WORKSPACE), plugin.getId());
            }
        }
    }

    @RequestMapping(value={"/{projectId}/plugins/{pluginId}"}, method={RequestMethod.POST})
    @ResponseBody
    public void enablePlugin(@PathVariable long projectId, @PathVariable String pluginId) {
        WorkspaceWizard wizard = this.pluginManager.findById(pluginId);
        this.projectManager.enablePluginForWorkspace(projectId, wizard.getDisplayWorkspace(), pluginId, wizard.getPluginType());
    }

    @RequestMapping(value={"/{projectId}/plugins/{pluginId}"}, method={RequestMethod.DELETE}, params={"saveConf"})
    @ResponseBody
    public void disablePlugin(@PathVariable long projectId, @PathVariable String pluginId, @RequestParam(value="saveConf") Boolean saveConf) {
        WorkspaceWizard plugin = this.pluginManager.findById(pluginId);
        List<WorkspaceType> workspaceTypes = "squash.tm.plugin.jirasync".equals(pluginId) ? Arrays.asList(WorkspaceType.CAMPAIGN_WORKSPACE, WorkspaceType.REQUIREMENT_WORKSPACE) : Collections.singletonList(plugin.getDisplayWorkspace());
        if (saveConf.equals(true)) {
            this.projectManager.disablePluginAndSaveConf(projectId, workspaceTypes, plugin.getId());
            this.projectManager.setAllSyncToDisable(projectId);
        } else {
            if ("squash.tm.plugin.jirasync".equals(pluginId)) {
                if (this.projectManager.hasProjectRemoteSynchronisation(projectId)) {
                    this.projectManager.deleteAllSync(projectId);
                }
            } else if (pluginId.contains("workflow.automjira")) {
                this.projectManager.deleteAllRemoteAutomationRequestExtenders(projectId);
            }
            this.projectManager.disablePluginForWorkspace(projectId, workspaceTypes, pluginId);
        }
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public void changeEx(@PathVariable long projectId, @RequestParam(value="value") boolean active) {
        this.projectManager.changeAllowTcModifDuringExec(projectId, active);
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.POST}, params={"id=project-automation-workflow", "value"})
    @ResponseBody
    public void changeAutomationWorkflow(@PathVariable long projectId, @RequestParam(value="value") boolean active) {
        this.projectManager.changeAutomationWorkflow(projectId, active);
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.POST}, params={"id=change-automation-workflow", "value"})
    @ResponseBody
    public void changeAutomationWorkflow(@PathVariable long projectId, @RequestParam(value="value") String automationWorkflowtype) {
        AutomationWorkflowType automationWorkflow = AutomationWorkflowType.valueOf((String)automationWorkflowtype);
        if (!this.workflowPluginManager.getAutomationWorkflowsType().contains(automationWorkflow)) {
            throw new IllegalArgumentException("The automation workflow type with code " + automationWorkflow + " is not valid.");
        }
        this.projectManager.changeAutomationWorkflow(projectId, automationWorkflowtype);
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.POST}, params={"id=tree-structure-in-scm-repo", "value"})
    @ResponseBody
    public void changeUseTreeStructureInScmRepo(@PathVariable long projectId, @RequestParam(value="value") boolean activated) {
        this.projectManager.changeUseTreeStructureInScmRepo(projectId, activated);
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.GET}, params={"id=project-automation-workflow"})
    @ResponseBody
    public boolean checkIfTcGherkinHaveTaScript(@PathVariable long projectId) {
        return this.projectManager.checkIfTcGherkinHaveTaScript(Long.valueOf(projectId));
    }

    @RequestMapping(value={"/{projectId}/disable-execution-status/{executionStatus}"}, method={RequestMethod.POST})
    @ResponseBody
    public void disableExecutionStatusOnProject(@PathVariable long projectId, @PathVariable String executionStatus) {
        this.projectManager.disableExecutionStatus(projectId, ExecutionStatus.valueOf((String)executionStatus));
    }

    @RequestMapping(value={"/{projectId}/enable-execution-status/{executionStatus}"}, method={RequestMethod.POST})
    @ResponseBody
    public void enableExecutionStatusOnProject(@PathVariable long projectId, @PathVariable String executionStatus) {
        this.projectManager.enableExecutionStatus(projectId, ExecutionStatus.valueOf((String)executionStatus));
    }

    @RequestMapping(value={"/{projectId}/is-enabled-execution-status/{executionStatus}"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isExecutionStatusEnabledForProject(@PathVariable long projectId, @PathVariable String executionStatus) {
        return this.projectManager.isExecutionStatusEnabledForProject(projectId, ExecutionStatus.valueOf((String)executionStatus));
    }

    @RequestMapping(value={"/{projectId}/execution-status-is-used/{executionStatus}"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean projectUsesExecutionStatus(@PathVariable long projectId, @PathVariable String executionStatus) {
        return this.projectManager.projectUsesExecutionStatus(projectId, ExecutionStatus.valueOf((String)executionStatus));
    }

    @RequestMapping(value={"/{projectId}/execution-status/{executionStatus}"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getStatusPopup(@PathVariable long projectId, @PathVariable String executionStatus, Locale locale) {
        Set statuses = this.projectManager.enabledExecutionStatuses(projectId);
        ExecutionStatus status = ExecutionStatus.valueOf((String)executionStatus);
        statuses.remove(status);
        HashMap<String, Object> options = new HashMap<String, Object>();
        for (ExecutionStatus st : statuses) {
            options.put(this.messageSource.internationalize(st.getI18nKey(), locale), st.name());
        }
        return options;
    }

    @RequestMapping(value={"/{projectId}/replace-execution-status"}, method={RequestMethod.POST})
    @ResponseBody
    public void replaceStatusWithinProject(@PathVariable long projectId, @RequestParam String sourceExecutionStatus, @RequestParam String targetExecutionStatus) {
        ExecutionStatus source = ExecutionStatus.valueOf((String)sourceExecutionStatus);
        ExecutionStatus target = ExecutionStatus.valueOf((String)targetExecutionStatus);
        AsynchronousReplaceExecutionStatus replacer = new AsynchronousReplaceExecutionStatus(projectId, source, target);
        this.taskExecutor.execute((Runnable)replacer);
    }

    private JsonUrl getUrlToProjectInfoPage(GenericProject project) {
        UriComponents uri = ServletUriComponentsBuilder.fromCurrentContextPath().path("/administration/projects/{id}/info").buildAndExpand(new Object[]{project.getId()});
        return new JsonUrl(uri.toString());
    }

    private static final class Active {
        private Boolean isActive;

        private Active(Boolean active) {
            this.isActive = active;
        }

        public Boolean isActive() {
            return this.isActive;
        }
    }

    private class AsynchronousReplaceExecutionStatus
    implements Runnable {
        private Long projectId;
        private ExecutionStatus sourceExecutionStatus;
        private ExecutionStatus targetExecutionStatus;

        public AsynchronousReplaceExecutionStatus(Long projectId, ExecutionStatus sourceExecutionStatus, ExecutionStatus targetExecutionStatus) {
            this.projectId = projectId;
            this.sourceExecutionStatus = sourceExecutionStatus;
            this.targetExecutionStatus = targetExecutionStatus;
        }

        @Override
        public void run() {
            GenericProjectController.this.projectManager.replaceExecutionStepStatus(this.projectId.longValue(), this.sourceExecutionStatus, this.targetExecutionStatus);
        }
    }

    private static final class ProjectDataTableModelHelper
    extends DataTableModelBuilder<GenericProject> {
        private InternationalizationHelper messageSource;
        private Locale locale;
        private GenericProjectManagerService projectManager;

        private ProjectDataTableModelHelper(Locale locale, InternationalizationHelper messageSource, GenericProjectManagerService projectManager) {
            this.locale = locale;
            this.messageSource = messageSource;
            this.projectManager = projectManager;
        }

        @Override
        public Object buildItemData(GenericProject project) {
            HashMap<String, Object> data = new HashMap<String, Object>(14);
            GenericProject auditable = project;
            data.put("project-id", project.getId());
            data.put("index", this.getCurrentIndex());
            data.put("name", HtmlUtils.htmlEscape((String)project.getName()));
            data.put(GenericProjectController.ACTIVE, this.messageSource.internationalizeYesNo(project.isActive(), this.locale));
            data.put(GenericProjectController.LABEL, HTMLCleanupUtils.escapeOrDefault(project.getLabel(), ""));
            data.put("created-on", this.messageSource.localizeDate(auditable.getCreatedOn(), this.locale));
            data.put("created-by", HtmlUtils.htmlEscape((String)auditable.getCreatedBy()));
            data.put("last-mod-on", this.messageSource.localizeDate(auditable.getLastModifiedOn(), this.locale));
            data.put("last-mod-by", HTMLCleanupUtils.escapeOrDefault(auditable.getLastModifiedBy(), null));
            data.put("raw-type", ProjectHelper.isTemplate((GenericProject)project) ? "template" : "project");
            data.put("type", "&nbsp;");
            data.put(GenericProjectController.HABILITATION, this.messageSource.internationalizeYesNo(this.hasPermissions(project), this.locale));
            data.put(GenericProjectController.BUGTRACKER, this.getBugtrackerKind(project));
            data.put(GenericProjectController.AUTOMATION, this.messageSource.internationalizeYesNo(project.isTestAutomationEnabled(), this.locale));
            return data;
        }

        private boolean hasPermissions(GenericProject project) {
            boolean hasPermissions = true;
            if (this.projectManager.findPartyPermissionsBeansByProject(project.getId().longValue()).isEmpty()) {
                hasPermissions = false;
            }
            return hasPermissions;
        }

        private String getBugtrackerKind(GenericProject project) {
            String bugtrackerKind = project.isBugtrackerConnected() ? project.getBugtrackerBinding().getBugtracker().getKind() : this.messageSource.noData(this.locale);
            return bugtrackerKind;
        }
    }

    private static final class TestAutomationTableModel
    extends DataTableModelBuilder<TestAutomationProject> {
        private Map<String, URL> jobUrls;

        public TestAutomationTableModel(Map<String, URL> jobUrls) {
            this.jobUrls = jobUrls;
        }

        protected Map<String, ?> buildItemData(TestAutomationProject item) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("entity-id", item.getId());
            res.put("entity-index", this.getCurrentIndex());
            res.put(GenericProjectController.LABEL, HtmlUtils.htmlEscape((String)item.getLabel()));
            res.put("jobName", HtmlUtils.htmlEscape((String)item.getJobName()));
            res.put("slaves", HtmlUtils.htmlEscape((String)item.getSlaves()));
            res.put("url", this.jobUrls.get(item.getJobName()));
            res.put("gherkin", item.isCanRunGherkin());
            res.put("empty-delete-holder", " ");
            res.put("empty-edit-holder", " ");
            return res;
        }
    }
}

