/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.milestone;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.web.internal.controller.milestone.MetaMilestone;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

public class TestCaseBoundMilestoneTableModelHelper
extends DataTableModelBuilder<MetaMilestone> {
    private InternationalizationHelper i18nHelper;
    private Locale locale;

    public TestCaseBoundMilestoneTableModelHelper(InternationalizationHelper i18nHelper, Locale locale) {
        this.i18nHelper = i18nHelper;
        this.locale = locale;
    }

    protected Map<String, Object> buildItemData(MetaMilestone item) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        String date = this.i18nHelper.localizeShortDate(item.getEndDate(), this.locale);
        String status = this.formatStatus(item.getStatus());
        row.put("entity-index", this.getCurrentIndex());
        row.put("entity-id", item.getId());
        row.put("directMember", item.isDirectMembership());
        row.put("status", status);
        row.put("label", HtmlUtils.htmlEscape((String)item.getLabel()));
        row.put("date", date);
        row.put("description", HTMLCleanupUtils.cleanHtml(item.getDescription()));
        row.put("empty-delete-holder", null);
        row.put("isStatusAllowUnbind", item.isStatusAllowUnbind());
        return row;
    }

    private String formatStatus(MilestoneStatus status) {
        return this.i18nHelper.internationalize((Internationalizable)status, this.locale);
    }
}

