/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.milestone;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneMember;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.dto.json.JsonMilestone;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneFinderService;
import org.squashtest.tm.service.testcase.TestCaseFinder;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;

@Component
public class MilestoneUIConfigurationService {
    private static final String RES_TYPE = "restype";
    private static final String RES_ID = "resid";
    @Inject
    MilestoneFinderService milestoneFinder;
    @Inject
    FeatureManager featureManager;
    @Inject
    TestCaseFinder testCaseFinder;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;

    public MilestoneFeatureConfiguration configure(TestCase testcase) {
        MilestoneFeatureConfiguration conf = this.createCommonConf((MilestoneMember)testcase);
        Map<String, String> identity = this.createIdentity(testcase);
        conf.setIdentity(identity);
        boolean locked = this.isMilestoneLocked(testcase);
        conf.setMilestoneLocked(locked);
        return conf;
    }

    public MilestoneFeatureConfiguration configure(RequirementVersion version) {
        MilestoneFeatureConfiguration conf = this.createCommonConf((MilestoneMember)version);
        Map<String, String> identity = this.createIdentity(version);
        conf.setIdentity(identity);
        return conf;
    }

    public MilestoneFeatureConfiguration configure(Campaign campaign) {
        MilestoneFeatureConfiguration conf = this.createCommonConf((MilestoneMember)campaign);
        Map<String, String> identity = this.createIdentity(campaign);
        conf.setIdentity(identity);
        return conf;
    }

    public MilestoneFeatureConfiguration configure(Iteration iteration) {
        MilestoneFeatureConfiguration conf = this.createCommonConf((MilestoneMember)iteration);
        Map<String, String> identity = this.createIdentity(iteration);
        conf.setIdentity(identity);
        return conf;
    }

    public MilestoneFeatureConfiguration configure(TestSuite testSuite) {
        MilestoneFeatureConfiguration conf = this.createCommonConf((MilestoneMember)testSuite);
        Map<String, String> identity = this.createIdentity(testSuite);
        conf.setIdentity(identity);
        return conf;
    }

    private MilestoneFeatureConfiguration createCommonConf(MilestoneMember member) {
        MilestoneFeatureConfiguration conf = new MilestoneFeatureConfiguration();
        Optional currentMilestone = this.activeMilestoneHolder.getActiveMilestone();
        JsonMilestone activeMilestone = new JsonMilestone();
        boolean globallyEnabled = this.featureManager.isEnabled(FeatureManager.Feature.MILESTONE);
        if (!globallyEnabled) {
            conf.setGloballyEnabled(false);
            return conf;
        }
        boolean locked = this.isMilestoneLocked(member);
        conf.setMilestoneLocked(locked);
        boolean userEnabled = currentMilestone.isPresent();
        if (!userEnabled) {
            conf.setUserEnabled(false);
        }
        int totalMilestones = member.getMilestones().size();
        conf.setTotalMilestones(totalMilestones);
        if (userEnabled && currentMilestone.isPresent()) {
            activeMilestone.setId(((Milestone)currentMilestone.get()).getId().longValue());
            activeMilestone.setLabel(((Milestone)currentMilestone.get()).getLabel());
            activeMilestone.setStatus(((Milestone)currentMilestone.get()).getStatus());
            conf.setActiveMilestone(activeMilestone);
        }
        return conf;
    }

    private boolean isMilestoneLocked(TestCase testCase) {
        boolean locked = false;
        Collection milestones = this.testCaseFinder.findAllMilestones(testCase.getId().longValue());
        for (Milestone m : milestones) {
            MilestoneStatus status = m.getStatus();
            if (status.isAllowObjectModification()) continue;
            locked = true;
            break;
        }
        return locked;
    }

    private boolean isMilestoneLocked(MilestoneMember member) {
        return member.doMilestonesAllowEdition() == false;
    }

    private Map<String, String> createIdentity(TestCase testCase) {
        HashMap<String, String> identity = new HashMap<String, String>();
        identity.put(RES_TYPE, "test-cases");
        identity.put(RES_ID, testCase.getId().toString());
        return identity;
    }

    private Map<String, String> createIdentity(Campaign campaign) {
        HashMap<String, String> identity = new HashMap<String, String>();
        identity.put(RES_TYPE, "campaigns");
        identity.put(RES_ID, campaign.getId().toString());
        return identity;
    }

    private Map<String, String> createIdentity(RequirementVersion version) {
        HashMap<String, String> identity = new HashMap<String, String>();
        identity.put(RES_TYPE, "requirements");
        identity.put(RES_ID, version.getRequirement().getId().toString());
        return identity;
    }

    private Map<String, String> createIdentity(Iteration iteration) {
        HashMap<String, String> identity = new HashMap<String, String>();
        identity.put(RES_TYPE, "iterations");
        identity.put(RES_ID, iteration.getId().toString());
        return identity;
    }

    private Map<String, String> createIdentity(TestSuite testSuite) {
        HashMap<String, String> identity = new HashMap<String, String>();
        identity.put(RES_TYPE, "test-suites");
        identity.put(RES_ID, testSuite.getId().toString());
        return identity;
    }
}

