/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.milestone;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.AdministrationService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneRangeComboDataBuilder;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneStatusComboDataBuilder;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.helper.LevelLabelFormatter;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/milestones/{milestoneId}"})
public class MilestoneModificationController {
    @Inject
    private MilestoneManagerService milestoneManager;
    @Inject
    private AdministrationService adminManager;
    @Inject
    private UserAccountService userService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private Provider<MilestoneStatusComboDataBuilder> statusComboDataBuilderProvider;
    @Inject
    private Provider<MilestoneRangeComboDataBuilder> rangeComboDataBuilderProvider;
    @Inject
    private Provider<LevelLabelFormatter> levelLabelFormatterProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(MilestoneModificationController.class);

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ModelAndView getProjectInfos(@PathVariable long milestoneId, Locale locale) {
        Milestone milestone = this.milestoneManager.findById(milestoneId);
        ModelAndView mav = new ModelAndView("page/milestones/milestone-info");
        mav.addObject("milestoneStatus", (Object)((MilestoneStatusComboDataBuilder)((MilestoneStatusComboDataBuilder)this.statusComboDataBuilderProvider.get()).useLocale(locale)).buildMarshalled());
        mav.addObject("milestone", (Object)milestone);
        mav.addObject("milestoneStatusLabel", (Object)this.formatStatus(locale, milestone.getStatus()));
        mav.addObject("milestoneRangeLabel", (Object)this.formatRange(locale, milestone.getRange()));
        mav.addObject("milestoneRange", (Object)((MilestoneRangeComboDataBuilder)((MilestoneRangeComboDataBuilder)this.rangeComboDataBuilderProvider.get()).useLocale(locale)).buildMarshalled());
        mav.addObject("userList", this.buildMarshalledUserMap(this.adminManager.findAllAdminOrManager()));
        mav.addObject("canEdit", (Object)this.milestoneManager.canEditMilestone(milestoneId));
        mav.addObject("isAdmin", (Object)this.permissionEvaluationService.hasRole("ROLE_ADMIN"));
        mav.addObject("currentUser", (Object)StringEscapeUtils.escapeEcmaScript((String)this.userService.findCurrentUser().getLogin()));
        return mav;
    }

    private Object buildMarshalledUserMap(List<User> activeUsersOrderedByLogin) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (User user : activeUsersOrderedByLogin) {
            map.put(HtmlUtils.htmlEscape((String)user.getLogin()), HtmlUtils.htmlEscape((String)user.getName()));
        }
        return JsonHelper.serialize(map);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=milestone-description", "value"})
    @ResponseBody
    public String changeDescription(@PathVariable long milestoneId, @RequestParam(value="value") String newDescription) {
        this.milestoneManager.verifyCanEditMilestone(milestoneId);
        this.milestoneManager.changeDescription(milestoneId, newDescription);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Milestone modification : change milestone {} description = {}", (Object)milestoneId, (Object)newDescription);
        }
        return HTMLCleanupUtils.cleanHtml(newDescription);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=milestone-status", "value"})
    @ResponseBody
    public String changeStatus(@PathVariable long milestoneId, @RequestParam(value="value") MilestoneStatus newStatus, Locale locale) {
        this.milestoneManager.verifyCanEditMilestone(milestoneId);
        this.milestoneManager.changeStatus(milestoneId, newStatus);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Milestone modification : change milestone {} Status = {}", (Object)milestoneId, (Object)newStatus);
        }
        return this.formatStatus(locale, newStatus);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=milestone-range", "value"})
    @ResponseBody
    public String changeRange(@PathVariable long milestoneId, @RequestParam(value="value") MilestoneRange newRange, Locale locale) {
        this.milestoneManager.verifyCanEditMilestoneRange();
        this.milestoneManager.changeRange(milestoneId, newRange);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Milestone modification : change milestone {} Range = {}", (Object)milestoneId, (Object)newRange);
        }
        return this.formatRange(locale, newRange);
    }

    private String formatStatus(Locale locale, MilestoneStatus status) {
        return ((LevelLabelFormatter)this.levelLabelFormatterProvider.get()).useLocale(locale).formatLabel((Level)status);
    }

    private String formatRange(Locale locale, MilestoneRange newRange) {
        return ((LevelLabelFormatter)this.levelLabelFormatterProvider.get()).useLocale(locale).formatLabel((Level)newRange);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"newEndDate"})
    @ResponseBody
    public Date changeEndDate(@PathVariable long milestoneId, @RequestParam @DateTimeFormat(pattern="yy-MM-dd") Date newEndDate) {
        this.milestoneManager.verifyCanEditMilestone(milestoneId);
        this.milestoneManager.changeEndDate(milestoneId, newEndDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Milestone modification : change milestone {} end date = {}", (Object)milestoneId, (Object)newEndDate);
        }
        return newEndDate;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=milestone-owner", "value"})
    @ResponseBody
    public String changeOwner(@PathVariable long milestoneId, @RequestParam(value="value") String login) {
        User newOwner = this.adminManager.findByLogin(login);
        this.milestoneManager.verifyCanEditMilestone(milestoneId);
        this.milestoneManager.changeOwner(milestoneId, newOwner);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Milestone modification : change milestone {} owner = {}", (Object)milestoneId, (Object)newOwner);
        }
        return newOwner.getName();
    }

    @RequestMapping(method={RequestMethod.POST}, params={"newName"})
    @ResponseBody
    public Object changeName(@PathVariable long milestoneId, @RequestParam String newName) {
        this.milestoneManager.verifyCanEditMilestone(milestoneId);
        this.milestoneManager.changeLabel(milestoneId, newName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Milestone modification : change milestone {} label = {}", (Object)milestoneId, (Object)newName);
        }
        return new RenameModel(newName);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"isBoundToTemplate"})
    @ResponseBody
    public boolean isBoundToATemplate(@PathVariable long milestoneId) {
        return this.milestoneManager.isBoundToATemplate(Long.valueOf(milestoneId));
    }

    @RequestMapping(method={RequestMethod.GET}, params={"isBoundToAtleastOneObject"})
    @ResponseBody
    public boolean isBoundToAtleastOneObject(@PathVariable long milestoneId) {
        return this.milestoneManager.isBoundToAtleastOneObject(milestoneId);
    }

    @RequestMapping(value={"/unbindallobjects"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindAllObjects(@PathVariable long milestoneId) {
        this.milestoneManager.unbindAllObjects(milestoneId);
    }
}

