/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.milestone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

public final class MilestoneModelUtils {
    private static final String SEPARATOR = ", ";

    private MilestoneModelUtils() {
    }

    public static String timeIntervalToString(Collection<Milestone> milestones, InternationalizationHelper i18nHelper, Locale locale) {
        if (milestones.isEmpty()) {
            return "--";
        }
        Date minDate = null;
        Date maxDate = null;
        for (Milestone m : milestones) {
            Date date = m.getEndDate();
            if (minDate == null || date.before(minDate)) {
                minDate = date;
            }
            if (maxDate != null && !date.after(maxDate)) continue;
            maxDate = date;
        }
        String strMindate = i18nHelper.localizeShortDate(minDate, locale);
        String strMaxdate = i18nHelper.localizeShortDate(maxDate, locale);
        if (!strMaxdate.equals(strMindate)) {
            return String.valueOf(strMindate) + " - " + strMaxdate;
        }
        return strMaxdate;
    }

    public static String milestoneLabelsOrderByDate(Set<Milestone> milestones) {
        final StringBuilder sb = new StringBuilder();
        ArrayList<Milestone> liste = new ArrayList<Milestone>(milestones);
        Collections.sort(liste, new Comparator<Milestone>(){

            @Override
            public int compare(Milestone m1, Milestone m2) {
                return m1.getEndDate().after(m2.getEndDate()) ? 1 : -1;
            }
        });
        CollectionUtils.forAllDo(liste, (Closure)new Closure(){

            public void execute(Object input) {
                Milestone m = (Milestone)input;
                sb.append(m.getLabel());
                sb.append(MilestoneModelUtils.SEPARATOR);
            }
        });
        sb.delete(Math.max(sb.length() - SEPARATOR.length(), 0), sb.length());
        return sb.toString();
    }
}

