/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.milestone;

import java.util.HashMap;
import java.util.Map;
import org.squashtest.tm.service.internal.dto.json.JsonMilestone;

public class MilestoneFeatureConfiguration {
    private boolean globallyEnabled = true;
    private boolean userEnabled = true;
    private boolean milestoneLocked = false;
    private int totalMilestones = 0;
    private Map<String, String> identity = new HashMap<String, String>();
    private JsonMilestone activeMilestone;

    public MilestoneFeatureConfiguration() {
    }

    public MilestoneFeatureConfiguration(boolean enabled) {
        this.globallyEnabled = enabled;
    }

    public MilestoneFeatureConfiguration(boolean globallyEnabled, boolean userEnabled, boolean milestoneLocked, int totalMilestones, Map<String, String> identity, JsonMilestone activeMilestone) {
        this.globallyEnabled = globallyEnabled;
        this.userEnabled = userEnabled;
        this.milestoneLocked = milestoneLocked;
        this.totalMilestones = totalMilestones;
        this.identity = identity;
        this.activeMilestone = activeMilestone;
    }

    public boolean isGloballyEnabled() {
        return this.globallyEnabled;
    }

    public boolean isNormalMode() {
        return !this.globallyEnabled;
    }

    public void setGloballyEnabled(boolean globallyEnabled) {
        this.globallyEnabled = globallyEnabled;
    }

    public boolean isUserEnabled() {
        return this.userEnabled;
    }

    public void setUserEnabled(boolean userEnabled) {
        this.userEnabled = userEnabled;
    }

    public boolean isEnabled() {
        return this.globallyEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.globallyEnabled = enabled;
    }

    public boolean isMilestoneLocked() {
        return this.milestoneLocked;
    }

    public void setMilestoneLocked(boolean milestoneLocked) {
        this.milestoneLocked = milestoneLocked;
    }

    public int getTotalMilestones() {
        return this.totalMilestones;
    }

    public void setTotalMilestones(int totalMilestones) {
        this.totalMilestones = totalMilestones;
    }

    public Map<String, String> getIdentity() {
        return this.identity;
    }

    public void setIdentity(Map<String, String> identity) {
        this.identity = identity;
    }

    public JsonMilestone getActiveMilestone() {
        return this.activeMilestone;
    }

    public void setActiveMilestone(JsonMilestone activeMilestone) {
        this.activeMilestone = activeMilestone;
    }

    public boolean isDisplayTab() {
        return this.globallyEnabled;
    }

    public boolean isMessagesEnabled() {
        return this.globallyEnabled;
    }

    public boolean isLocked() {
        return this.milestoneLocked;
    }

    public boolean isMultipleBindings() {
        return this.totalMilestones > 1;
    }

    public boolean isEditable() {
        return !this.isLocked();
    }

    public boolean isActiveMilestoneCreatable() {
        return this.activeMilestone != null ? this.activeMilestone.isCanCreateDelete() : true;
    }

    public boolean isMilestoneDatesColumnVisible() {
        return this.globallyEnabled;
    }

    public boolean isShowLockMessage() {
        return this.isMessagesEnabled() && this.isLocked();
    }

    public boolean isShowMultipleBindingMessage() {
        return this.isMessagesEnabled() && this.userEnabled && this.isEditable();
    }
}

