/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.milestone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.core.foundation.collection.SinglePageCollectionHolder;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.projectfilter.ProjectFilter;
import org.squashtest.tm.service.milestone.MilestoneFinderService;
import org.squashtest.tm.service.project.ProjectFilterModificationService;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneStatusComboDataBuilder;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneTableModelHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;

@Controller
@RequestMapping(value={"/milestones"})
public class MilestoneController {
    @Inject
    private Provider<MilestoneStatusComboDataBuilder> statusComboDataBuilderProvider;
    @Inject
    private MilestoneFinderService milestoneFinder;
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private ProjectFilterModificationService projectFilterService;
    public static final Comparator<Milestone> COMPARATOR = new Comparator<Milestone>(){

        @Override
        public int compare(Milestone o1, Milestone o2) {
            return o2.getEndDate().before(o1.getEndDate()) ? -1 : (o2.getEndDate().equals(o1.getEndDate()) ? 0 : 1);
        }
    };

    @RequestMapping(value={"/status-combo-data"}, method={RequestMethod.GET})
    @ResponseBody
    public String buildStatusComboData(Locale locale) {
        return ((MilestoneStatusComboDataBuilder)((MilestoneStatusComboDataBuilder)this.statusComboDataBuilderProvider.get()).useLocale(locale)).buildMarshalled();
    }

    @RequestMapping(params={"selectable"}, method={RequestMethod.GET})
    @ResponseBody
    public DataTableModel<Milestone> findUserSelectableMilestones() {
        ArrayList milestones = this.milestoneFinder.findAllVisibleToCurrentUser();
        ProjectFilter projectFilter = this.projectFilterService.findProjectFilterByUserLogin();
        if (projectFilter.isEnabled()) {
            Collection milestonesCollection = CollectionUtils.retainAll((Collection)milestones, this.getMilestoneFromProjectFilter(projectFilter));
            milestones = new ArrayList(0);
            milestones.addAll(milestonesCollection);
        }
        Collections.sort(milestones, COMPARATOR);
        SinglePageCollectionHolder holderCollection = new SinglePageCollectionHolder((Collection)milestones);
        Locale locale = LocaleContextHolder.getLocale();
        return new MilestoneTableModelHelper(this.i18nHelper, locale).buildDataModel(holderCollection, "0");
    }

    private Set<Milestone> getMilestoneFromProjectFilter(ProjectFilter projectFilter) {
        HashSet<Milestone> milestoneFiltered = new HashSet<Milestone>();
        List projects = projectFilter.getProjects();
        for (Project project : projects) {
            milestoneFiltered.addAll(project.getMilestones());
        }
        return milestoneFiltered;
    }
}

