/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.milestone;

import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.service.internal.project.ProjectHelper;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneStatusComboDataBuilder;

@Controller
@RequestMapping(value={"administration/projects/{projectId}/milestone-binding"})
public class MilestoneBindingManagerController {
    @Inject
    private GenericProjectFinder service;
    @Inject
    private Provider<MilestoneStatusComboDataBuilder> statusComboDataBuilderProvider;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getManager(@PathVariable(value="projectId") Long projectId, Locale locale) {
        ModelAndView mav = new ModelAndView("project-tabs/milestone-binding.html");
        GenericProject project = this.service.findById(projectId.longValue());
        mav.addObject("proj", (Object)project);
        mav.addObject("isTemplate", (Object)ProjectHelper.isTemplate((GenericProject)project));
        mav.addObject("milestoneStatus", ((MilestoneStatusComboDataBuilder)((MilestoneStatusComboDataBuilder)this.statusComboDataBuilderProvider.get()).useLocale(locale)).buildMap());
        return mav;
    }
}

