/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.milestone;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.service.internal.project.ProjectHelper;
import org.squashtest.tm.service.milestone.MilestoneBindingManagerService;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.controller.administration.MilestoneDataTableModelHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

@Controller
@RequestMapping(value={"/milestones-binding"})
public class MilestoneBindingController {
    private static final String IDS = "Ids[]";
    private static final String BINDED = "binded";
    private static final String BINDABLE = "bindable";
    private static final String PROJECT_PROJECT_ID_MILESTONE_MAPPING = "/project/{projectId}/milestone";
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private MilestoneBindingManagerService service;
    @Inject
    private MilestoneManagerService milestoneService;
    @Inject
    private GenericProjectFinder projectFinder;
    @Inject
    private PermissionEvaluationService permissionEvaluator;

    @RequestMapping(value={"/project/{projectId}/milestone"}, method={RequestMethod.POST}, params={"Ids[]"})
    @ResponseBody
    public void bindMilestonesToProject(@PathVariable Long projectId, @RequestParam(value="Ids[]") List<Long> milestoneIds) {
        this.service.bindMilestonesToProject(milestoneIds, projectId);
    }

    @RequestMapping(value={"/milestone/{milestoneId}/project"}, method={RequestMethod.POST}, params={"Ids[]"})
    @ResponseBody
    public void bindProjectsToMilestone(@PathVariable Long milestoneId, @RequestParam(value="Ids[]") List<Long> projectIds) {
        this.service.bindProjectsToMilestone(projectIds, milestoneId);
    }

    @RequestMapping(value={"/project/{projectId}/milestone"}, method={RequestMethod.POST}, params={"Ids[]", "bindObjects"})
    @ResponseBody
    public void bindMilestonesToProjectAndBindObject(@PathVariable Long projectId, @RequestParam(value="Ids[]") List<Long> milestoneIds) {
        this.service.bindMilestonesToProjectAndBindObject(projectId, milestoneIds);
    }

    @RequestMapping(value={"/project/{projectId}/milestone/{milestoneIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindMilestoneFromProject(@PathVariable(value="projectId") Long projectId, @PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.service.unbindMilestonesFromProject(milestoneIds, projectId);
    }

    @RequestMapping(value={"/milestone/{milestoneId}/template"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindTemplateFroMilestone(@PathVariable(value="milestoneId") Long milestoneId) {
        this.service.unbindTemplateFrom(milestoneId);
    }

    @RequestMapping(value={"/milestone/{milestoneId}/project/{projectIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindProjectFromMilestone(@PathVariable(value="milestoneId") Long milestoneId, @PathVariable(value="projectIds") List<Long> projectIds) {
        this.service.unbindProjectsFromMilestone(projectIds, milestoneId);
    }

    @RequestMapping(value={"/milestone/{milestoneId}/project/{projectIds}/keep-in-perimeter"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindProjectFromMilestoneKeepInPerimeter(@PathVariable(value="milestoneId") Long milestoneId, @PathVariable(value="projectIds") List<Long> projectIds) {
        this.service.unbindProjectsFromMilestoneKeepInPerimeter(projectIds, milestoneId);
    }

    @RequestMapping(value={"/milestone/{milestoneId}/project"}, method={RequestMethod.GET}, params={"bindable"})
    @ResponseBody
    public DataTableModel getBindableProjectForMilestoneTableModel(@PathVariable Long milestoneId, Locale locale) {
        Milestone milestone = this.milestoneService.findById(milestoneId.longValue());
        List data = this.service.getAllBindableProjectForMilestone(milestoneId);
        return this.buildProjectTableModel(data, milestone, locale);
    }

    private DataTableModel buildProjectTableModel(Collection<GenericProject> data, Milestone milestone, Locale locale) {
        ProjectDataTableModelHelper helper = new ProjectDataTableModelHelper(milestone, locale);
        List<Object> aaData = helper.buildRawModel(data);
        DataTableModel<Object> model = new DataTableModel<Object>("");
        model.setAaData(aaData);
        return model;
    }

    private DataTableModel buildMilestoneTableModel(Collection<Milestone> data, Locale locale, Long projectId) {
        MilestoneDataTableModelHelper helper = new MilestoneDataTableModelHelper(this.messageSource);
        helper.setLocale(locale);
        helper.setProject(this.projectFinder.findById(projectId.longValue()));
        helper.setMilestoneManagerService(this.milestoneService);
        List<Object> aaData = helper.buildRawModel(data);
        DataTableModel<Object> model = new DataTableModel<Object>("");
        model.setAaData(aaData);
        return model;
    }

    @RequestMapping(value={"/project/{projectId}/milestone"}, method={RequestMethod.GET}, params={"bindable", "type"})
    @ResponseBody
    public DataTableModel getBindableMilestoneForProjectTableModel(@PathVariable Long projectId, Locale locale, @RequestParam(value="type") String type) {
        List data = this.service.getAllBindableMilestoneForProject(projectId, type);
        return this.buildMilestoneTableModel(data, locale, projectId);
    }

    @RequestMapping(value={"/project/{projectId}/milestone"}, method={RequestMethod.GET}, params={"binded"})
    @ResponseBody
    public DataTableModel getBindedMilestoneForProjectTableModel(@PathVariable Long projectId, Locale locale) {
        List data = this.service.getAllBindedMilestoneForProject(projectId);
        return this.buildMilestoneTableModel(data, locale, projectId);
    }

    @RequestMapping(value={"/milestone/{milestoneId}/project"}, method={RequestMethod.GET}, params={"binded"})
    @ResponseBody
    public DataTableModel getBindedOrPerimeterProjectForMilestoneTableModel(@PathVariable Long milestoneId, Locale locale) {
        Milestone milestone = this.milestoneService.findById(milestoneId.longValue());
        List data = this.service.getAllProjectForMilestone(milestoneId);
        return this.buildProjectTableModel(data, milestone, locale);
    }

    private final class ProjectDataTableModelHelper
    extends DataTableModelBuilder<GenericProject> {
        private Milestone milestone;
        private Locale locale;

        public ProjectDataTableModelHelper(Milestone milestone, Locale locale) {
            this.milestone = milestone;
            this.locale = locale;
        }

        @Override
        public Object buildItemData(GenericProject project) {
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("entity-id", project.getId());
            data.put("entity-index", this.getCurrentIndex() + 1L);
            data.put("type", "&nbsp;");
            data.put("raw-type", ProjectHelper.isTemplate((GenericProject)project) ? "template" : "project");
            data.put("checkbox", " ");
            data.put("name", HtmlUtils.htmlEscape((String)project.getName()));
            data.put("label", project.getLabel());
            data.put(MilestoneBindingController.BINDED, MilestoneBindingController.this.messageSource.internationalizeYesNo(project.isBoundToMilestone(this.milestone), this.locale));
            data.put("isUsed", MilestoneBindingController.this.messageSource.internationalizeYesNo(MilestoneBindingController.this.milestoneService.isMilestoneBoundToOneObjectOfProject(this.milestone, project), this.locale));
            data.put("empty-delete-holder", " ");
            data.put("link", MilestoneBindingController.this.permissionEvaluator.hasRoleOrPermissionOnObject("ROLE_ADMIN", "MANAGEMENT", (Object)project));
            return data;
        }
    }
}

