/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.infolist;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.service.infolist.InfoListItemManagerService;
import org.squashtest.tm.service.internal.dto.json.JsonInfoListItem;
import org.squashtest.tm.web.exception.ResourceNotFoundException;
import org.squashtest.tm.web.internal.model.builder.JsonInfoListBuilder;
import org.squashtest.tm.web.internal.util.IconLibrary;

@Controller
@RequestMapping(value={"/info-list-items"})
public class InfoListItemController {
    private static final String INFO_LIST_ITEM_ID_MAPPING = "/{infoListItemId}";
    @Inject
    private InfoListItemManagerService listItemManager;
    @Inject
    private JsonInfoListBuilder jsonBuilder;

    @RequestMapping(value={"/{infoListItemId}"}, method={RequestMethod.POST}, params={"id=info-list-item-label", "value"})
    @ResponseBody
    public String changeLabel(@PathVariable Long infoListItemId, @RequestParam(value="value") String label) {
        this.listItemManager.changeLabel(infoListItemId.longValue(), label);
        return HtmlUtils.htmlEscape((String)label);
    }

    @RequestMapping(value={"/{infoListItemId}"}, method={RequestMethod.POST}, params={"id=info-list-item-code", "value"})
    @ResponseBody
    public String changeCode(@PathVariable Long infoListItemId, @RequestParam(value="value") String code) {
        this.listItemManager.changeCode(infoListItemId.longValue(), code);
        return HtmlUtils.htmlEscape((String)code);
    }

    @RequestMapping(value={"/{infoListItemId}"}, method={RequestMethod.POST}, params={"id=info-list-item-colour", "value"})
    @ResponseBody
    public String changeColour(@PathVariable Long infoListItemId, @RequestParam(value="value") String colour) {
        this.listItemManager.changeColour(infoListItemId.longValue(), colour);
        return HtmlUtils.htmlEscape((String)colour);
    }

    @RequestMapping(value={"/{infoListItemId}"}, method={RequestMethod.POST}, params={"id=info-list-item-default"})
    @ResponseBody
    public void changeDefault(@PathVariable Long infoListItemId) {
        this.listItemManager.changeDefault(infoListItemId.longValue());
    }

    @RequestMapping(value={"/{infoListItemId}"}, method={RequestMethod.POST}, params={"id=info-list-item-icon"})
    @ResponseBody
    public void changeIcon(@PathVariable Long infoListItemId, @RequestParam(value="value") String icon) {
        this.listItemManager.changeIcon(infoListItemId.longValue(), icon);
    }

    @RequestMapping(value={"/{infoListItemId}/isUsed"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isUsed(@PathVariable long infoListItemId) {
        return this.listItemManager.isUsed(infoListItemId);
    }

    @RequestMapping(value={"/code/{code}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonInfoListItem getItemByCode(@PathVariable String code) {
        InfoListItem item = this.listItemManager.findByCode(code);
        if (item == null) {
            throw new ResourceNotFoundException();
        }
        return this.jsonBuilder.toJson(item);
    }

    @RequestMapping(value={"/icons"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getInfoListIconsList() {
        return IconLibrary.getIconNames();
    }
}

