/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.infolist;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.NoResultException;
import javax.validation.Valid;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.UserListItem;
import org.squashtest.tm.service.infolist.InfoListItemManagerService;
import org.squashtest.tm.service.infolist.InfoListManagerService;
import org.squashtest.tm.service.internal.dto.json.JsonInfoListItem;
import org.squashtest.tm.web.exception.ResourceNotFoundException;
import org.squashtest.tm.web.internal.controller.infolist.InfoListItemController;
import org.squashtest.tm.web.internal.http.JsonEmptyResponseEntity;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/info-lists"})
public class InfoListController {
    private static final String EXISTS = "exists";
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoListController.class);
    @Inject
    private InfoListManagerService infoListManager;
    @Inject
    private InfoListItemManagerService infoListItemManager;
    @Inject
    private InfoListItemController itemsController;

    @RequestMapping(value={"/{infoListId}"}, method={RequestMethod.POST}, params={"id=info-list-label", "value"})
    @ResponseBody
    public String changeLabel(@PathVariable long infoListId, @RequestParam(value="value") String label) {
        this.infoListManager.changeLabel(infoListId, label);
        return label;
    }

    @RequestMapping(value={"/{infoListId}"}, method={RequestMethod.POST}, params={"id=info-list-code", "value"})
    @ResponseBody
    public String changeCode(@PathVariable Long infoListId, @RequestParam(value="value") String code) {
        this.infoListManager.changeCode(infoListId.longValue(), code);
        return HtmlUtils.htmlEscape((String)code);
    }

    @RequestMapping(value={"/{infoListId}"}, method={RequestMethod.POST}, params={"id=info-list-description", "value"})
    @ResponseBody
    public String changeDescription(@PathVariable Long infoListId, @RequestParam(value="value") String description) {
        this.infoListManager.changeDescription(infoListId.longValue(), description);
        return HtmlUtils.htmlEscape((String)description);
    }

    @RequestMapping(value={"/{infoListId}/items"}, method={RequestMethod.GET})
    @ResponseBody
    public DataTableModel<?> getInfoListItems(@PathVariable Long infoListId) {
        InfoList list = this.infoListManager.findById(infoListId);
        return this.buildInfoListItemTableModel(list.getItems());
    }

    @RequestMapping(value={"{id}/items/label/{label}"}, method={RequestMethod.GET}, produces={"application/json"}, params={"format=exists"})
    @ResponseBody
    public Map<String, Object> doesLabelExist(@PathVariable long id, @PathVariable String label) {
        InfoList list = this.infoListManager.findById(Long.valueOf(id));
        InfoListItem found = null;
        for (InfoListItem item : list.getItems()) {
            if (!item.getLabel().equals(label)) continue;
            found = item;
            break;
        }
        HashMap<String, Object> res = new HashMap<String, Object>(1);
        res.put(EXISTS, found != null);
        return res;
    }

    @RequestMapping(value={"/items/code/{code}"}, method={RequestMethod.GET}, produces={"application/json"}, params={"format=exists"})
    @ResponseBody
    public Map<String, Object> doesItemExist(@PathVariable String code) {
        InfoListItem item = null;
        HashMap<String, Object> res = new HashMap<String, Object>(1);
        try {
            item = this.infoListItemManager.findByCode(code);
        }
        catch (NoResultException noResultException) {
            res.put(EXISTS, false);
        }
        res.put(EXISTS, item != null);
        return res;
    }

    @RequestMapping(value={"/items/code/{code}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonInfoListItem getItemByCode(@PathVariable String code) {
        return this.itemsController.getItemByCode(code);
    }

    @RequestMapping(value={"/{prop}/{value}"}, method={RequestMethod.GET}, produces={"application/json"}, params={"format=exists"})
    @ResponseBody
    public Map<String, Object> doesListExist(@PathVariable String prop, @PathVariable String value) {
        if ("label".equals(prop) || "code".equals(prop)) {
            InfoList item = this.infoListManager.findByUniqueProperty(prop, value);
            HashMap<String, Object> res = new HashMap<String, Object>(1);
            res.put(EXISTS, item != null);
            return res;
        }
        throw new ResourceNotFoundException();
    }

    @RequestMapping(value={"/{infoListId}/items/positions"}, method={RequestMethod.POST}, params={"itemIds[]", "newIndex"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void changeOptionsPositions(@PathVariable long infoListId, @RequestParam int newIndex, @RequestParam(value="itemIds[]") List<Long> itemsIds) {
        this.infoListManager.changeItemsPositions(infoListId, newIndex, itemsIds);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @RequestMapping(value={"/{infoListId}/items"}, method={RequestMethod.POST})
    public void addInfoListItem(@PathVariable long infoListId, @Valid @ModelAttribute(value="new-info-list-item") UserListItem item) {
        this.infoListItemManager.addInfoListItem(infoListId, (InfoListItem)item);
    }

    @RequestMapping(value={"/{infoListId}/isUsed"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isUsed(@PathVariable long infoListId) {
        return this.infoListManager.isUsedByOneOrMoreProject(infoListId);
    }

    @RequestMapping(value={"/{infoListIds}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void delete(@PathVariable List<Long> infoListIds) {
        this.infoListManager.remove(infoListIds);
    }

    @RequestMapping(value={"/{infoListId}/defaultItem"}, method={RequestMethod.GET})
    @ResponseBody
    public long getDefaultItemId(@PathVariable long infoListId) {
        InfoList infoList = this.infoListManager.findById(Long.valueOf(infoListId));
        return infoList.getDefaultItem().getId();
    }

    @RequestMapping(value={"/{infoListId}/items/{infoListItemId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void delete(@PathVariable long infoListId, @PathVariable long infoListItemId) {
        this.infoListItemManager.removeInfoListItem(infoListItemId, infoListId);
    }

    private DataTableModel<Object> buildInfoListItemTableModel(Collection<InfoListItem> data) {
        InfoListItemDataTableModelHelper helper = new InfoListItemDataTableModelHelper();
        List<Object> aaData = helper.buildRawModel(data);
        DataTableModel<Object> model = new DataTableModel<Object>("");
        model.setAaData(aaData);
        return model;
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST}, produces={"application/json"})
    public JsonEmptyResponseEntity createNew(@RequestBody @Valid InfoList infoList) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Will create Info list {}", (Object)ToStringBuilder.reflectionToString((Object)infoList));
        }
        this.infoListManager.persist(infoList);
        return new JsonEmptyResponseEntity(HttpStatus.CREATED);
    }

    private static final class InfoListItemDataTableModelHelper
    extends DataTableModelBuilder<InfoListItem> {
        private InfoListItemDataTableModelHelper() {
        }

        @Override
        public Object buildItemData(InfoListItem item) {
            HashMap<String, Object> data = new HashMap<String, Object>(7);
            data.put("entity-id", item.getId());
            data.put("entity-index", this.getCurrentIndex() + 1L);
            data.put("default", item.isDefault());
            data.put("label", HtmlUtils.htmlEscape((String)item.getLabel()));
            data.put("code", HtmlUtils.htmlEscape((String)item.getCode()));
            data.put("iconName", item.getIconName());
            data.put("colour", HTMLCleanupUtils.escapeOrDefault(item.getColour(), ""));
            data.put("empty-icon-holder", "");
            data.put("empty-delete-holder", " ");
            return data;
        }
    }
}

