/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.infolist;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.service.infolist.InfoListFinderService;
import org.squashtest.tm.service.internal.project.ProjectHelper;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

@Controller
@RequestMapping(value={"administration/projects/{projectId}/infoList-binding"})
public class InfoListBindingManagerController {
    @Inject
    private GenericProjectFinder projectService;
    @Inject
    private InfoListFinderService infoListService;
    @Inject
    private InternationalizationHelper i18n;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getManager(@PathVariable(value="projectId") Long projectId, Locale locale) {
        ModelAndView mav = new ModelAndView("project-tabs/info-list-binding.html");
        GenericProject project = this.projectService.findById(projectId.longValue());
        List infoLists = this.infoListService.findAllUserLists();
        mav.addObject("proj", (Object)project);
        mav.addObject("isTemplate", (Object)ProjectHelper.isTemplate((GenericProject)project));
        mav.addObject("category", (Object)this.buildCategoryData(infoLists, locale));
        mav.addObject("nature", (Object)this.buildNatureData(infoLists, locale));
        mav.addObject("type", (Object)this.buildTypeData(infoLists, locale));
        mav.addObject("isBoundToATemplate", (Object)project.isBoundToTemplate());
        return mav;
    }

    private String buildTypeData(List<InfoList> infoLists, Locale locale) {
        InfoList defaultList = this.infoListService.findByCode(SystemInfoListCode.TEST_CASE_TYPE.getCode());
        return this.buildComboData(infoLists, locale, defaultList);
    }

    private String buildNatureData(List<InfoList> infoLists, Locale locale) {
        InfoList defaultList = this.infoListService.findByCode(SystemInfoListCode.TEST_CASE_NATURE.getCode());
        return this.buildComboData(infoLists, locale, defaultList);
    }

    private String buildCategoryData(List<InfoList> infoLists, Locale locale) {
        InfoList defaultList = this.infoListService.findByCode(SystemInfoListCode.REQUIREMENT_CATEGORY.getCode());
        return this.buildComboData(infoLists, locale, defaultList);
    }

    private String buildComboData(List<InfoList> infoLists, Locale locale, InfoList defaultList) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("_" + defaultList.getId().toString(), this.i18n.internationalize(defaultList.getLabel(), locale));
        for (InfoList list : infoLists) {
            result.put("_" + list.getId().toString(), HtmlUtils.htmlEscape((String)list.getLabel()));
        }
        return JsonHelper.marshall(result);
    }
}

