/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.infolist;

import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.infolist.InfoListBindingManagerService;

@Controller
@RequestMapping(value={"/info-list-binding"})
public class InfoListBindingController {
    @Inject
    private InfoListBindingManagerService service;

    @RequestMapping(value={"/project/{projectId}/category"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public void bindCategoryToProject(@PathVariable Long projectId, @RequestParam(value="value") Long infoListId) {
        this.service.bindListToProjectReqCategory(infoListId.longValue(), projectId.longValue());
    }

    @RequestMapping(value={"/project/{projectId}/nature"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public void bindNatureToProject(@PathVariable Long projectId, @RequestParam(value="value") Long infoListId) {
        this.service.bindListToProjectTcNature(infoListId.longValue(), projectId.longValue());
    }

    @RequestMapping(value={"/project/{projectId}/type"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public void bindTypeToProject(@PathVariable Long projectId, @RequestParam(value="value") Long infoListId) {
        this.service.bindListToProjectTcType(infoListId.longValue(), projectId.longValue());
    }
}

