/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.api.wizard.WorkspaceWizard;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.exception.customfield.CodeDoesNotMatchesPatternException;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.infolist.InfoListModelService;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.internal.dto.json.JsonMilestone;
import org.squashtest.tm.service.library.WorkspaceService;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneModelService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.service.workspace.WorkspaceHelperService;
import org.squashtest.tm.web.internal.controller.campaign.MenuItem;
import org.squashtest.tm.web.internal.helper.I18nLevelEnumInfolistHelper;
import org.squashtest.tm.web.internal.helper.JsTreeHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.JsonProjectBuilder;
import org.squashtest.tm.web.internal.model.rest.RestLibrary;
import org.squashtest.tm.web.internal.model.rest.RestProject;
import org.squashtest.tm.web.internal.plugins.manager.wizard.WorkspaceWizardManager;

public abstract class WorkspaceController<LN extends LibraryNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkspaceController.class);
    @Inject
    private WorkspaceWizardManager workspaceWizardManager;
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private JsonProjectBuilder jsonProjectBuilder;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private PartyPreferenceService partyPreferenceService;
    @Inject
    private I18nLevelEnumInfolistHelper i18nLevelEnumInfolistHelper;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private WorkspaceHelperService workspaceHelperService;
    @Inject
    private BugTrackerFinderService bugTrackerFinderService;
    @Inject
    private MilestoneModelService milestoneModelService;
    @Inject
    private InfoListModelService infoListModelService;
    @Inject
    private ConfigurationService configurationService;

    public void setProjectFinder(ProjectFinder projectFinder) {
        this.projectFinder = projectFinder;
    }

    public void setJsonProjectBuilder(JsonProjectBuilder jsonProjectBuilder) {
        this.jsonProjectBuilder = jsonProjectBuilder;
    }

    public void setActiveMilestoneHolder(ActiveMilestoneHolder activeMilestoneHolder) {
        this.activeMilestoneHolder = activeMilestoneHolder;
    }

    public void setPartyPreferenceService(PartyPreferenceService partyPreferenceService) {
        this.partyPreferenceService = partyPreferenceService;
    }

    public void setI18nLevelEnumInfolistHelper(I18nLevelEnumInfolistHelper i18nLevelEnumInfolistHelper) {
        this.i18nLevelEnumInfolistHelper = i18nLevelEnumInfolistHelper;
    }

    public void setUserAccountService(UserAccountService userAccountService) {
        this.userAccountService = userAccountService;
    }

    public void setWorkspaceHelperService(WorkspaceHelperService workspaceHelperService) {
        this.workspaceHelperService = workspaceHelperService;
    }

    public void setBugTrackerFinderService(BugTrackerFinderService bugTrackerFinderService) {
        this.bugTrackerFinderService = bugTrackerFinderService;
    }

    public void setMilestoneModelService(MilestoneModelService milestoneModelService) {
        this.milestoneModelService = milestoneModelService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setInfoListModelService(InfoListModelService infoListModelService) {
        this.infoListModelService = infoListModelService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String showWorkspace(Model model, Locale locale, @CookieValue(value="jstree_open", required=false, defaultValue="") String[] openedNodes, @CookieValue(value="workspace-prefs", required=false, defaultValue="") String elementEntityReference) {
        String[] nodesToOpen = new String[]{};
        if (StringUtils.isBlank((CharSequence)elementEntityReference) || "null".equals(elementEntityReference)) {
            nodesToOpen = openedNodes;
            model.addAttribute("selectedNode", (Object)"");
        } else {
            EntityReference entityReference = null;
            try {
                entityReference = EntityReference.fromString((String)elementEntityReference);
                nodesToOpen = this.getNodeParentsInWorkspace(entityReference);
                model.addAttribute("selectedNode", (Object)this.getTreeElementIdInWorkspace(entityReference));
            }
            catch (IllegalArgumentException | CodeDoesNotMatchesPatternException e) {
                LOGGER.warn("Error during conversion of the 'workspace-prefs' cookie to an EntityReference.", e);
            }
        }
        MultiMap expansionCandidates = this.mapIdsByType(nodesToOpen);
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List projectIds = this.projectFinder.findAllReadableIds(currentUser);
        Optional activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId();
        Collection rootNodes = this.workspaceDisplayService().findAllLibraries(projectIds, currentUser, expansionCandidates, (Long)activeMilestoneId.get());
        model.addAttribute("rootModel", (Object)rootNodes);
        this.populateModel(model, locale);
        Collection jsProjects = this.projectFinder.findAllProjects(projectIds, currentUser);
        model.addAttribute("projects", (Object)jsProjects);
        if (activeMilestoneId.isPresent()) {
            JsonMilestone jsMilestone = this.milestoneModelService.findMilestoneModel((Long)activeMilestoneId.get());
            model.addAttribute("activeMilestone", (Object)jsMilestone);
        }
        model.addAttribute("userPrefs", this.getWorkspaceUserPref());
        model.addAttribute("defaultInfoLists", (Object)this.infoListModelService.findSystemInfoListItemLabels());
        model.addAttribute("testCaseImportance", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(TestCaseImportance.class, locale));
        model.addAttribute("testCaseStatus", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(TestCaseStatus.class, locale));
        model.addAttribute("requirementStatus", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(RequirementStatus.class, locale));
        model.addAttribute("requirementCriticality", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(RequirementCriticality.class, locale));
        model.addAttribute("executionStatus", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(ExecutionStatus.class, locale));
        model.addAttribute("projectFilter", (Object)this.workspaceHelperService.findFilterModel(currentUser, projectIds));
        model.addAttribute("bugtrackers", (Object)this.bugTrackerFinderService.findDistinctBugTrackersForProjects(projectIds));
        String userLicenseInformation = this.configurationService.findConfiguration("activated.user.excess");
        String dateLicenseInformation = this.configurationService.findConfiguration("plugin.license.expiration");
        model.addAttribute("userLicenseInformation", (Object)userLicenseInformation);
        model.addAttribute("dateLicenseInformation", dateLicenseInformation == null || dateLicenseInformation.isEmpty() ? null : Integer.valueOf(dateLicenseInformation));
        return this.getWorkspaceViewName();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/tree/{openedNodes}"})
    public List<JsTreeNode> getRootModel(@PathVariable String[] openedNodes) {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List projectIds = this.projectFinder.findAllReadableIds(currentUser);
        MultiMap expansionCandidates = JsTreeHelper.mapIdsByType(openedNodes);
        Optional activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId();
        Collection rootNodes = this.workspaceDisplayService().findAllLibraries(projectIds, currentUser, expansionCandidates, (Long)activeMilestoneId.get());
        return new ArrayList<JsTreeNode>(rootNodes);
    }

    protected MultiMap mapIdsByType(String[] openedNodes) {
        return JsTreeHelper.mapIdsByType(openedNodes);
    }

    protected abstract <T extends Library<LN>> WorkspaceService<T> getWorkspaceService();

    protected abstract String getWorkspaceViewName();

    protected abstract String[] getNodeParentsInWorkspace(EntityReference var1);

    protected abstract String getTreeElementIdInWorkspace(EntityReference var1);

    protected abstract void populateModel(Model var1, Locale var2);

    protected abstract WorkspaceType getWorkspaceType();

    protected Map<String, String> getWorkspaceUserPref() {
        return this.partyPreferenceService.findPreferencesForCurrentUser();
    }

    @ModelAttribute(value="wizards")
    public MenuItem[] getWorkspaceWizards() {
        Collection<WorkspaceWizard> wizards = this.workspaceWizardManager.findAllByWorkspace(this.getWorkspaceType());
        return this.menuItems(wizards);
    }

    private MenuItem[] menuItems(Collection<WorkspaceWizard> wizards) {
        Collection effective = CollectionUtils.select(wizards, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((WorkspaceWizard)object).getWizardMenu() != null;
            }
        });
        MenuItem[] res = new MenuItem[effective.size()];
        int i = 0;
        for (WorkspaceWizard wizard : wizards) {
            if (wizard.getWizardMenu() == null) continue;
            res[i] = this.createMenuItem(wizard);
            ++i;
        }
        return res;
    }

    private MenuItem createMenuItem(WorkspaceWizard wizard) {
        MenuItem item = new MenuItem();
        item.setId(wizard.getId());
        item.setLabel(wizard.getWizardMenu().getLabel());
        item.setTooltip(wizard.getWizardMenu().getTooltip());
        item.setUrl(wizard.getWizardMenu().getUrl());
        item.setAccessRule(wizard.getWizardMenu().getAccessRule());
        return item;
    }

    protected InternationalizationHelper getI18nHelper() {
        return this.i18nHelper;
    }

    protected List<RestLibrary> getEditableLibraries(Model model) {
        Collection jsTreeNodes = (Collection)model.asMap().get("rootModel");
        return jsTreeNodes.stream().filter(jsTreeNode -> {
            Object editable = jsTreeNode.getAttr().get("editable");
            return Objects.nonNull(editable) && Objects.equals(editable.toString(), "true");
        }).sorted(Comparator.comparing(JsTreeNode::getTitle)).map(jsTreeNode -> {
            RestLibrary restLibrary = new RestLibrary();
            restLibrary.setId(Long.parseLong(jsTreeNode.getAttr().get("resId").toString()));
            RestProject restProject = new RestProject();
            restProject.setId(Long.parseLong(jsTreeNode.getAttr().get("resId").toString()));
            restProject.setName(jsTreeNode.getTitle());
            restLibrary.setProject(restProject);
            return restLibrary;
        }).collect(Collectors.toList());
    }

    protected abstract Provider<DriveNodeBuilder<LN>> driveNodeBuilderProvider();

    protected abstract WorkspaceDisplayService workspaceDisplayService();
}

