/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.generic;

import java.util.Set;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.service.attachment.AttachmentFinderService;
import org.squashtest.tm.web.internal.controller.attachment.AttachmentsTableModelHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;

@Component
public class ServiceAwareAttachmentTableModelHelper {
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private AttachmentFinderService attachmentFinderService;

    public DataTableModel findPagedAttachments(AttachmentHolder holder) {
        PageRequest pageable = new PageRequest(0, 50, new Sort(new String[]{"Attachment.name"}));
        return this.findPagedAttachments(holder, (Pageable)pageable, "");
    }

    public DataTableModel findPagedAttachments(AttachmentHolder holder, Pageable pageable, String sEcho) {
        Page attachments = this.attachmentFinderService.findPagedAttachments(holder, pageable);
        return new AttachmentsTableModelHelper(this.i18nHelper).buildDataModel(attachments, sEcho);
    }

    public DataTableModel findPagedAttachments(long attachmentListId) {
        PageRequest pageable = new PageRequest(0, 50, new Sort(new String[]{"Attachment.name"}));
        return this.findPagedAttachments(attachmentListId, (Pageable)pageable, "");
    }

    public DataTableModel findPagedAttachments(long attachmentListId, Pageable pageable, String sEcho) {
        Page attachments = this.attachmentFinderService.findPagedAttachments(attachmentListId, pageable);
        return new AttachmentsTableModelHelper(this.i18nHelper).buildDataModel(attachments, sEcho);
    }

    public Set<Attachment> findAttachments(AttachmentHolder holder) {
        return this.attachmentFinderService.findAttachments(holder.getAttachmentList().getId());
    }

    public Set<Attachment> findAttachments(long attachmentListId) {
        return this.attachmentFinderService.findAttachments(Long.valueOf(attachmentListId));
    }
}

