/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.generic;

import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.web.internal.interceptor.openedentity.OpenedEntities;

@Controller
public class ObjectAccessController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectAccessController.class);

    @RequestMapping(value={"/test-cases/{id}/opened-entity"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void leaveTestCase(@PathVariable(value="id") Long id, HttpServletRequest request) {
        String contextKey = TestCase.class.getSimpleName();
        this.removeViewForObject(id, request, contextKey);
    }

    @RequestMapping(value={"/requirements/{id}/opened-entity"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void leaveRequirement(@PathVariable(value="id") Long id, HttpServletRequest request) {
        String contextKey = Requirement.class.getSimpleName();
        this.removeViewForObject(id, request, contextKey);
    }

    @RequestMapping(value={"/campaigns/{id}/opened-entity"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void leaveCampaign(@PathVariable(value="id") Long id, HttpServletRequest request) {
        String contextKey = Campaign.class.getSimpleName();
        this.removeViewForObject(id, request, contextKey);
    }

    @RequestMapping(value={"/iterations/{id}/opened-entity"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void leaveIteration(@PathVariable(value="id") Long id, HttpServletRequest request) {
        String contextKey = Iteration.class.getSimpleName();
        this.removeViewForObject(id, request, contextKey);
    }

    @RequestMapping(value={"/test-suites/{id}/opened-entity"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void leaveTestSuite(@PathVariable(value="id") Long id, HttpServletRequest request) {
        String contextKey = TestSuite.class.getSimpleName();
        this.removeViewForObject(id, request, contextKey);
    }

    @RequestMapping(value={"/executions/{id}/opened-entity"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void leaveExecution(@PathVariable(value="id") Long id, HttpServletRequest request) {
        String contextKey = Execution.class.getSimpleName();
        this.removeViewForObject(id, request, contextKey);
    }

    private void removeViewForObject(Long id, HttpServletRequest request, String contextKey) {
        ServletContext context;
        Principal user = request.getUserPrincipal();
        HttpSession session = request.getSession();
        if (session != null && (context = request.getSession().getServletContext()) != null && user != null) {
            LOGGER.debug("context = " + context);
            LOGGER.debug("leave " + contextKey + " #" + id);
            LOGGER.debug(user.getName());
            OpenedEntities openedEnities = (OpenedEntities)context.getAttribute(contextKey);
            if (openedEnities != null) {
                openedEnities.removeView(user.getName(), id);
            }
        }
    }
}

