/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.generic;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceResourceBundle;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.library.ExportData;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.testcase.ExportTestCaseData;
import org.squashtest.tm.exception.library.RightsUnsuficientsForOperationException;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.deletion.Node;
import org.squashtest.tm.service.deletion.NodeMovement;
import org.squashtest.tm.service.deletion.NodeReferenceChanged;
import org.squashtest.tm.service.deletion.NodeRenaming;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.library.LibraryNavigationService;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.generic.FolderFormModel;
import org.squashtest.tm.web.internal.report.service.JasperReportsService;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

public abstract class LibraryNavigationController<LIBRARY extends Library<? extends NODE>, FOLDER extends Folder<? extends NODE>, NODE extends LibraryNode> {
    private static final int EOF = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(LibraryNavigationController.class);
    private static final String FOLDERS = "folders";
    private static final String DRIVES = "drives";
    private static final String MODEL_ATTRIBUTE_ADD_FOLDER = "add-folder";
    @Inject
    protected CustomReportDashboardService customReportDashboardService;
    @Inject
    protected UserAccountService userAccountService;
    @Inject
    protected ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private MessageSource messageSource;
    @Inject
    private JasperReportsService jrServices;

    protected abstract LibraryNavigationService<LIBRARY, FOLDER, NODE> getLibraryNavigationService();

    protected MessageSource getMessageSource() {
        return this.messageSource;
    }

    protected abstract JsTreeNode createTreeNodeFromLibraryNode(NODE var1);

    @ResponseBody
    @RequestMapping(value={"/drives/{libraryId}/content"}, method={RequestMethod.GET})
    public final List<JsTreeNode> getRootContentTreeModel(@PathVariable long libraryId) {
        Long activeMilestoneId = (Long)this.activeMilestoneHolder.getActiveMilestoneId().get();
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        Collection nodes = this.workspaceDisplayService().getNodeContent(Long.valueOf(libraryId), currentUser, "library", activeMilestoneId);
        return new ArrayList<JsTreeNode>(nodes);
    }

    protected List<JsTreeNode> createJsTreeModel(Collection<NODE> nodes) {
        ArrayList<JsTreeNode> jstreeNodes = new ArrayList<JsTreeNode>();
        for (LibraryNode node : nodes) {
            JsTreeNode jsnode = this.createTreeNodeFromLibraryNode(node);
            if (jsnode == null) continue;
            jstreeNodes.add(jsnode);
        }
        return jstreeNodes;
    }

    @ResponseBody
    @RequestMapping(value={"/drives/{libraryId}/content/new-folder"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public final JsTreeNode addNewFolderToLibraryRootContent(@PathVariable long libraryId, @RequestBody FolderFormModel folderModel) throws BindException {
        this.validateFolderModel(folderModel);
        Folder newFolder = this.getLibraryNavigationService().addFolderToLibrary(libraryId, folderModel.toDTO());
        return this.createTreeNodeFromLibraryNode(newFolder);
    }

    @ResponseBody
    @RequestMapping(value={"/folders/{folderId}/content/new-folder"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public final JsTreeNode addNewFolderToFolderContent(@PathVariable long folderId, @RequestBody FolderFormModel folderModel) throws BindException {
        this.validateFolderModel(folderModel);
        Folder newFolder = this.getLibraryNavigationService().addFolderToFolder(folderId, folderModel.toDTO());
        return this.createTreeNodeFromLibraryNode(newFolder);
    }

    @ResponseBody
    @RequestMapping(value={"/folders/{folderId}/content"}, method={RequestMethod.GET})
    public final List<JsTreeNode> getFolderContentTreeModel(@PathVariable long folderId) {
        Long activeMilestoneId = (Long)this.activeMilestoneHolder.getActiveMilestoneId().get();
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        Collection nodes = this.workspaceDisplayService().getNodeContent(Long.valueOf(folderId), currentUser, "folder", activeMilestoneId);
        return new ArrayList<JsTreeNode>(nodes);
    }

    @ResponseBody
    @RequestMapping(value={"/content/{nodeIds}/deletion-simulation"}, method={RequestMethod.GET})
    public Messages simulateNodeDeletion(@PathVariable(value="nodeIds") List<Long> nodeIds, Locale locale) {
        List reportList = this.getLibraryNavigationService().simulateDeletion(nodeIds);
        Messages messages = new Messages();
        for (SuppressionPreviewReport report : reportList) {
            messages.addMessage(report.toString(this.messageSource, locale));
        }
        return messages;
    }

    @ResponseBody
    @RequestMapping(value={"/content/{nodeIds}"}, method={RequestMethod.DELETE})
    public OperationReport confirmNodeDeletion(@PathVariable(value="nodeIds") List<Long> nodeIds) {
        OperationReport report = this.getLibraryNavigationService().deleteNodes(nodeIds);
        this.logOperations(report);
        return report;
    }

    @ResponseBody
    @RequestMapping(value={"/{destinationType}/{destinationId}/content/new"}, method={RequestMethod.POST}, params={"nodeIds[]"})
    public List<JsTreeNode> copyNodes(@RequestParam(value="nodeIds[]") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId, @PathVariable(value="destinationType") String destType) {
        List nodeList;
        try {
            switch (destType) {
                case "folders": {
                    nodeList = this.getLibraryNavigationService().copyNodesToFolder(destinationId, nodeIds);
                    break;
                }
                case "drives": {
                    nodeList = this.getLibraryNavigationService().copyNodesToLibrary(destinationId, nodeIds);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("copy nodes : specified destination type doesn't exists : " + destType);
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
        return this.createJsTreeModel(nodeList);
    }

    @ResponseBody
    @RequestMapping(value={"/{destinationType}/{destinationId}/content/{nodeIds}"}, method={RequestMethod.PUT})
    public void moveNodes(@PathVariable(value="nodeIds") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId, @PathVariable(value="destinationType") String destType) {
        try {
            switch (destType) {
                case "folders": {
                    this.getLibraryNavigationService().moveNodesToFolder(destinationId, nodeIds);
                    break;
                }
                case "drives": {
                    this.getLibraryNavigationService().moveNodesToLibrary(destinationId, nodeIds);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("move nodes : specified destination type doesn't exists : " + destType);
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @ResponseBody
    @RequestMapping(value={"/{destinationType}/{destinationId}/content/{nodeIds}/{position}"}, method={RequestMethod.PUT})
    public void moveNodes(@PathVariable(value="nodeIds") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId, @PathVariable(value="destinationType") String destType, @PathVariable(value="position") int position) {
        try {
            switch (destType) {
                case "folders": {
                    this.getLibraryNavigationService().moveNodesToFolder(destinationId, nodeIds, position);
                    break;
                }
                case "drives": {
                    this.getLibraryNavigationService().moveNodesToLibrary(destinationId, nodeIds, position);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("move nodes : specified destination type doesn't exists : " + destType);
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    private void removeRteFormat(List<? extends ExportData> dataSource) {
        for (ExportData exportData : dataSource) {
            String htmlDescription = exportData.getDescription();
            String description = HTMLCleanupUtils.htmlToText(htmlDescription);
            exportData.setDescription(description);
        }
    }

    protected void printExport(List<ExportTestCaseData> dataSource, String filename2, String jasperExportFile, HttpServletResponse response, Locale locale, String string, Boolean keepRteFormat) {
        this.printExport(dataSource, filename2, jasperExportFile, response, locale, string, keepRteFormat, new HashMap<String, Object>());
    }

    protected void printExport(List<? extends ExportData> dataSource, String filename, String jasperFile, HttpServletResponse response, Locale locale, String format, boolean keepRteFormat, Map<String, Object> reportParameters) {
        try {
            if (!keepRteFormat) {
                this.removeRteFormat(dataSource);
            }
            reportParameters.put("REPORT_LOCALE", locale);
            reportParameters.put("REPORT_RESOURCE_BUNDLE", new MessageSourceResourceBundle(this.messageSource, locale));
            HashMap<JRExporterParameter, Object> exportParameter = new HashMap<JRExporterParameter, Object>();
            exportParameter.put((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, ";");
            exportParameter.put(JRExporterParameter.CHARACTER_ENCODING, "ISO-8859-1");
            exportParameter.put((JRExporterParameter)JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.FALSE);
            InputStream jsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(jasperFile);
            InputStream reportStream = this.jrServices.getReportAsStream(jsStream, format, dataSource, reportParameters, exportParameter);
            ServletOutputStream servletStream = response.getOutputStream();
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + filename + "." + format);
            this.flushStreams(reportStream, servletStream);
            reportStream.close();
            servletStream.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected void flushStreams(InputStream inStream, ServletOutputStream outStream) throws IOException {
        int readByte;
        do {
            if ((readByte = inStream.read()) == -1) continue;
            outStream.write(readByte);
        } while (readByte != -1);
    }

    private void logOperations(OperationReport report) {
        for (Node deletedNode : report.getRemoved()) {
            LOGGER.info("The node #{} was removed", (Object)deletedNode.getResid());
        }
        for (NodeMovement movedNode : report.getMoved()) {
            LOGGER.info("The nodes #{} were moved to node #{}", movedNode.getMoved().stream().map(Node::getResid).collect(Collectors.toList()), (Object)movedNode.getDest().getResid());
        }
        for (NodeRenaming renamedNode : report.getRenamed()) {
            LOGGER.info("The node #{} was renamed to {}", (Object)renamedNode.getNode().getResid(), (Object)renamedNode.getName());
        }
        for (NodeReferenceChanged nodeReferenceChanged : report.getReferenceChanges()) {
            LOGGER.info("The node #{} reference was changed to {}", (Object)nodeReferenceChanged.getNode().getResid(), (Object)nodeReferenceChanged.getReference());
        }
    }

    protected List<JsTreeNode> createLinkableLibrariesModel(List<Long> projectIds) {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        Optional activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId();
        Collection linkableLibrariesModel = this.workspaceDisplayService().findAllLibraries(projectIds, currentUser, (MultiMap)new MultiValueMap(), (Long)activeMilestoneId.get());
        return new ArrayList<JsTreeNode>(linkableLibrariesModel);
    }

    protected abstract WorkspaceDisplayService workspaceDisplayService();

    private void validateFolderModel(FolderFormModel folderModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)folderModel, MODEL_ATTRIBUTE_ADD_FOLDER);
        FolderFormModel.FolderFormModelValidator validator = new FolderFormModel.FolderFormModelValidator(this.getMessageSource());
        validator.validate(folderModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    protected static class Messages {
        private Collection<String> messageCollection = new ArrayList<String>();

        public void addMessage(String msg) {
            this.messageCollection.add(msg);
        }

        public Collection<String> getMessageCollection() {
            return this.messageCollection;
        }
    }
}

