/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.generic;

import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.library.FolderModificationService;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

public abstract class FolderModificationController<FOLDER extends Folder<?>> {
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentsHelper;
    @Inject
    private CustomReportDashboardService customReportDashboardService;
    @Inject
    private CustomFieldValueFinderService cufValueService;

    public void setCustomReportDashboardService(CustomReportDashboardService customReportDashboardService) {
        this.customReportDashboardService = customReportDashboardService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showFolder(@PathVariable long folderId, HttpServletRequest request) {
        Folder folder = this.getFolderModificationService().findFolder(folderId);
        boolean hasFolderCUF = false;
        BindableEntity entity = folder.getBoundEntityType();
        if (entity != null) {
            hasFolderCUF = this.cufValueService.hasCustomFields(folder.getId(), entity);
        }
        ModelAndView mav = new ModelAndView("fragment/generics/edit-folder");
        mav.addObject("folder", (Object)folder);
        mav.addObject("updateUrl", (Object)this.getUpdateUrl(String.valueOf(request.getServletPath()) + StringUtils.defaultString((String)request.getPathInfo())));
        mav.addObject("workspaceName", (Object)this.getWorkspaceName());
        mav.addObject("attachments", this.findAttachments(folder));
        mav.addObject("hasFolderCUF", (Object)hasFolderCUF);
        Workspace workspace = Workspace.getWorkspaceFromShortName((String)this.getWorkspaceName());
        boolean shouldShowDashboard = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(workspace);
        boolean canShowDashboard = this.customReportDashboardService.canShowDashboardInWorkspace(workspace);
        mav.addObject("shouldShowDashboard", (Object)shouldShowDashboard);
        mav.addObject("canShowDashboard", (Object)canShowDashboard);
        return mav;
    }

    protected abstract FolderModificationService<FOLDER> getFolderModificationService();

    protected abstract String getWorkspaceName();

    protected Set<Attachment> findAttachments(FOLDER folder) {
        return this.attachmentsHelper.findAttachments((AttachmentHolder)folder);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.DELETE})
    public String removeFolder(@PathVariable long folderId) {
        this.getFolderModificationService().removeFolder(folderId);
        return "ok";
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"newName"})
    public Object renameFolder(@RequestParam(value="newName") String newName, @PathVariable long folderId) {
        this.getFolderModificationService().renameFolder(folderId, newName);
        return new RenameModel(HtmlUtils.htmlEscape((String)newName));
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"id", "value"})
    public String updateDescription(@PathVariable long folderId, @RequestParam(value="value") String newDescription) {
        this.getFolderModificationService().updateFolderDescription(folderId, newDescription);
        return HTMLCleanupUtils.cleanHtml(newDescription);
    }

    private String getUpdateUrl(String pathInfo) {
        String toReturn = pathInfo.substring(1);
        int lastSlash = toReturn.lastIndexOf(47);
        return toReturn.substring(0, lastSlash);
    }
}

