/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.generic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.NewFolderDto;
import org.squashtest.tm.service.internal.dto.RawValueModel;

public class FolderFormModel {
    private String name;
    private String description;
    private RawValueModel.RawValueModelMap customFields;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RawValueModel.RawValueModelMap getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(RawValueModel.RawValueModelMap customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public NewFolderDto toDTO() {
        NewFolderDto dto = new NewFolderDto();
        dto.setName(this.name);
        dto.setDescription(this.description);
        HashMap<Long, RawValue> cufs = new HashMap<Long, RawValue>(this.customFields.size());
        for (Map.Entry entry : this.customFields.entrySet()) {
            cufs.put((Long)entry.getKey(), ((RawValueModel)entry.getValue()).toRawValue());
        }
        dto.setCustomFields(cufs);
        return dto;
    }

    public static class FolderFormModelValidator
    implements Validator {
        private static final String MESSAGE_NOT_BLANK = "message.notBlank";
        private MessageSource messageSource;

        public FolderFormModelValidator(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public void setMessageSource(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public boolean supports(Class<?> clazz) {
            return clazz.equals(NewFolderDto.class);
        }

        public void validate(Object target, Errors errors) {
            Locale locale = LocaleContextHolder.getLocale();
            String notBlank = this.messageSource.getMessage(MESSAGE_NOT_BLANK, null, locale);
            FolderFormModel model = (FolderFormModel)target;
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)MESSAGE_NOT_BLANK, (String)notBlank);
            for (Map.Entry entry : model.getCustomFields().entrySet()) {
                RawValueModel value = (RawValueModel)entry.getValue();
                if (!value.isEmpty()) continue;
                errors.rejectValue("customFields[" + entry.getKey() + "]", MESSAGE_NOT_BLANK, notBlank);
            }
        }
    }
}

