/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.execution;

import java.util.Locale;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.exception.execution.TestSuiteTestPlanHasDeletedTestCaseException;
import org.squashtest.tm.web.internal.controller.execution.AbstractTestPlanExecutionRunnerController;
import org.squashtest.tm.web.internal.controller.execution.RunnerState;
import org.squashtest.tm.web.internal.controller.execution.StepState;
import org.squashtest.tm.web.internal.model.json.JsonStepInfo;

@Controller
@RequestMapping(value={"/test-suites/{testSuiteId}/test-plan"})
public class TestSuiteExecutionRunnerController
extends AbstractTestPlanExecutionRunnerController<TestSuite> {
    private static final String TEST_SUITE = "/test-suites";

    @Override
    @ResponseBody
    @RequestMapping(value={"/execution/runner"}, method={RequestMethod.POST}, params={"mode=start-resume", "dry-run"})
    public void testStartResumeExecutionInClassicRunner(@PathVariable long testSuiteId) {
        super.testStartResumeExecutionInClassicRunner(testSuiteId);
    }

    @Override
    ActionException getTestPlanHasDeletedTestCaseException() {
        return new TestSuiteTestPlanHasDeletedTestCaseException();
    }

    @Override
    @RequestMapping(value={"/execution/runner"}, params={"optimized=false", "!dry-run"})
    @ResponseStatus(value=HttpStatus.MOVED_PERMANENTLY)
    public String startResumeExecutionInClassicRunner(@PathVariable long testSuiteId) {
        return super.startResumeExecutionInClassicRunner(testSuiteId);
    }

    @Override
    @RequestMapping(value={"/execution/runner"}, params={"optimized=true", "!dry-run"})
    public String startResumeExecutionInOptimizedRunner(@PathVariable long testSuiteId, Model model, Locale locale) {
        return super.startResumeExecutionInOptimizedRunner(testSuiteId, model, locale);
    }

    @Override
    @RequestMapping(value={"/{testPlanItemId}/next-execution/runner"})
    @ResponseStatus(value=HttpStatus.MOVED_PERMANENTLY)
    public String moveToNextTestCase(@PathVariable(value="testPlanItemId") long testPlanItemId, @PathVariable(value="testSuiteId") long testSuiteId, @RequestParam(value="optimized") boolean optimized) {
        return super.moveToNextTestCase(testPlanItemId, testSuiteId, optimized);
    }

    @Override
    @RequestMapping(value={"/{testPlanItemId}/next-execution/runner"}, headers={"Accept=application/json, text/javascript"})
    @ResponseBody
    public RunnerState getNextTestCaseRunnerState(@PathVariable(value="testPlanItemId") long testPlanItemId, @PathVariable(value="testSuiteId") long testSuiteId, Locale locale) {
        return super.getNextTestCaseRunnerState(testPlanItemId, testSuiteId, locale);
    }

    @Override
    @ResponseBody
    @RequestMapping(value={"/executions"}, method={RequestMethod.DELETE})
    public void deleteAllExecutions(@PathVariable long testSuiteId) {
        super.deleteAllExecutions(testSuiteId);
    }

    @Override
    @RequestMapping(value={"{testPlanItemId}/executions/{executionId}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.MOVED_PERMANENTLY)
    public String runFirstRunnableStep(@PathVariable long testSuiteId, @PathVariable long testPlanItemId, @PathVariable long executionId, @RequestParam(defaultValue="false") boolean optimized) {
        return super.runFirstRunnableStep(testSuiteId, testPlanItemId, executionId, optimized);
    }

    @Override
    @RequestMapping(value={"{testPlanItemId}/executions/{executionId}/steps/prologue"}, method={RequestMethod.GET})
    public String runPrologue(@PathVariable long testSuiteId, @PathVariable long testPlanItemId, @PathVariable long executionId, @RequestParam(defaultValue="false") boolean optimized, Model model) {
        return super.runPrologue(testSuiteId, testPlanItemId, executionId, optimized, model);
    }

    @Override
    @RequestMapping(value={"/{testPlanItemId}/executions/{executionId}/steps/index/{stepIndex}"}, method={RequestMethod.GET}, params={"optimized=false"})
    public String getClassicTestSuiteExecutionStepFragment(@PathVariable long testSuiteId, @PathVariable long testPlanItemId, @PathVariable long executionId, @PathVariable int stepIndex, Model model) {
        return super.getClassicTestSuiteExecutionStepFragment(testSuiteId, testPlanItemId, executionId, stepIndex, model);
    }

    @Override
    @RequestMapping(value={"/{testPlanItemId}/executions/{executionId}/steps/index/{stepIndex}"}, method={RequestMethod.GET}, params={"optimized=true"})
    public String getOptimizedTestSuiteExecutionStepFragment(@PathVariable long testSuiteId, @PathVariable long testPlanItemId, @PathVariable long executionId, @PathVariable int stepIndex, Model model) {
        return super.getOptimizedTestSuiteExecutionStepFragment(testSuiteId, testPlanItemId, executionId, stepIndex, model);
    }

    @Override
    @RequestMapping(value={"/{testPlanItemId}/executions/{executionId}/steps/{stepId}"}, method={RequestMethod.POST}, params={"id=execution-comment", "value"})
    @ResponseBody
    public String changeComment(@RequestParam(value="value") String newComment, @PathVariable long stepId) {
        return super.changeComment(newComment, stepId);
    }

    @Override
    @RequestMapping(value={"/{testPlanItemId}/executions/{executionId}/steps/{stepId}"}, method={RequestMethod.POST}, params={"executionStatus"})
    @ResponseBody
    public void changeExecutionStatus(@RequestParam String executionStatus, @PathVariable long stepId) {
        super.changeExecutionStatus(executionStatus, stepId);
    }

    @Override
    @RequestMapping(value={"/{testPlanItemId}/executions/{executionId}/steps/index/{stepIndex}/general"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonStepInfo getBasicInfos(@PathVariable long executionId, @PathVariable int stepIndex) {
        return super.getBasicInfos(executionId, stepIndex);
    }

    @Override
    @RequestMapping(value={"/{testPlanItemId}/executions/{executionId}/steps/index/{stepIndex}"}, method={RequestMethod.GET}, params={"optimized"}, headers={"Accept=application/json, text/javascript"})
    @ResponseBody
    public StepState getStepState(@PathVariable long executionId, @PathVariable int stepIndex) {
        return super.getStepState(executionId, stepIndex);
    }

    @Override
    Project getEntityProject(TestSuite entity) {
        return entity.getProject();
    }

    @Override
    RunnerState createOptimizedRunnerState(long testSuiteId, Execution execution, String contextPath, Locale locale) {
        return this.helper.createOptimizedRunnerStateForTestSuite(testSuiteId, execution, contextPath, locale);
    }

    @Override
    String completeRessourceUrlPattern(String urlPattern) {
        return TEST_SUITE + urlPattern;
    }

    @Override
    boolean hasDeletedTestCaseInTestPlan(long testSuiteId) {
        return ((TestSuite)this.entityFinder.findById(testSuiteId)).getTestPlan().stream().anyMatch(c -> c.getReferencedTestCase() == null);
    }
}

