/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.execution;

import java.util.Locale;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.exception.NoBugTrackerBindingException;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;
import org.squashtest.tm.service.internal.bugtracker.BugTrackerConnectorFactory;
import org.squashtest.tm.web.internal.controller.execution.ExecutionRunnerControllerHelper;
import org.squashtest.tm.web.internal.controller.execution.RunnerState;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/executions/{executionId}/runner"})
public class TestCaseExecutionRunnerController {
    private static final String OPTIMIZED_RUNNER_MAIN = "page/executions/oer-main-page";
    @Inject
    private BugTrackerConnectorFactory btFactory;
    @Inject
    private ExecutionRunnerControllerHelper helper;
    @Inject
    private ExecutionProcessingService executionProcessingService;
    @Inject
    private BugTrackersLocalService bugTrackersLocalService;

    private String getRedirectExecURL(long executionId, boolean optimized) {
        return "/execute/" + executionId + "?optimized=" + optimized;
    }

    @RequestMapping(value={"/{stepIndex}"}, params={"optimized=true"})
    public String startResumeExecutionAtSpecifiedStepInOptimizedRunner(@PathVariable long executionId, Model model, HttpServletRequest context, Locale locale, @PathVariable int stepIndex) {
        RunnerState state = this.helper.initOptimizedSingleContext(executionId, context.getContextPath(), locale);
        state.setCurrentStepIndex(stepIndex + 1);
        state.setPrologue(false);
        model.addAttribute("config", (Object)state);
        this.addBugtrackerToModel(executionId, model);
        return OPTIMIZED_RUNNER_MAIN;
    }

    private void addBugtrackerToModel(long executionId, Model model) {
        try {
            Project project = this.executionProcessingService.findExecution(Long.valueOf(executionId)).getProject();
            BugTracker bugtracker = project.findBugTracker();
            BugTrackerInterfaceDescriptor descriptor = this.bugTrackersLocalService.getInterfaceDescriptor(bugtracker);
            String projectNames = JsonHelper.serialize(project.getBugtrackerBinding().getProjectNames().stream().map(HTMLCleanupUtils::cleanAndUnescapeHTML).collect(Collectors.toList()));
            model.addAttribute("interfaceDescriptor", (Object)descriptor);
            model.addAttribute("bugTracker", (Object)bugtracker);
            model.addAttribute("projectId", (Object)project.getId());
            model.addAttribute("projectNames", (Object)projectNames);
            model.addAttribute("isOslc", (Object)this.btFactory.isOslcConnector(bugtracker.getKind()));
        }
        catch (NoBugTrackerBindingException noBugTrackerBindingException) {}
    }

    @RequestMapping(params={"optimized=true"})
    public String startResumeExecutionInOptimizedRunner(@PathVariable long executionId, Model model, HttpServletRequest context, Locale locale) {
        RunnerState state = this.helper.initOptimizedSingleContext(executionId, context.getContextPath(), locale);
        model.addAttribute("config", (Object)state);
        this.addBugtrackerToModel(executionId, model);
        return OPTIMIZED_RUNNER_MAIN;
    }

    @RequestMapping(params={"optimized=false"})
    @ResponseStatus(value=HttpStatus.MOVED_PERMANENTLY)
    public String startResumeExecutionInClassicRunner(@PathVariable long executionId) {
        return "redirect:" + this.getRedirectExecURL(executionId, false);
    }

    @RequestMapping(params={"dry-run"})
    @ResponseBody
    public void dryRunStartResumeExecution(@PathVariable long executionId) {
        this.executionProcessingService.findRunnableExecutionStep(executionId);
    }
}

