/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.execution;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.MultiValuedCustomFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedMultiSelectField;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.web.internal.controller.execution.ExecutionModificationController;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

class ExecutionStepDataTableModelHelper
extends DataTableModelBuilder<ExecutionStep> {
    private static final int DEFAULT_MAP_CAPACITY = 16;
    private Locale locale;
    private InternationalizationHelper messageSource;
    boolean isAutomated = false;
    private int nbCufsPerEntity;
    private int nbDenoPerEntity;
    private Map<Long, Map<String, CustomFieldValueTableModel>> customFieldValuesById;
    private Map<Long, Map<String, CustomFieldValueTableModel>> denormalizedFieldValuesById;

    ExecutionStepDataTableModelHelper(Locale locale, InternationalizationHelper messageSource, boolean isAutomated) {
        this.locale = locale;
        this.messageSource = messageSource;
        this.isAutomated = isAutomated;
    }

    public Map<Object, Object> buildItemData(ExecutionStep item) {
        HashMap<Object, Object> res = new HashMap<Object, Object>(13 + this.nbCufsPerEntity + this.nbDenoPerEntity);
        res.put("entity-id", item.getId());
        res.put("entity-index", item.getExecutionStepOrder() + 1);
        res.put("action", HTMLCleanupUtils.cleanHtml(item.getAction()));
        res.put("expected", HTMLCleanupUtils.cleanHtml(item.getExpectedResult()));
        res.put("last-exec-on", this.formatDate(item.getLastExecutedOn(), this.locale));
        res.put("last-exec-by", item.getLastExecutedBy());
        res.put("comment", HTMLCleanupUtils.cleanHtml(item.getComment()));
        res.put("bug-list", ExecutionModificationController.createBugList(item));
        res.put("bug-button", "");
        res.put("nb-attachments", item.getAttachmentList().size());
        res.put("attach-list-id", item.getAttachmentList().getId());
        res.put("run-step-button", "");
        String status = this.isAutomated ? "--" : ExecutionModificationController.localizedStatus(item.getExecutionStatus(), this.locale, this.messageSource);
        res.put("status", status);
        this.appendCustomFields(res);
        this.appendDenoFields(res);
        return res;
    }

    public void usingCustomFields(Collection<CustomFieldValue> cufValues) {
        this.usingCustomFields(cufValues, 16);
    }

    public void usingCustomFields(Collection<CustomFieldValue> cufValues, int nbFieldsPerEntity) {
        this.customFieldValuesById = new HashMap<Long, Map<String, CustomFieldValueTableModel>>();
        this.nbCufsPerEntity = nbFieldsPerEntity;
        for (CustomFieldValue value : cufValues) {
            Long entityId = value.getBoundEntityId();
            Map<String, CustomFieldValueTableModel> values = this.customFieldValuesById.get(entityId);
            if (values == null) {
                values = new HashMap<String, CustomFieldValueTableModel>(this.nbCufsPerEntity);
                this.customFieldValuesById.put(entityId, values);
            }
            values.put(value.getCustomField().getCode(), new CustomFieldValueTableModel(value));
        }
    }

    private void appendCustomFields(Map<Object, Object> item) {
        Map<String, CustomFieldValueTableModel> cufValues = this.getCustomFieldsFor((Long)item.get("entity-id"));
        item.put("customFields", cufValues);
    }

    private Map<String, CustomFieldValueTableModel> getCustomFieldsFor(Long id) {
        if (this.customFieldValuesById == null) {
            return new HashMap<String, CustomFieldValueTableModel>();
        }
        Map<String, CustomFieldValueTableModel> values = this.customFieldValuesById.get(id);
        if (values == null) {
            values = new HashMap<String, CustomFieldValueTableModel>();
        }
        return values;
    }

    public void usingDenoFields(Collection<DenormalizedFieldValue> cufValues) {
        this.usingDenormalizedFields(cufValues, 16);
    }

    public void usingDenormalizedFields(Collection<DenormalizedFieldValue> dfvValues, int nbFieldsPerEntity) {
        this.denormalizedFieldValuesById = new HashMap<Long, Map<String, CustomFieldValueTableModel>>();
        this.nbDenoPerEntity = nbFieldsPerEntity;
        for (DenormalizedFieldValue value : dfvValues) {
            Long entityId = value.getDenormalizedFieldHolderId();
            Map<String, CustomFieldValueTableModel> values = this.denormalizedFieldValuesById.get(entityId);
            if (values == null) {
                values = new HashMap<String, CustomFieldValueTableModel>(this.nbDenoPerEntity);
                this.denormalizedFieldValuesById.put(entityId, values);
            }
            values.put(value.getCode(), new CustomFieldValueTableModel(value));
        }
    }

    private void appendDenoFields(Map<Object, Object> item) {
        Map<String, CustomFieldValueTableModel> cufValues = this.getDenoFieldsFor((Long)item.get("entity-id"));
        item.put("denormalizedFields", cufValues);
    }

    private Map<String, CustomFieldValueTableModel> getDenoFieldsFor(Long id) {
        if (this.denormalizedFieldValuesById == null) {
            return new HashMap<String, CustomFieldValueTableModel>();
        }
        Map<String, CustomFieldValueTableModel> values = this.denormalizedFieldValuesById.get(id);
        if (values == null) {
            values = new HashMap<String, CustomFieldValueTableModel>();
        }
        return values;
    }

    private String formatDate(Date date, Locale locale) {
        return this.messageSource.localizeDate(date, locale);
    }

    protected static class CustomFieldValueTableModel {
        private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldValueTableModel.class);
        private static final String UNUSED = "unused";
        private String value;
        private List<String> values;
        private Long id;

        public Object getValue() {
            return this.value != null ? this.value : this.values;
        }

        public Long getId() {
            return this.id;
        }

        public CustomFieldValueTableModel() {
        }

        public Date getValueAsDate() {
            try {
                return DateUtils.parseIso8601Date((String)this.value);
            }
            catch (ParseException parseException) {
                LOGGER.debug("Unable to parse date {} of custom field #{}", (Object)this.value, (Object)this.id);
                return null;
            }
        }

        private CustomFieldValueTableModel(CustomFieldValue value) {
            this.id = value.getId();
            if (MultiValuedCustomFieldValue.class.isAssignableFrom(value.getClass())) {
                List rawValues = ((MultiValuedCustomFieldValue)value).getValues();
                ArrayList<String> escapedValues = new ArrayList<String>();
                if (rawValues != null) {
                    for (String rawValue : rawValues) {
                        escapedValues.add(HTMLCleanupUtils.cleanHtml(rawValue));
                    }
                }
                this.values = escapedValues;
            } else {
                this.value = HTMLCleanupUtils.cleanHtml(value.getValue());
            }
        }

        private CustomFieldValueTableModel(DenormalizedFieldValue value) {
            this.id = value.getId();
            if (DenormalizedMultiSelectField.class.isAssignableFrom(value.getClass())) {
                List rawValues = ((DenormalizedMultiSelectField)value).getValues();
                ArrayList<String> escapedValues = new ArrayList<String>();
                if (rawValues != null) {
                    for (String rawValue : rawValues) {
                        escapedValues.add(HTMLCleanupUtils.cleanHtml(rawValue));
                    }
                }
                this.values = escapedValues;
            } else {
                this.value = HTMLCleanupUtils.cleanHtml(value.getValue());
            }
        }
    }
}

