/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.execution;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.ExecutionVisitor;
import org.squashtest.tm.domain.execution.IsKeywordExecutionVisitor;
import org.squashtest.tm.domain.execution.IsScriptedExecutionVisitor;
import org.squashtest.tm.domain.execution.ScriptedExecution;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.campaign.TestPlanExecutionProcessingService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.denormalizedfield.DenormalizedFieldValueManager;
import org.squashtest.tm.service.execution.ExecutionProcessingService;
import org.squashtest.tm.service.execution.ScriptedExecutionFinder;
import org.squashtest.tm.service.requirement.VerifiedRequirement;
import org.squashtest.tm.service.requirement.VerifiedRequirementsFinderService;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.web.internal.controller.execution.RunnerState;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Component
public class ExecutionRunnerControllerHelper {
    public static final String TEST_PLAN_ITEM_URL_PATTERN = "/test-suites/{0,number,####}/test-plan/{1,number,####}";
    public static final String TEST_SUITE_NEXT_EXECUTION_URL = "/test-suites/{0,number,####}/test-plan/{1,number,####}/next-execution/runner";
    public static final String ITERATION_NEXT_EXECUTION_URL = "/iterations/{0,number,####}/test-plan/{1,number,####}/next-execution/runner";
    public static final String CURRENT_STEP_URL_PATTERN = "/execute/{0,number,####}/step";
    public static final String COMPLETION_POPUP_TITLE = "popup.title.info";
    public static final String COMPLETED_SUITE_MESSAGE = "squashtm.action.exception.testsuite.end";
    public static final String COMPLETED_ITERATION_MESSAGE = "squashtm.action.exception.iteration.end";
    public static final String COMPLETED_STEP_MESSAGE = "execute.alert.test.complete";
    @Inject
    private ExecutionProcessingService executionProcessingService;
    @Inject
    private TestPlanExecutionProcessingService<TestSuite> testSuiteExecutionProcessingService;
    @Inject
    private TestPlanExecutionProcessingService<Iteration> iterationExecutionProcessingService;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentHelper;
    @Inject
    private MessageSource messageSource;
    @Inject
    private DenormalizedFieldValueManager denormalizedFieldValueFinder;
    @Inject
    private CustomFieldValueFinderService customFieldValueFinderService;
    @Inject
    private ScriptedExecutionFinder scriptedExecutionFinder;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private UserAccountService userService;
    @Inject
    private PartyPreferenceService preferenceService;
    @Inject
    private VerifiedRequirementsFinderService verifiedRequirementsFinderService;

    private ExecutionStep findStepAtIndex(long executionId, int stepIndex) {
        int stepCount = this.executionProcessingService.findTotalNumberSteps(Long.valueOf(executionId));
        if (stepIndex >= stepCount) {
            return this.executionProcessingService.findStepAt(executionId, stepCount - 1);
        }
        ExecutionStep executionStep = this.executionProcessingService.findStepAt(executionId, stepIndex);
        if (executionStep == null) {
            executionStep = this.executionProcessingService.findStepAt(executionId, stepCount - 1);
        }
        return executionStep;
    }

    public void populateStepAtIndexModel(long executionId, int stepIndex, Model model) {
        Execution execution = this.executionProcessingService.findExecution(Long.valueOf(executionId));
        ExecutionStep executionStep = this.findStepAtIndex(executionId, stepIndex);
        this.populateExecutionStepModel(execution, executionStep, model);
    }

    private void populateExecutionStepModel(Execution execution, ExecutionStep executionStep, Model model) {
        int stepOrder = 0;
        int total = execution.getSteps().size();
        Set<Object> attachments = Collections.emptySet();
        String bugtrackerMode = this.getBugTrackerModeFromUserPreferences();
        boolean hasDenormFields = false;
        boolean hasCustomFields = false;
        if (executionStep != null) {
            stepOrder = executionStep.getExecutionStepOrder();
            hasDenormFields = this.denormalizedFieldValueFinder.hasDenormalizedFields((DenormalizedFieldHolder)executionStep);
            hasCustomFields = this.customFieldValueFinderService.hasCustomFields((BoundEntity)executionStep);
            attachments = this.attachmentHelper.findAttachments((AttachmentHolder)executionStep);
        }
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(execution.getIteration());
        IsScriptedExecutionVisitor isScriptedExecutionVisitor = new IsScriptedExecutionVisitor();
        execution.accept((ExecutionVisitor)isScriptedExecutionVisitor);
        IsKeywordExecutionVisitor isKeywordExecutionVisitor = new IsKeywordExecutionVisitor();
        execution.accept((ExecutionVisitor)isKeywordExecutionVisitor);
        model.addAttribute("execution", (Object)execution);
        model.addAttribute("isExecutionScripted", (Object)isScriptedExecutionVisitor.isScripted());
        model.addAttribute("isExecutionKeyword", (Object)isKeywordExecutionVisitor.isKeyword());
        model.addAttribute("executionStep", (Object)executionStep);
        model.addAttribute("hasDenormFields", (Object)hasDenormFields);
        model.addAttribute("hasCustomFields", (Object)hasCustomFields);
        model.addAttribute("totalSteps", (Object)total);
        model.addAttribute("hasNextStep", (Object)(stepOrder != total - 1 ? 1 : 0));
        model.addAttribute("attachments", attachments);
        model.addAttribute("allowsUntestable", (Object)execution.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.UNTESTABLE));
        model.addAttribute("allowsSettled", (Object)execution.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.SETTLED));
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        model.addAttribute("bugtrackerMode", (Object)bugtrackerMode);
        this.addCurrentStepUrl(execution.getId(), model);
    }

    public void popuplateExecutionPreview(long executionId, boolean isOptimized, Model model) {
        this.populateExecutionPreview(executionId, isOptimized, new RunnerState(), model);
    }

    public void populateClassicSingleModel(Model model) {
        model.addAttribute("optimized", (Object)false);
    }

    public void populateOptimizedSingleModel(Model model) {
        model.addAttribute("optimized", (Object)true);
    }

    public RunnerState initOptimizedSingleContext(long executionId, String contextPath, Locale locale) {
        RunnerState state = this.createRunnerState(true);
        this.populatePopupMessages(state, locale, COMPLETED_SUITE_MESSAGE);
        this.populatePrologueStatus(executionId, state);
        this.populateEntitiesInfos(executionId, state, contextPath);
        return state;
    }

    public RunnerState createOptimizedRunnerStateForTestSuite(long testSuiteId, Execution execution, String contextPath, Locale locale) {
        RunnerState state = this.createRunnerState(false);
        this.populateUndifferentiatedRunnerState(state, testSuiteId, execution, contextPath);
        this.populatePopupMessages(state, locale, COMPLETED_SUITE_MESSAGE);
        IterationTestPlanItem item = execution.getTestPlan();
        boolean hasNextTestCase = this.testSuiteExecutionProcessingService.hasMoreExecutableItems(testSuiteId, item.getId().longValue());
        this.populateNextExecutionUrl(state, contextPath, TEST_SUITE_NEXT_EXECUTION_URL, testSuiteId, item.getId());
        state.setLastTestCase(!hasNextTestCase);
        return state;
    }

    public RunnerState createOptimizedRunnerStateForIteration(long iterationId, Execution execution, String contextPath, Locale locale) {
        RunnerState state = this.createRunnerState(false);
        this.populateUndifferentiatedRunnerState(state, iterationId, execution, contextPath);
        this.populatePopupMessages(state, locale, COMPLETED_ITERATION_MESSAGE);
        IterationTestPlanItem item = execution.getTestPlan();
        this.populateNextExecutionUrl(state, contextPath, ITERATION_NEXT_EXECUTION_URL, iterationId, item.getId());
        boolean hasNextTestCase = this.iterationExecutionProcessingService.hasMoreExecutableItems(iterationId, item.getId().longValue());
        state.setLastTestCase(!hasNextTestCase);
        return state;
    }

    public RunnerState createRunnerState(boolean isOptimized) {
        RunnerState state = new RunnerState();
        state.setOptimized(isOptimized);
        return state;
    }

    private void populateUndifferentiatedRunnerState(RunnerState state, long testPlanOwnerId, Execution execution, String contextPath) {
        state.setTestSuiteId(testPlanOwnerId);
        state.setTestPlanItemId(execution.getTestPlan().getId());
        this.populatePrologueStatus(execution.getId(), state);
        this.populateEntitiesInfos(execution.getId(), state, contextPath);
    }

    private void populateNextExecutionUrl(RunnerState state, String contextPath, String nextExecutionUrlPattern, long testPlanOwnerId, long itemId) {
        String nextExecutionUrl = String.valueOf(contextPath) + MessageFormat.format(nextExecutionUrlPattern, testPlanOwnerId, itemId);
        state.setNextTestCaseUrl(nextExecutionUrl);
    }

    private void populatePrologueStatus(long executionId, RunnerState state) {
        if (this.executionProcessingService.wasNeverRun(Long.valueOf(executionId))) {
            state.setPrologue(true);
        } else {
            state.setPrologue(false);
        }
    }

    private void populateEntitiesInfos(long executionId, RunnerState state, String contextPath) {
        ExecutionStep step = this.executionProcessingService.findRunnableExecutionStep(executionId);
        int totalSteps = this.executionProcessingService.findTotalNumberSteps(Long.valueOf(executionId));
        boolean wasNeverExecuted = this.executionProcessingService.wasNeverRun(Long.valueOf(executionId));
        int stepOrder = wasNeverExecuted ? 0 : step.getExecutionStepOrder() + 1;
        String currentStepUrl = String.valueOf(contextPath) + MessageFormat.format(CURRENT_STEP_URL_PATTERN, executionId);
        state.setBaseStepUrl(currentStepUrl);
        Execution execution = this.executionProcessingService.findExecution(Long.valueOf(executionId));
        TestCase tc = execution.getReferencedTestCase();
        Long tcId = tc != null ? tc.getId() : null;
        state.setReferencedTestCaseId(tcId);
        state.setCurrentExecutionId(executionId);
        state.setCurrentStepId(step.getId());
        state.setFirstStepIndex(0);
        state.setLastStepIndex(totalSteps);
        state.setCurrentStepIndex(stepOrder);
        state.setCurrentStepStatus(step.getExecutionStatus());
        CampaignLibrary lib = step.getProject().getCampaignLibrary();
        state.setAllowsSettled(lib.allowsStatus(ExecutionStatus.SETTLED));
        state.setAllowsUntestable(lib.allowsStatus(ExecutionStatus.UNTESTABLE));
    }

    private void populatePopupMessages(RunnerState state, Locale locale, String completeTestPlanMessage) {
        String popupTitle = this.messageSource.getMessage(COMPLETION_POPUP_TITLE, null, locale);
        String completeTestMessage = this.messageSource.getMessage(COMPLETED_STEP_MESSAGE, null, locale);
        String completeSuiteMessage = this.messageSource.getMessage(completeTestPlanMessage, null, locale);
        state.setCompleteTitle(HTMLCleanupUtils.cleanHtml(popupTitle));
        state.setCompleteTestMessage(HTMLCleanupUtils.cleanHtml(completeTestMessage));
        state.setCompleteSuiteMessage(HTMLCleanupUtils.cleanHtml(completeSuiteMessage));
    }

    private void addCurrentStepUrl(long executionId, Model model) {
        String currentStepUrl = MessageFormat.format(CURRENT_STEP_URL_PATTERN, executionId);
        model.addAttribute("currentStepsUrl", (Object)currentStepUrl);
    }

    public void populateExecutionPreview(long executionId, boolean optimized, RunnerState runnerState, Model model) {
        Execution execution = this.executionProcessingService.findExecution(Long.valueOf(executionId));
        int totalSteps = this.executionProcessingService.findTotalNumberSteps(Long.valueOf(executionId));
        boolean hasCustomFields = this.customFieldValueFinderService.hasCustomFields((BoundEntity)execution);
        boolean hasDenormFields = this.denormalizedFieldValueFinder.hasDenormalizedFields((DenormalizedFieldHolder)execution);
        String bugtrackerMode = this.getBugTrackerModeFromUserPreferences();
        runnerState.setOptimized(optimized);
        runnerState.setPrologue(true);
        IsScriptedExecutionVisitor isScriptedExecVisitor = new IsScriptedExecutionVisitor();
        execution.accept((ExecutionVisitor)isScriptedExecVisitor);
        boolean isExecutionScripted = isScriptedExecVisitor.isScripted();
        IsKeywordExecutionVisitor isKeywordExecutionVisitor = new IsKeywordExecutionVisitor();
        execution.accept((ExecutionVisitor)isKeywordExecutionVisitor);
        boolean isExecutionKeyword = isKeywordExecutionVisitor.isKeyword();
        model.addAttribute("execution", (Object)execution);
        model.addAttribute("isExecutionKeyword", (Object)isExecutionKeyword);
        model.addAttribute("isExecutionScripted", (Object)isExecutionScripted);
        if (isExecutionScripted) {
            ScriptedExecution scriptedExecution = this.scriptedExecutionFinder.findById(executionId);
            model.addAttribute("executionScriptName", (Object)scriptedExecution.getScriptName());
        }
        model.addAttribute("config", (Object)runnerState);
        model.addAttribute("totalSteps", (Object)totalSteps);
        model.addAttribute("attachments", this.attachmentHelper.findAttachments((AttachmentHolder)execution));
        model.addAttribute("hasCustomFields", (Object)hasCustomFields);
        model.addAttribute("hasDenormFields", (Object)hasDenormFields);
        model.addAttribute("bugtrackerMode", (Object)bugtrackerMode);
        if (execution.getReferencedTestCase() != null) {
            List verifiedRequirements = this.verifiedRequirementsFinderService.findAllVerifiedRequirementsByTestCaseId(execution.getReferencedTestCase().getId().longValue());
            ArrayList<RequirementVersion> requirementVersions = new ArrayList<RequirementVersion>();
            for (VerifiedRequirement verifiedRequirement : verifiedRequirements) {
                requirementVersions.add(verifiedRequirement.getVerifiedRequirementVersion());
            }
            model.addAttribute("verifiedReqVersions", requirementVersions);
        }
    }

    private String getBugTrackerModeFromUserPreferences() {
        User user = this.userService.findCurrentUser();
        Party party = this.userService.getParty(user.getId());
        Map map = this.preferenceService.findPreferences(party);
        return (String)map.get("squash.bug.tracker.mode");
    }
}

