/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.execution;

import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;
import org.squashtest.tm.web.internal.controller.execution.ExecutionRunnerControllerHelper;
import org.squashtest.tm.web.internal.controller.execution.StepState;
import org.squashtest.tm.web.internal.model.json.JsonStepInfo;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/execute/{executionId}"})
public class ExecutionProcessingController {
    private static final String OPTIMIZED = "optimized";
    private static final String ACCEPT_HTML_HEADER = "Accept=text/html";
    private static final String EXECUTE = "/execute/";
    private static final String REDIRECT = "redirect:";
    private static final String STEP_URL = "/step/index/{stepIndex}";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionProcessingController.class);
    @Inject
    private ExecutionRunnerControllerHelper helper;
    @Inject
    private ExecutionProcessingService executionProcService;
    @Inject
    private CustomIterationModificationService itpService;

    private void addCurrentStepUrl(long executionId, Model model) {
        model.addAttribute("currentStepsUrl", (Object)(EXECUTE + executionId + "/step"));
    }

    private String getRedirectToPrologue(long executionId, boolean optimized) {
        return EXECUTE + executionId + "/step/prologue?optimized=" + optimized;
    }

    private String getRedirectToStep(long executionId, int stepIndex, boolean optimized) {
        return EXECUTE + executionId + "/step/index/" + stepIndex + "?optimized=" + optimized;
    }

    @RequestMapping(method={RequestMethod.GET}, params={"optimized"})
    @ResponseStatus(value=HttpStatus.MOVED_PERMANENTLY)
    public String executeFirstRunnableStep(@PathVariable long executionId, @RequestParam(value="optimized") boolean optimized) {
        if (this.executionProcService.wasNeverRun(Long.valueOf(executionId))) {
            return REDIRECT + this.getRedirectToPrologue(executionId, optimized);
        }
        int stepIndex = this.executionProcService.findRunnableExecutionStep(executionId).getExecutionStepOrder();
        return REDIRECT + this.getRedirectToStep(executionId, stepIndex, optimized);
    }

    @RequestMapping(value={"/step/prologue"}, method={RequestMethod.GET}, params={"optimized"})
    public String getExecutionPrologue(@PathVariable long executionId, @RequestParam(value="optimized") boolean optimized, Model model) {
        this.addCurrentStepUrl(executionId, model);
        this.helper.popuplateExecutionPreview(executionId, optimized, model);
        return "execute-execution-preview.html";
    }

    @RequestMapping(value={"/step/index/{stepIndex}"}, method={RequestMethod.GET}, params={"optimized=false"}, headers={"Accept=text/html"})
    public String getClassicSingleExecutionStepFragment(@PathVariable long executionId, @PathVariable int stepIndex, Model model) {
        this.helper.populateStepAtIndexModel(executionId, stepIndex, model);
        this.helper.populateClassicSingleModel(model);
        return "page/executions/execute-execution";
    }

    @RequestMapping(value={"/step/index/{stepIndex}"}, method={RequestMethod.GET}, params={"optimized=true"}, headers={"Accept=text/html"})
    public String getOptimizedSingleExecutionStepFragment(@PathVariable long executionId, @PathVariable int stepIndex, Model model) {
        this.helper.populateStepAtIndexModel(executionId, stepIndex, model);
        this.helper.populateOptimizedSingleModel(model);
        return "page/executions/oer-execute-execution";
    }

    @RequestMapping(value={"/step/index/{stepIndex}"}, method={RequestMethod.GET}, params={"optimized"}, headers={"Accept=application/json"})
    @ResponseBody
    public StepState getStepState(@PathVariable Long executionId, @PathVariable Integer stepIndex) {
        ExecutionStep executionStep = this.executionProcService.findStepAt(executionId.longValue(), stepIndex.intValue());
        return new StepState(executionStep);
    }

    @RequestMapping(value={"/step/{stepId}"}, params={"optimized=false"})
    @ResponseStatus(value=HttpStatus.MOVED_PERMANENTLY)
    public String startResumeExecutionStepInClassicRunner(@PathVariable long executionId, @PathVariable long stepId) {
        Execution execution = this.executionProcService.findExecution(Long.valueOf(executionId));
        int stepIndex = execution.getStepIndex(stepId);
        return REDIRECT + this.getRedirectToStep(executionId, stepIndex, false);
    }

    @RequestMapping(value={"/step/index/{stepIndex}/general"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonStepInfo getBasicInfos(@PathVariable long executionId, @PathVariable int stepIndex) {
        ExecutionStep executionStep = this.executionProcService.findStepAt(executionId, stepIndex);
        return new JsonStepInfo(executionStep.getLastExecutedOn(), executionStep.getLastExecutedBy());
    }

    @RequestMapping(value={"/step/{stepId}"}, method={RequestMethod.POST}, params={"id=execution-comment", "value"})
    @ResponseBody
    public String updateComment(@RequestParam(value="value") String newComment, @PathVariable long stepId) {
        this.executionProcService.setExecutionStepComment(Long.valueOf(stepId), newComment);
        LOGGER.trace("ExecutionStep {}: updated comment to {}", (Object)stepId, (Object)newComment);
        return HTMLCleanupUtils.cleanHtml(newComment);
    }

    @RequestMapping(value={"/step/{stepId}"}, method={RequestMethod.POST}, params={"executionStatus"})
    @ResponseBody
    public void updateExecutionStatus(@RequestParam String executionStatus, @PathVariable long stepId) {
        ExecutionStatus status = ExecutionStatus.valueOf((String)executionStatus);
        this.executionProcService.changeExecutionStepStatus(Long.valueOf(stepId), status);
    }

    @RequestMapping(value={"/update-from-tc"}, method={RequestMethod.POST})
    @ResponseBody
    public Long updateExecutionFromTc(@PathVariable long executionId) {
        Execution exec = this.itpService.updateExecutionFromTc(executionId);
        return exec.getId();
    }
}

