/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.execution;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RenderingLocation;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.ExecutionVisitor;
import org.squashtest.tm.domain.execution.IsKeywordExecutionVisitor;
import org.squashtest.tm.domain.execution.IsScriptedExecutionVisitor;
import org.squashtest.tm.domain.execution.IsStandardExecutionVisitor;
import org.squashtest.tm.domain.execution.ScriptedExecution;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.customfield.CustomFieldHelper;
import org.squashtest.tm.service.customfield.CustomFieldHelperService;
import org.squashtest.tm.service.customfield.DenormalizedFieldHelper;
import org.squashtest.tm.service.denormalizedfield.DenormalizedFieldValueManager;
import org.squashtest.tm.service.execution.ExecutionModificationService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;
import org.squashtest.tm.service.execution.ScriptedExecutionFinder;
import org.squashtest.tm.service.internal.dto.CustomFieldJsonConverter;
import org.squashtest.tm.service.internal.dto.CustomFieldModel;
import org.squashtest.tm.service.internal.dto.CustomFieldValueModel;
import org.squashtest.tm.service.requirement.VerifiedRequirement;
import org.squashtest.tm.service.requirement.VerifiedRequirementsFinderService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.controller.execution.ExecutionStepDataTableModelHelper;
import org.squashtest.tm.web.internal.controller.generic.DataTableColumnDefHelper;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.testcase.executions.ExecutionStatusJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.widget.AoColumnDef;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.helper.LevelLabelFormatter;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTablePaging;
import org.squashtest.tm.web.internal.model.json.JsonExecutionInfo;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/executions/{executionId}"})
public class ExecutionModificationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionModificationController.class);
    private static final String EXECUTION = "Execution ";
    @Inject
    private ExecutionModificationService executionModService;
    @Inject
    private ExecutionProcessingService executionProcService;
    @Inject
    private ScriptedExecutionFinder scriptedExecutionFinder;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private DenormalizedFieldValueManager denormalizedFieldValueFinder;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentHelper;
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private Provider<LevelLabelFormatter> levelFormatterProvider;
    @Inject
    private Provider<ExecutionStatusJeditableComboDataBuilder> executionStatusComboBuilderProvider;
    @Inject
    private IterationTestPlanManagerService iterationTestPlanManagerService;
    @Inject
    private CustomFieldHelperService cufHelperService;
    @Inject
    private CustomFieldJsonConverter converter;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private VerifiedRequirementsFinderService verifiedRequirementsFinderService;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getExecution(@PathVariable long executionId) {
        Execution execution = this.executionModService.findAndInitExecution(Long.valueOf(executionId));
        TestCase referencedTc = execution.getReferencedTestCase();
        int rank = this.executionModService.findExecutionRank(Long.valueOf(executionId));
        LOGGER.trace("ExecutionModService : getting execution {}, rank {}", (Object)executionId, (Object)rank);
        List<CustomFieldValueModel> customValueModels = this.getExecutionCustomFieldValueModels(execution);
        List<CustomFieldValueModel> denoValueModels = this.getExecutionDenormalizedFieldValueModels(execution);
        List<AoColumnDef> columnDefs = this.findColumnDefForSteps(execution);
        LinkedList<CustomFieldModel> stepCufsModels = new LinkedList<CustomFieldModel>();
        IsStandardExecutionVisitor standardExecutionVisitor = new IsStandardExecutionVisitor();
        execution.accept((ExecutionVisitor)standardExecutionVisitor);
        boolean isStandardExecution = standardExecutionVisitor.isStandard();
        if (!execution.getSteps().isEmpty() && isStandardExecution) {
            stepCufsModels.addAll(this.getStepDenormalizedFieldModels(execution));
            stepCufsModels.addAll(this.getStepCustomFieldModels(execution));
        }
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(execution.getIteration());
        ModelAndView mav = new ModelAndView("page/campaign-workspace/show-execution");
        mav.addObject("execution", (Object)execution);
        IsScriptedExecutionVisitor executionVisitor = new IsScriptedExecutionVisitor();
        execution.accept((ExecutionVisitor)executionVisitor);
        boolean isExecutionScripted = executionVisitor.isScripted();
        mav.addObject("isExecutionScripted", (Object)isExecutionScripted);
        if (isExecutionScripted) {
            ScriptedExecution scriptedExecution = this.scriptedExecutionFinder.findById(executionId);
            mav.addObject("executionScriptName", (Object)scriptedExecution.getScriptName());
        }
        IsKeywordExecutionVisitor keywordExecutionVisitor = new IsKeywordExecutionVisitor();
        execution.accept((ExecutionVisitor)keywordExecutionVisitor);
        boolean isKeywordExecution = keywordExecutionVisitor.isKeyword();
        mav.addObject("isKeywordExecution", (Object)isKeywordExecution);
        mav.addObject("referencedTc", (Object)referencedTc);
        mav.addObject("executionRank", (Object)(rank + 1));
        mav.addObject("attachmentSet", this.attachmentHelper.findAttachments((AttachmentHolder)execution));
        mav.addObject("executionCufValues", customValueModels);
        mav.addObject("executionDenormalizedValues", denoValueModels);
        mav.addObject("stepsAoColumnDefs", (Object)JsonHelper.serialize(columnDefs));
        mav.addObject("stepsCufDefinitions", stepCufsModels);
        mav.addObject("statuses", this.getStatuses(execution.getProject().getId()));
        mav.addObject("milestoneConf", (Object)milestoneConf);
        if (execution.getReferencedTestCase() != null) {
            List verifiedRequirements = this.verifiedRequirementsFinderService.findAllVerifiedRequirementsByTestCaseId(execution.getReferencedTestCase().getId().longValue());
            ArrayList<RequirementVersion> requirementVersions = new ArrayList<RequirementVersion>();
            for (VerifiedRequirement verifiedRequirement : verifiedRequirements) {
                requirementVersions.add(verifiedRequirement.getVerifiedRequirementVersion());
            }
            mav.addObject("verifiedReqVersions", requirementVersions);
        }
        return mav;
    }

    private List<AoColumnDef> findColumnDefForSteps(Execution execution) {
        boolean editable = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "EXECUTE", (Object)execution);
        boolean isBugtrackerConnected = execution.getProject().isBugtrackerConnected();
        IsStandardExecutionVisitor visitor = new IsStandardExecutionVisitor();
        execution.accept((ExecutionVisitor)visitor);
        List columnDefs = new ExecutionStepTableColumnDefHelper().getAoColumnDfvDefs(editable, isBugtrackerConnected, visitor.isStandard());
        return columnDefs;
    }

    @RequestMapping(value={"/steps"}, method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getStepsTableModel(@PathVariable long executionId, DataTableDrawParameters params, Locale locale) {
        LOGGER.trace("execsteps table : entering controller");
        Execution exec = this.executionModService.findById(executionId);
        Paging filter = this.createPaging(params);
        LOGGER.trace("execsteps table : fetching steps");
        PagedCollectionHolder holder = this.executionModService.findExecutionSteps(executionId, filter);
        LOGGER.trace("execsteps table : finished steps");
        LOGGER.trace("execsteps table : fetching cufs / deno");
        CustomFieldHelper cufHelper = this.cufHelperService.newHelper((List)holder.getPagedItems()).setRenderingLocations(new RenderingLocation[]{RenderingLocation.STEP_TABLE}).restrictToCommonFields();
        List cufValues = cufHelper.getCustomFieldValues();
        int nbCufs = cufHelper.getCustomFieldConfiguration().size();
        DenormalizedFieldHelper denoHelper = this.cufHelperService.newDenormalizedHelper((List)holder.getPagedItems()).setRenderingLocations(new RenderingLocation[]{RenderingLocation.STEP_TABLE});
        List denoValues = denoHelper.getDenormalizedFieldValues();
        int nbDeno = denoHelper.getCustomFieldConfiguration().size();
        LOGGER.trace("execsteps table : finished cufs / deno");
        LOGGER.trace("execsteps table : creating model");
        ExecutionStepDataTableModelHelper tableHelper = new ExecutionStepDataTableModelHelper(locale, this.messageSource, exec.isAutomated());
        tableHelper.usingCustomFields(cufValues, nbCufs);
        tableHelper.usingDenormalizedFields(denoValues, nbDeno);
        DataTableModel model = tableHelper.buildDataModel(holder, params.getsEcho());
        LOGGER.trace("execsteps table : finished model");
        return model;
    }

    @RequestMapping(value={"/steps/{stepIds}"}, method={RequestMethod.POST}, params={"status"})
    @ResponseBody
    public JsonExecutionInfo editStatusOfExecutionStep(@PathVariable long executionId, @PathVariable(value="stepIds") List<Long> stepIds, @RequestParam(value="status") String status) {
        ExecutionStatus executionStatus = ExecutionStatus.valueOf((String)status);
        for (Long stepId : stepIds) {
            this.executionProcService.changeExecutionStepStatus(stepId, executionStatus);
            this.executionProcService.updateStepExecutionData(this.executionProcService.findExecutionStep(stepId));
        }
        return this.createJsonExecutionStep(this.executionProcService.findExecutionStep(stepIds.get(0)));
    }

    @RequestMapping(value={"/auto-steps"}, method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getAutoStepsTableModel(@PathVariable long executionId, DataTableDrawParameters params, Locale locale) {
        return this.getStepsTableModel(executionId, params, locale);
    }

    static String createBugList(ExecutionStep item) {
        StringBuilder toReturn = new StringBuilder();
        List issueList = item.getIssueList().getAllIssues();
        if (!issueList.isEmpty()) {
            toReturn.append(((Issue)issueList.get(0)).getId());
        }
        int i = 1;
        while (i < issueList.size()) {
            toReturn.append(',');
            toReturn.append(((Issue)issueList.get(i)).getId());
            ++i;
        }
        return toReturn.toString();
    }

    private Map<String, String> getStatuses(long projectId) {
        Locale locale = LocaleContextHolder.getLocale();
        return ((ExecutionStatusJeditableComboDataBuilder)((ExecutionStatusJeditableComboDataBuilder)this.executionStatusComboBuilderProvider.get()).useContext(projectId).useLocale(locale)).buildMap();
    }

    private Paging createPaging(DataTableDrawParameters params) {
        return new DataTablePaging(params);
    }

    @RequestMapping(value={"/steps/{stepId}/comment"}, method={RequestMethod.POST}, params={"id", "value"})
    @ResponseBody
    String updateStepComment(@PathVariable Long stepId, @RequestParam(value="value") String newComment) {
        this.executionModService.setExecutionStepComment(stepId, newComment);
        LOGGER.trace("ExecutionModificationController : updated comment for step " + stepId);
        return HTMLCleanupUtils.cleanHtml(newComment);
    }

    @RequestMapping(value={"/steps/{stepId}/status"}, method={RequestMethod.GET})
    @ResponseBody
    String getStepStatus(@PathVariable(value="stepId") Long stepId) {
        return this.executionModService.findExecutionStepById(stepId.longValue()).getExecutionStatus().toString();
    }

    static String localizedStatus(ExecutionStatus status, Locale locale, MessageSource messageSource) {
        return messageSource.getMessage(status.getI18nKey(), null, locale);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=execution-description", "value"})
    @ResponseBody
    public String updateDescription(@RequestParam(value="value") String newDescription, @PathVariable long executionId) {
        this.executionModService.setExecutionDescription(Long.valueOf(executionId), newDescription);
        LOGGER.trace(EXECUTION + executionId + ": updated description to " + newDescription);
        return HTMLCleanupUtils.cleanHtml(newDescription);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=execution-assignment", "value"})
    @ResponseBody
    public String updateAssignment(@RequestParam(value="value") String newDescription, @PathVariable long executionId) {
        this.executionModService.setExecutionDescription(Long.valueOf(executionId), newDescription);
        LOGGER.trace(EXECUTION + executionId + ": updated description to " + newDescription);
        return HTMLCleanupUtils.cleanHtml(newDescription);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=execution-status", "value"})
    @ResponseBody
    public String updateStatus(@RequestParam(value="value") ExecutionStatus newStatus, @PathVariable long executionId, Locale locale) {
        this.executionModService.setExecutionStatus(Long.valueOf(executionId), newStatus);
        LOGGER.trace(EXECUTION + executionId + ": updated status to " + newStatus);
        return this.internationalize((Level)newStatus, locale);
    }

    @RequestMapping(value={"/general"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonExecutionInfo refreshGeneralInfos(@PathVariable long executionId) {
        Execution execution = this.executionModService.findAndInitExecution(Long.valueOf(executionId));
        return this.toJson(execution);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.DELETE})
    public Object removeExecution(@PathVariable(value="executionId") long executionId) {
        Execution execution = this.executionModService.findById(executionId);
        IterationTestPlanItem testPlan = execution.getTestPlan();
        Iteration iteration = testPlan.getIteration();
        this.executionModService.deleteExecution(execution);
        Long reNewStartDate = iteration.getActualStartDate() != null ? Long.valueOf(iteration.getActualStartDate().getTime()) : null;
        Long reNewEndDate = iteration.getActualEndDate() != null ? Long.valueOf(iteration.getActualEndDate().getTime()) : null;
        if (testPlan.getExecutions().isEmpty()) {
            this.iterationTestPlanManagerService.assignUserToTestPlanItem(testPlan.getId().longValue(), 0L);
        }
        return new StartEndDate(reNewStartDate, reNewEndDate);
    }

    @RequestMapping(value={"updateSteps"}, method={RequestMethod.POST})
    @ResponseBody
    public Long updateSteps(@PathVariable(value="executionId") long executionId) {
        return this.executionModService.updateSteps(executionId);
    }

    private List<CustomFieldModel> getStepDenormalizedFieldModels(Execution exec) {
        List firstStepDfv = this.denormalizedFieldValueFinder.findAllForEntityAndRenderingLocation((DenormalizedFieldHolder)exec.getSteps().get(0), RenderingLocation.STEP_TABLE);
        ArrayList<CustomFieldModel> models = new ArrayList<CustomFieldModel>(firstStepDfv.size());
        for (DenormalizedFieldValue field : firstStepDfv) {
            models.add(this.converter.toCustomFieldJsonModel(field));
        }
        return models;
    }

    private List<CustomFieldModel> getStepCustomFieldModels(Execution exec) {
        CustomFieldHelper helper = this.cufHelperService.newHelper(exec.getSteps()).setRenderingLocations(new RenderingLocation[]{RenderingLocation.STEP_TABLE}).restrictToCommonFields();
        List stepCufs = helper.getCustomFieldConfiguration();
        ArrayList<CustomFieldModel> models = new ArrayList<CustomFieldModel>(stepCufs.size());
        for (CustomField field : stepCufs) {
            models.add(this.converter.toJson(field));
        }
        return models;
    }

    private List<CustomFieldValueModel> getExecutionCustomFieldValueModels(Execution exec) {
        List customFieldValues = this.cufHelperService.newHelper((BoundEntity)exec).getCustomFieldValues();
        ArrayList<CustomFieldValueModel> cufModels = new ArrayList<CustomFieldValueModel>(customFieldValues.size());
        for (CustomFieldValue v : customFieldValues) {
            cufModels.add(this.converter.toJson(v));
        }
        return cufModels;
    }

    private List<CustomFieldValueModel> getExecutionDenormalizedFieldValueModels(Execution exec) {
        List values = this.denormalizedFieldValueFinder.findAllForEntity((DenormalizedFieldHolder)exec);
        ArrayList<CustomFieldValueModel> denoModels = new ArrayList<CustomFieldValueModel>(values.size());
        for (DenormalizedFieldValue deno : values) {
            denoModels.add(this.converter.toJson(deno));
        }
        return denoModels;
    }

    private JsonExecutionInfo toJson(Execution exec) {
        if (exec.isAutomated()) {
            return new JsonExecutionInfo(exec.getLastExecutedOn(), exec.getLastExecutedBy(), exec.getExecutionStatus().getCanonicalStatus(), exec.getExecutionStatus(), exec.getAutomatedExecutionExtender().getResultURL());
        }
        return new JsonExecutionInfo(exec.getLastExecutedOn(), exec.getLastExecutedBy(), exec.getExecutionStatus(), null, null);
    }

    private String internationalize(Level level, Locale locale) {
        return ((LevelLabelFormatter)this.levelFormatterProvider.get()).useLocale(locale).formatLabel(level);
    }

    private JsonExecutionInfo createJsonExecutionStep(ExecutionStep item) {
        return new JsonExecutionInfo(item.getLastExecutedOn(), item.getLastExecutedBy(), item.getExecutionStatus(), null, null);
    }

    private static final class ExecutionStepTableColumnDefHelper
    extends DataTableColumnDefHelper {
        private static final List<AoColumnDef> baseColumns = new ArrayList<AoColumnDef>(5);
        private List<AoColumnDef> columns = new ArrayList<AoColumnDef>();

        static {
            String smallWidth = "2em";
            baseColumns.add(new AoColumnDef(false, false, "", smallWidth, "entity-id"));
            baseColumns.add(new AoColumnDef(true, false, "select-handle centered", smallWidth, "entity-index"));
            baseColumns.add(new AoColumnDef(true, false, "", null, "action"));
            baseColumns.add(new AoColumnDef(true, false, "", null, "expected"));
            baseColumns.add(new AoColumnDef(true, false, "status-combo", null, "status"));
            baseColumns.add(new AoColumnDef(true, false, "exec-on", null, "last-exec-on"));
            baseColumns.add(new AoColumnDef(true, false, "assignee-combo", null, "last-exec-by"));
            baseColumns.add(new AoColumnDef(true, false, "rich-editable-comment", null, "comment"));
            baseColumns.add(new AoColumnDef(false, false, "bug-list", null, "bug-list"));
            baseColumns.add(new AoColumnDef(true, false, "centered bug-button", smallWidth, "bug-button"));
            baseColumns.add(new AoColumnDef(false, false, "", null, "nb-attachments"));
            baseColumns.add(new AoColumnDef(true, false, "centered has-attachment-cell", smallWidth, "attach-list-id"));
            baseColumns.add(new AoColumnDef(true, false, "centered run-step-button", smallWidth, "run-step-button"));
        }

        private ExecutionStepTableColumnDefHelper() {
            this.columns.addAll(baseColumns);
        }

        private List<AoColumnDef> getAoColumnDfvDefs(boolean editable, boolean isBugtrackerConnected, boolean isStandard) {
            this.columns.get(this.columns.size() - 2).setbVisible(editable);
            this.columns.get(3).setbVisible(isStandard);
            this.columns.get(this.columns.size() - 4).setbVisible(editable && isBugtrackerConnected);
            this.addATargets(this.columns);
            return this.columns;
        }
    }

    private static final class StartEndDate {
        private Long newStartDate;
        private Long newEndDate;

        private StartEndDate(Long newStartDate, Long newEndDate) {
            this.newStartDate = newStartDate;
            this.newEndDate = newEndDate;
        }

        public Long getNewStartDate() {
            return this.newStartDate;
        }

        public Long getNewEndDate() {
            return this.newEndDate;
        }
    }
}

