/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.core.foundation.lang.MathsUtils;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteWithSquashAutomAutomatedITPIs;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

public final class AutomatedExecutionViewUtils {
    private AutomatedExecutionViewUtils() {
    }

    public static AutomatedSuiteOverview buildExecInfo(AutomatedSuiteWithSquashAutomAutomatedITPIs suite, Locale locale, InternationalizationHelper messageSource) {
        List executions = suite.getSuite().getExecutionExtenders();
        Collection filteredExecutions = executions.stream().filter(exec -> exec.getAutomatedTest() != null).collect(Collectors.toList());
        List items = suite.getSquashAutomAutomatedItems();
        ArrayList<ExecutionAutoView> executionsViews = new ArrayList<ExecutionAutoView>(filteredExecutions.size());
        ArrayList<ItemAutoView> itemsViews = new ArrayList<ItemAutoView>(items.size());
        int totalExec = filteredExecutions.size();
        int totalTerminated = 0;
        for (AutomatedExecutionExtender autoExec : filteredExecutions) {
            Execution execution = autoExec.getExecution();
            if (execution.getExecutionStatus().isTerminatedStatus()) {
                ++totalTerminated;
            }
            ExecutionAutoView execView = AutomatedExecutionViewUtils.translateExecutionInView(autoExec, locale, messageSource);
            executionsViews.add(execView);
        }
        for (IterationTestPlanItem item : items) {
            ItemAutoView itemView = AutomatedExecutionViewUtils.translateItemInView(item);
            itemsViews.add(itemView);
        }
        int percentage = AutomatedExecutionViewUtils.percentProgression(totalTerminated, totalExec);
        return new AutomatedSuiteOverview(percentage, suite.getSuite().getId(), executionsViews, itemsViews);
    }

    public static AutomatedSuiteOverview buildExecInfo(AutomatedSuite suite, Locale locale, InternationalizationHelper messageSource) {
        List executions = suite.getExecutionExtenders();
        Collection filteredExecutions = executions.stream().filter(exec -> exec.getAutomatedTest() != null).collect(Collectors.toList());
        ArrayList<ExecutionAutoView> executionsViews = new ArrayList<ExecutionAutoView>(filteredExecutions.size());
        int totalExec = filteredExecutions.size();
        int totalTerminated = 0;
        for (AutomatedExecutionExtender autoExec : filteredExecutions) {
            Execution execution = autoExec.getExecution();
            if (execution.getExecutionStatus().isTerminatedStatus()) {
                ++totalTerminated;
            }
            ExecutionAutoView execView = AutomatedExecutionViewUtils.translateExecutionInView(autoExec, locale, messageSource);
            executionsViews.add(execView);
        }
        int percentage = AutomatedExecutionViewUtils.percentProgression(totalTerminated, totalExec);
        return new AutomatedSuiteOverview(percentage, suite.getId(), executionsViews);
    }

    private static int percentProgression(int totalTerminated, int totalExec) {
        if (totalExec == 0) {
            return 100;
        }
        return MathsUtils.percent((long)totalTerminated, (long)totalExec);
    }

    public static ExecutionAutoView translateExecutionInView(AutomatedExecutionExtender autoExec, Locale locale, InternationalizationHelper messageSource) {
        String localisedStatus = messageSource.internationalize((Internationalizable)autoExec.getExecution().getExecutionStatus(), locale);
        String htmlEscapedLocalizedStatus = HtmlUtils.htmlEscape((String)localisedStatus);
        ExecutionAutoView execView = new ExecutionAutoView();
        execView.id = autoExec.getExecution().getId();
        execView.name = autoExec.getExecution().getName();
        execView.status = autoExec.getExecution().getExecutionStatus();
        execView.localizedStatus = htmlEscapedLocalizedStatus;
        execView.automatedProject = autoExec.getAutomatedProject().getLabel();
        execView.node = autoExec.getNodeName();
        return execView;
    }

    public static ItemAutoView translateItemInView(IterationTestPlanItem autoItem) {
        ItemAutoView itemAutoView = new ItemAutoView();
        itemAutoView.id = autoItem.getId();
        itemAutoView.name = autoItem.getReferencedTestCase().getName();
        itemAutoView.automatedServerName = autoItem.getReferencedTestCase().getProject().getTestAutomationServer().getName();
        return itemAutoView;
    }

    public static class AutomatedSuiteOverview {
        private String suiteId;
        private List<ExecutionAutoView> executions;
        private List<ItemAutoView> items;
        private int percentage = 0;

        public AutomatedSuiteOverview(int percentage, String suiteId, List<ExecutionAutoView> executions, List<ItemAutoView> items) {
            this.suiteId = suiteId;
            this.executions = executions;
            this.items = items;
            this.percentage = percentage;
        }

        public AutomatedSuiteOverview(int percentage, String suiteId, List<ExecutionAutoView> executions) {
            this.suiteId = suiteId;
            this.executions = executions;
            this.items = Collections.EMPTY_LIST;
            this.percentage = percentage;
        }

        public String getSuiteId() {
            return this.suiteId;
        }

        public void setSuiteId(String suiteId) {
            this.suiteId = suiteId;
        }

        public List<ExecutionAutoView> getExecutions() {
            return this.executions;
        }

        public void setExecutions(List<ExecutionAutoView> executions) {
            this.executions = executions;
        }

        public int getPercentage() {
            return this.percentage;
        }

        public void setPercentage(int percentage) {
            this.percentage = percentage;
        }

        public List<ItemAutoView> getItems() {
            return this.items;
        }

        public void setItems(List<ItemAutoView> items) {
            this.items = items;
        }
    }

    public static final class ExecutionAutoView {
        private Long id;
        private String name;
        private ExecutionStatus status;
        private String localizedStatus;
        private String node;
        private String automatedProject;

        private ExecutionAutoView() {
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public ExecutionStatus getStatus() {
            return this.status;
        }

        public String getLocalizedStatus() {
            return this.localizedStatus;
        }

        public String getNode() {
            return this.node;
        }

        public String getAutomatedProject() {
            return this.automatedProject;
        }
    }

    public static final class ItemAutoView {
        private Long id;
        private String name;
        private String automatedServerName;

        private ItemAutoView() {
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getAutomatedServerName() {
            return this.automatedServerName;
        }
    }
}

