/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.execution;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.campaign.TestPlanOwner;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.exception.NoBugTrackerBindingException;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.exception.execution.TestPlanTerminatedOrNoStepsException;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.campaign.EntityFinder;
import org.squashtest.tm.service.campaign.TestPlanExecutionProcessingService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;
import org.squashtest.tm.service.internal.bugtracker.BugTrackerConnectorFactory;
import org.squashtest.tm.web.internal.controller.execution.ExecutionProcessingController;
import org.squashtest.tm.web.internal.controller.execution.ExecutionRunnerControllerHelper;
import org.squashtest.tm.web.internal.controller.execution.RunnerState;
import org.squashtest.tm.web.internal.controller.execution.StepState;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.model.json.JsonStepInfo;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

public abstract class AbstractTestPlanExecutionRunnerController<E extends TestPlanOwner> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTestPlanExecutionRunnerController.class);
    private static final String OPTIMIZED_RUNNER_MAIN = "page/executions/oer-main-page";
    private static final String REDIRECT = "redirect:";
    @Inject
    private TestPlanExecutionProcessingService<E> testPlanExecutionRunner;
    @Inject
    private BugTrackerConnectorFactory btFactory;
    @Inject
    private ExecutionProcessingService executionRunner;
    @Inject
    EntityFinder<E> entityFinder;
    @Inject
    ExecutionRunnerControllerHelper helper;
    @Inject
    private ExecutionProcessingController executionProcessingController;
    @Inject
    private ServletContext servletContext;
    @Inject
    private BugTrackersLocalService bugTrackersLocalService;

    abstract String completeRessourceUrlPattern(String var1);

    abstract Project getEntityProject(E var1);

    abstract RunnerState createOptimizedRunnerState(long var1, Execution var3, String var4, Locale var5);

    String getExecutionUrl(long testPlanOwnerId, Execution execution, boolean optimized) {
        return String.valueOf(MessageFormat.format(this.completeRessourceUrlPattern("/{0,number,######}/test-plan/{1,number,######}/executions/{2,number,######}"), testPlanOwnerId, execution.getTestPlan().getId(), execution.getId())) + "?optimized=" + optimized;
    }

    public void testStartResumeExecutionInClassicRunner(long testPlanOwnerId) {
        boolean hasDeletedTestCaseInTestPlan = this.hasDeletedTestCaseInTestPlan(testPlanOwnerId);
        if (!hasDeletedTestCaseInTestPlan) {
            try {
                this.testPlanExecutionRunner.startResume(testPlanOwnerId);
            }
            catch (TestPlanItemNotExecutableException e) {
                throw new TestPlanTerminatedOrNoStepsException((Exception)((Object)e));
            }
        } else {
            throw this.getTestPlanHasDeletedTestCaseException();
        }
    }

    abstract ActionException getTestPlanHasDeletedTestCaseException();

    abstract boolean hasDeletedTestCaseInTestPlan(long var1);

    String startResumeExecutionInClassicRunner(long testPlanOwnerId) {
        LOGGER.trace("startResumeExecutionInClassicRunner({})", (Object)testPlanOwnerId);
        Execution execution = this.testPlanExecutionRunner.startResume(testPlanOwnerId);
        return REDIRECT + this.getExecutionUrl(testPlanOwnerId, execution, false);
    }

    String startResumeExecutionInOptimizedRunner(long testPlanOwnerId, Model model, Locale locale) {
        LOGGER.trace("startResumeExecutionInOptimizedRunner({})", (Object)testPlanOwnerId);
        Execution execution = this.testPlanExecutionRunner.startResume(testPlanOwnerId);
        RunnerState state = this.createOptimizedRunnerState(testPlanOwnerId, execution, this.contextPath(), locale);
        state.setBaseStepUrl(this.stepsAbsoluteUrl(testPlanOwnerId, execution));
        model.addAttribute("config", (Object)state);
        try {
            Project project = this.getEntityProject((TestPlanOwner)this.entityFinder.findById(testPlanOwnerId));
            BugTracker bugtracker = project.findBugTracker();
            BugTrackerInterfaceDescriptor descriptor = this.bugTrackersLocalService.getInterfaceDescriptor(bugtracker);
            String projectNames = JsonHelper.serialize(project.getBugtrackerBinding().getProjectNames().stream().map(HTMLCleanupUtils::cleanAndUnescapeHTML).collect(Collectors.toList()));
            model.addAttribute("interfaceDescriptor", (Object)descriptor);
            model.addAttribute("bugTracker", (Object)bugtracker);
            model.addAttribute("isOslc", (Object)this.btFactory.isOslcConnector(bugtracker.getKind()));
            model.addAttribute("projectId", (Object)project.getId());
            model.addAttribute("projectNames", (Object)projectNames);
        }
        catch (NoBugTrackerBindingException ex) {
            LOGGER.debug("Well, no bugtracker then. It's fine.", (Throwable)ex);
        }
        return OPTIMIZED_RUNNER_MAIN;
    }

    String moveToNextTestCase(long testPlanItemId, long testPlanOwnerId, boolean optimized) {
        LOGGER.trace("moveToNextTestCase({}, {})", (Object)testPlanItemId, (Object)testPlanOwnerId);
        Execution execution = this.testPlanExecutionRunner.startResumeNextExecution(testPlanOwnerId, testPlanItemId);
        return REDIRECT + this.getExecutionUrl(testPlanOwnerId, execution, optimized);
    }

    RunnerState getNextTestCaseRunnerState(long testPlanItemId, long testPlanOwnerId, Locale locale) {
        LOGGER.trace("getNextTestCaseRunnerState({}, {})", (Object)testPlanItemId, (Object)testPlanOwnerId);
        Execution nextExecution = this.testPlanExecutionRunner.startResumeNextExecution(testPlanOwnerId, testPlanItemId);
        RunnerState state = this.createOptimizedRunnerState(testPlanOwnerId, nextExecution, this.contextPath(), locale);
        state.setBaseStepUrl(this.stepsAbsoluteUrl(testPlanOwnerId, nextExecution));
        return state;
    }

    void deleteAllExecutions(long testPlanOwnerId) {
        this.testPlanExecutionRunner.deleteAllExecutions(testPlanOwnerId);
    }

    String runFirstRunnableStep(long testPlanOwnerId, long testPlanItemId, long executionId, boolean optimized) {
        String viewName;
        if (this.executionRunner.wasNeverRun(Long.valueOf(executionId))) {
            viewName = MessageFormat.format(this.completeRessourceUrlPattern("/{0,number,######}/test-plan/{1,number,######}/executions/{2,number,######}/steps/prologue"), testPlanOwnerId, testPlanItemId, executionId);
        } else {
            int stepIndex = this.executionRunner.findRunnableExecutionStep(executionId).getExecutionStepOrder();
            viewName = MessageFormat.format(this.completeRessourceUrlPattern("/{0,number,######}/test-plan/{1,number,######}/executions/{2,number,######}/steps/index/{3,number,######}"), testPlanOwnerId, testPlanItemId, executionId, stepIndex);
        }
        return REDIRECT + viewName + "?optimized=" + optimized;
    }

    String runPrologue(long testPlanOwnerId, long testPlanItemId, long executionId, boolean optimized, Model model) {
        this.addStepsUrl(testPlanOwnerId, testPlanItemId, executionId, model);
        this.helper.populateExecutionPreview(executionId, optimized, this.testPlanRunnerState(testPlanOwnerId, testPlanItemId), model);
        return "execute-execution-preview.html";
    }

    private RunnerState testPlanRunnerState(long testPlanOwnerId, long testPlanItemId) {
        RunnerState state = new RunnerState();
        state.setTestSuiteId(testPlanOwnerId);
        state.setTestPlanItemId(testPlanItemId);
        return state;
    }

    String getClassicTestSuiteExecutionStepFragment(@PathVariable long testPlanOwnerId, @PathVariable long testPlanItemId, @PathVariable long executionId, @PathVariable int stepIndex, Model model) {
        this.populateExecutionStepFragment(testPlanOwnerId, testPlanItemId, executionId, stepIndex, model);
        return "page/executions/execute-execution";
    }

    private void populateExecutionStepFragment(long testPlanOwnerId, long testPlanItemId, long executionId, int stepIndex, Model model) {
        this.helper.populateStepAtIndexModel(executionId, stepIndex, model);
        model.addAttribute("testPlanItemUrl", (Object)MessageFormat.format(this.completeRessourceUrlPattern("/{0,number,######}/test-plan/{1,number,######}"), testPlanOwnerId, testPlanItemId));
        boolean hasNextTestCase = this.testPlanExecutionRunner.hasMoreExecutableItems(testPlanOwnerId, testPlanItemId);
        model.addAttribute("hasNextTestCase", (Object)hasNextTestCase);
        this.addStepsUrl(testPlanOwnerId, testPlanItemId, executionId, model);
    }

    private void addStepsUrl(long testPlanOwnerId, long testPlanItemId, long executionId, Model model) {
        model.addAttribute("currentStepsUrl", (Object)MessageFormat.format(this.completeRessourceUrlPattern("/{0,number,######}/test-plan/{1,number,######}/executions/{2,number,######}/steps"), testPlanOwnerId, testPlanItemId, executionId));
    }

    String getOptimizedTestSuiteExecutionStepFragment(long testPlanOwnerId, long testPlanItemId, long executionId, int stepIndex, Model model) {
        this.populateExecutionStepFragment(testPlanOwnerId, testPlanItemId, executionId, stepIndex, model);
        return "page/executions/oer-execute-execution";
    }

    String changeComment(String newComment, long stepId) {
        return HTMLCleanupUtils.cleanHtml(this.executionProcessingController.updateComment(newComment, stepId));
    }

    void changeExecutionStatus(String executionStatus, long stepId) {
        this.executionProcessingController.updateExecutionStatus(executionStatus, stepId);
    }

    JsonStepInfo getBasicInfos(long executionId, int stepIndex) {
        return this.executionProcessingController.getBasicInfos(executionId, stepIndex);
    }

    StepState getStepState(long executionId, int stepIndex) {
        return this.executionProcessingController.getStepState(executionId, stepIndex);
    }

    private String contextPath() {
        return this.servletContext.getContextPath();
    }

    private String stepsAbsoluteUrl(long testPlanOwnerId, Execution execution) {
        return String.valueOf(this.contextPath()) + MessageFormat.format(this.completeRessourceUrlPattern("/{0,number,######}/test-plan/{1,number,######}/executions/{2,number,######}/steps"), testPlanOwnerId, execution.getTestPlan().getId(), execution.getId());
    }

    static class RequestMappingPattern {
        static final String INIT_EXECUTION_RUNNER = "/execution/runner";
        static final String INIT_NEXT_EXECUTION_RUNNER = "/{testPlanItemId}/next-execution/runner";
        static final String DELETE_ALL_EXECUTIONS = "/executions";
        static final String STEP = "/{testPlanItemId}/executions/{executionId}/steps/{stepId}";
        static final String INDEXED_STEP = "/{testPlanItemId}/executions/{executionId}/steps/index/{stepIndex}";

        RequestMappingPattern() {
        }
    }

    private static class ResourceUrlPattern {
        static final String TEST_PLAN_ITEM = "/{0,number,######}/test-plan/{1,number,######}";
        static final String EXECUTION = "/{0,number,######}/test-plan/{1,number,######}/executions/{2,number,######}";
        static final String STEPS = "/{0,number,######}/test-plan/{1,number,######}/executions/{2,number,######}/steps";
        static final String STEP_INDEX = "/{0,number,######}/test-plan/{1,number,######}/executions/{2,number,######}/steps/index/{3,number,######}";
        static final String PROLOGUE_STEP = "/{0,number,######}/test-plan/{1,number,######}/executions/{2,number,######}/steps/prologue";
        static final String STEP = "/{0,number,######}/test-plan/{1,number,######}/executions/{2,number,######}/steps/{3,number,######}";

        private ResourceUrlPattern() {
        }
    }
}

