/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.customreport;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.customreport.CustomReportWorkspaceService;
import org.squashtest.tm.service.infolist.InfoListModelService;
import org.squashtest.tm.service.internal.customreport.CustomReportWorkspaceDisplayService;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.dto.json.JsonMilestone;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneModelService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.workspace.WorkspaceHelperService;
import org.squashtest.tm.web.internal.helper.I18nLevelEnumInfolistHelper;
import org.squashtest.tm.web.internal.helper.JsTreeHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

@Controller
@RequestMapping(value={"/custom-report-workspace"})
public class CustomReportWorkspaceController {
    public static final Logger LOGGER = LoggerFactory.getLogger(CustomReportWorkspaceController.class);
    private final String cookieDelimiter = "-";
    @Inject
    @Named(value="org.squashtest.tm.service.customreport.CustomReportWorkspaceService")
    private CustomReportWorkspaceService workspaceService;
    @Inject
    private CustomReportLibraryNodeService customReportLibraryNodeService;
    @Inject
    private I18nLevelEnumInfolistHelper i18nLevelEnumInfolistHelper;
    @Inject
    protected InternationalizationHelper i18nHelper;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private WorkspaceHelperService workspaceHelperService;
    @Inject
    private BugTrackerFinderService bugTrackerFinderService;
    @Inject
    private CustomReportWorkspaceDisplayService customReportWorkspaceDisplayService;
    @Inject
    private MilestoneModelService milestoneModelService;
    @Inject
    private InfoListModelService infoListModelService;
    @Inject
    private CustomFieldValueFinderService cufValueService;
    @Inject
    private ConfigurationService configurationService;

    @RequestMapping(method={RequestMethod.GET})
    public String showWorkspace(Model model, Locale locale, @CookieValue(value="jstree_open", required=false, defaultValue="") String[] openedNodes, @CookieValue(value="jstree_select", required=false, defaultValue="") String elementId) {
        HashSet<String> nodeToOpen = new HashSet<String>(Arrays.asList(openedNodes));
        if (StringUtils.isNotBlank((CharSequence)elementId)) {
            nodeToOpen.addAll(this.findAncestorsOfselectedNode(elementId));
        }
        ArrayList rootNodes = new ArrayList();
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List readableProjectIds = this.projectFinder.findAllReadableIds(currentUser);
        rootNodes.addAll(this.customReportWorkspaceDisplayService.findAllLibraries(readableProjectIds, currentUser, this.mapIdsByType(nodeToOpen.toArray(new String[nodeToOpen.size()]))));
        model.addAttribute("rootModel", rootNodes);
        Optional activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId();
        if (activeMilestoneId.isPresent()) {
            JsonMilestone jsMilestone = this.milestoneModelService.findMilestoneModel((Long)activeMilestoneId.get());
            model.addAttribute("activeMilestone", (Object)jsMilestone);
        }
        Collection projects = this.projectFinder.findAllProjects(readableProjectIds, currentUser);
        model.addAttribute("projects", (Object)projects);
        model.addAttribute("defaultInfoLists", (Object)this.infoListModelService.findSystemInfoListItemLabels());
        model.addAttribute("testCaseImportance", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(TestCaseImportance.class, locale));
        model.addAttribute("testCaseStatus", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(TestCaseStatus.class, locale));
        model.addAttribute("requirementStatus", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(RequirementStatus.class, locale));
        model.addAttribute("requirementCriticality", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(RequirementCriticality.class, locale));
        model.addAttribute("executionStatus", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(ExecutionStatus.class, locale));
        model.addAttribute("projectFilter", (Object)this.workspaceHelperService.findFilterModel(currentUser, readableProjectIds));
        model.addAttribute("bugtrackers", (Object)this.bugTrackerFinderService.findDistinctBugTrackersForProjects(readableProjectIds));
        String userLicenseInformation = this.configurationService.findConfiguration("activated.user.excess");
        String dateLicenseInformation = this.configurationService.findConfiguration("plugin.license.expiration");
        model.addAttribute("userLicenseInformation", (Object)userLicenseInformation);
        model.addAttribute("dateLicenseInformation", dateLicenseInformation == null || dateLicenseInformation.isEmpty() ? null : Integer.valueOf(dateLicenseInformation));
        return this.getWorkspaceViewName();
    }

    private Collection<String> findAncestorsOfselectedNode(String elementId) {
        ArrayList<String> ancestors = new ArrayList<String>();
        try {
            Long nodeId = this.convertCookieId(elementId);
            this.customReportLibraryNodeService.findAncestor(nodeId).stream().filter(node -> !node[0].equals(BigInteger.valueOf(nodeId))).forEach(node -> {
                if ("LIBRARY".equals(node[1])) {
                    ancestors.add("#CustomReportLibrary-" + node[0]);
                } else {
                    ancestors.add("#CustomReportFolder-" + node[0]);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.error("Error on parsing js_open cookie. Workspace will be shown with closed tree");
        }
        return ancestors;
    }

    protected String getWorkspaceViewName() {
        return "custom-report-workspace.html";
    }

    protected WorkspaceType getWorkspaceType() {
        return WorkspaceType.CUSTOM_REPORT_WORKSPACE;
    }

    private Long convertCookieId(String cookieValue) {
        String[] cookieSplits = cookieValue.split("-");
        if (cookieSplits.length > 0) {
            return Long.parseLong(cookieSplits[cookieSplits.length - 1]);
        }
        return Long.parseLong(cookieValue);
    }

    protected MultiMap mapIdsByType(String[] openedNodes) {
        return JsTreeHelper.mapIdsByType(openedNodes);
    }
}

