/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.customreport;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.customreport.CustomReportChartBinding;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportReportBinding;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.web.internal.model.builder.JsonCustomReportReportBindingBuilder;
import org.squashtest.tm.web.internal.model.json.FormCustomReportReportBinding;
import org.squashtest.tm.web.internal.model.json.JsonCustomReportGridElement;
import org.squashtest.tm.web.internal.model.json.JsonCustomReportReportBinding;

@Controller
public class CustomReportReportBindingController {
    private static final String CHART = "chart";
    private static final String REPORT = "report";
    @Inject
    private CustomReportLibraryNodeService crlnservice;
    @Inject
    private CustomReportDashboardService dashboardService;
    @Inject
    @Named(value="customReport.reportBindingBuilder")
    private Provider<JsonCustomReportReportBindingBuilder> builderProvider;

    @ResponseBody
    @RequestMapping(value={"/custom-report-report-binding"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public JsonCustomReportReportBinding createCustomReportReportBinding(@RequestBody FormCustomReportReportBinding formReportBinding) {
        CustomReportReportBinding crrb = formReportBinding.convertToEntity();
        ReportDefinition reportDefinition = this.crlnservice.findReportDefinitionByNodeId(formReportBinding.getReportNodeId());
        CustomReportDashboard dashboard = this.crlnservice.findCustomReportDashboardById(formReportBinding.getDashboardNodeId());
        crrb.setReport(reportDefinition);
        crrb.setDashboard(dashboard);
        this.dashboardService.bindReport(crrb);
        return ((JsonCustomReportReportBindingBuilder)this.builderProvider.get()).build(crrb);
    }

    @ResponseBody
    @RequestMapping(value={"/custom-report-report-binding-replace-report/{bindingId}/{reportNodeId}"}, method={RequestMethod.POST})
    public JsonCustomReportReportBinding changeBindedReport(@PathVariable long bindingId, @PathVariable long reportNodeId) {
        CustomReportReportBinding crrb = this.dashboardService.changeBindedReport(bindingId, reportNodeId);
        return ((JsonCustomReportReportBindingBuilder)this.builderProvider.get()).build(crrb);
    }

    @ResponseBody
    @RequestMapping(value={"/custom-report-report-binding"}, method={RequestMethod.PUT})
    public void updateGrid(@RequestBody JsonCustomReportGridElement[] gridElements) {
        ArrayList<CustomReportReportBinding> reportBindings = new ArrayList<CustomReportReportBinding>();
        JsonCustomReportGridElement[] jsonCustomReportGridElementArray = gridElements;
        int n = gridElements.length;
        int n2 = 0;
        while (n2 < n) {
            JsonCustomReportGridElement gridElement = jsonCustomReportGridElementArray[n2];
            if (gridElement.getElementType().equals(REPORT)) {
                reportBindings.add(gridElement.convertToReportEntity());
            }
            ++n2;
        }
        ArrayList<CustomReportChartBinding> chartBindings = new ArrayList<CustomReportChartBinding>();
        JsonCustomReportGridElement[] jsonCustomReportGridElementArray2 = gridElements;
        int n3 = gridElements.length;
        n = 0;
        while (n < n3) {
            JsonCustomReportGridElement gridElement = jsonCustomReportGridElementArray2[n];
            if (gridElement.getElementType().equals(CHART)) {
                chartBindings.add(gridElement.convertToChartEntity());
            }
            ++n;
        }
        this.dashboardService.updateGridPosition(chartBindings, reportBindings);
    }

    @ResponseBody
    @RequestMapping(value={"/custom-report-report-binding/{id}"}, method={RequestMethod.DELETE})
    public void unbindChart(@PathVariable long id) {
        this.dashboardService.unbindReport(Long.valueOf(id));
    }
}

