/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.customreport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportFolder;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.customreport.CustomReportWorkspaceService;
import org.squashtest.tm.service.deletion.Node;
import org.squashtest.tm.service.deletion.NodeMovement;
import org.squashtest.tm.service.deletion.NodeReferenceChanged;
import org.squashtest.tm.service.deletion.NodeRenaming;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.customreport.CustomReportWorkspaceDisplayService;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.web.internal.model.builder.CustomReportListTreeNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.CustomReportTreeNodeBuilder;

@Controller
@RequestMapping(value={"/custom-report-browser"})
public class CustomReportNavigationController {
    public static final Logger LOGGER = LoggerFactory.getLogger(CustomReportNavigationController.class);
    private static final String NODE_IDS = "nodeIds[]";
    private static final String DESTINATION_ID = "destinationId";
    @Inject
    private CustomReportWorkspaceService workspaceService;
    @Inject
    private CustomReportLibraryNodeService customReportLibraryNodeService;
    @Inject
    private CustomReportWorkspaceDisplayService customReportWorkspaceDisplayService;
    @Inject
    private CustomReportListTreeNodeBuilder listBuilder;
    @Inject
    @Named(value="customReport.nodeBuilder")
    private Provider<CustomReportTreeNodeBuilder> builderProvider;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private CustomFieldBindingFinderService customFieldBindingFinderService;
    @Inject
    private PrivateCustomFieldValueService customValueService;

    @ResponseBody
    @RequestMapping(value={"/drives/{libraryId}/content/new-folder"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public JsTreeNode createNewFolderInLibrary(@PathVariable Long libraryId, @Valid @RequestBody CustomReportFolder customReportFolder) {
        JsTreeNode node = this.createNewCustomReportLibraryNode(libraryId, (CustomReportTreeEntity)customReportFolder);
        this.generateCuf(customReportFolder);
        return node;
    }

    @ResponseBody
    @RequestMapping(value={"/folders/{folderId}/content/new-folder"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public JsTreeNode createNewFolderInFolder(@PathVariable Long folderId, @Valid @RequestBody CustomReportFolder customReportFolder) {
        JsTreeNode node = this.createNewCustomReportLibraryNode(folderId, (CustomReportTreeEntity)customReportFolder);
        this.generateCuf(customReportFolder);
        return node;
    }

    private void generateCuf(CustomReportFolder newFolder) {
        List projectsBindings = this.customFieldBindingFinderService.findCustomFieldsForProjectAndEntity(newFolder.getProject().getId().longValue(), BindableEntity.CUSTOM_REPORT_FOLDER);
        for (CustomFieldBinding binding : projectsBindings) {
            this.customValueService.cascadeCustomFieldValuesCreationNotCreatedFolderYet(binding, (BoundEntity)newFolder);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/drives/{libraryId}/content/new-dashboard"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public JsTreeNode createNewDashboardInLibrary(@PathVariable Long libraryId, @Valid @RequestBody CustomReportDashboard customReportDashboard) {
        return this.createNewCustomReportLibraryNode(libraryId, (CustomReportTreeEntity)customReportDashboard);
    }

    @ResponseBody
    @RequestMapping(value={"/folders/{folderId}/content/new-dashboard"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public JsTreeNode createNewDashboardInFolder(@PathVariable Long folderId, @Valid @RequestBody CustomReportDashboard customReportDashboard) {
        return this.createNewCustomReportLibraryNode(folderId, (CustomReportTreeEntity)customReportDashboard);
    }

    @ResponseBody
    @RequestMapping(value={"/drives/{nodeId}/content"}, method={RequestMethod.GET})
    public List<JsTreeNode> getRootContentTreeModel(@PathVariable long nodeId) {
        return this.getNodeContent(nodeId);
    }

    @ResponseBody
    @RequestMapping(value={"/folders/{nodeId}/content"}, method={RequestMethod.GET})
    public List<JsTreeNode> getFolderContentTreeModel(@PathVariable long nodeId) {
        return this.getNodeContent(nodeId);
    }

    @ResponseBody
    @RequestMapping(value={"/dashboard/{nodeId}/content"}, method={RequestMethod.GET})
    public List<JsTreeNode> getDashboardContentTreeModel(@PathVariable long nodeId) {
        return this.getNodeContent(nodeId);
    }

    @ResponseBody
    @RequestMapping(value={"/folders/{destinationId}/content/new"}, method={RequestMethod.POST}, params={"nodeIds[]"})
    public List<JsTreeNode> copyNodesTofolder(@RequestParam(value="nodeIds[]") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId) {
        return this.copyNodes(nodeIds, destinationId);
    }

    @ResponseBody
    @RequestMapping(value={"/drives/{destinationId}/content/new"}, method={RequestMethod.POST}, params={"nodeIds[]"})
    public List<JsTreeNode> copyNodesToDrives(@RequestParam(value="nodeIds[]") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId) {
        return this.copyNodes(nodeIds, destinationId);
    }

    @ResponseBody
    @RequestMapping(value={"/folders/{destinationId}/content/{nodeIds}/{position}"}, method={RequestMethod.PUT})
    public void moveNodesToFolderWithPosition(@PathVariable(value="nodeIds") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId) {
        this.moveNodes(nodeIds, destinationId);
    }

    @ResponseBody
    @RequestMapping(value={"/drives/{destinationId}/content/{nodeIds}/{position}"}, method={RequestMethod.PUT})
    public void moveNodesToDriveWithPosition(@PathVariable(value="nodeIds") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId) {
        this.moveNodes(nodeIds, destinationId);
    }

    @ResponseBody
    @RequestMapping(value={"/folders/{destinationId}/content/{nodeIds}"}, method={RequestMethod.PUT})
    public void moveNodesToFolder(@PathVariable(value="nodeIds") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId) {
        this.moveNodes(nodeIds, destinationId);
    }

    @ResponseBody
    @RequestMapping(value={"/drives/{destinationId}/content/{nodeIds}"}, method={RequestMethod.PUT})
    public void moveNodesToDrive(@PathVariable(value="nodeIds") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId) {
        this.moveNodes(nodeIds, destinationId);
    }

    @ResponseBody
    @RequestMapping(value={"/content/{nodeIds}/deletion-simulation"}, method={RequestMethod.GET})
    public Messages simulateNodeDeletion() {
        return new Messages();
    }

    @ResponseBody
    @RequestMapping(value={"/content/{nodeIds}"}, method={RequestMethod.DELETE})
    public OperationReport confirmNodeDeletion(@PathVariable(value="nodeIds") List<Long> nodeIds) {
        OperationReport report = this.customReportLibraryNodeService.delete(nodeIds);
        this.logOperations(report);
        return report;
    }

    private JsTreeNode createNewCustomReportLibraryNode(Long libraryId, CustomReportTreeEntity entity) {
        CustomReportLibraryNode newNode = this.customReportLibraryNodeService.createNewNode(libraryId, entity);
        JsTreeNode node = ((CustomReportTreeNodeBuilder)this.builderProvider.get()).build(newNode);
        return node;
    }

    private void moveNodes(@PathVariable(value="nodeIds") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId) {
        this.customReportLibraryNodeService.moveNodes(Arrays.asList(nodeIds), Long.valueOf(destinationId));
    }

    private List<JsTreeNode> copyNodes(@RequestParam(value="nodeIds[]") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId) {
        List nodeList = this.customReportLibraryNodeService.copyNodes(Arrays.asList(nodeIds), Long.valueOf(destinationId));
        return this.listBuilder.build(nodeList);
    }

    private List<JsTreeNode> getNodeContent(Long nodeId) {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return new ArrayList<JsTreeNode>(this.customReportWorkspaceDisplayService.getNodeContent(nodeId, currentUser));
    }

    private void logOperations(OperationReport report) {
        for (Node deletedNode : report.getRemoved()) {
            LOGGER.info("The node #{} was removed", (Object)deletedNode.getResid());
        }
        for (NodeMovement movedNode : report.getMoved()) {
            LOGGER.info("The nodes #{} were moved to node #{}", movedNode.getMoved().stream().map(Node::getResid).collect(Collectors.toList()), (Object)movedNode.getDest().getResid());
        }
        for (NodeRenaming renamedNode : report.getRenamed()) {
            LOGGER.info("The node #{} was renamed to {}", (Object)renamedNode.getNode().getResid(), (Object)renamedNode.getName());
        }
        for (NodeReferenceChanged nodeReferenceChanged : report.getReferenceChanges()) {
            LOGGER.info("The node #{} reference was changed to {}", (Object)nodeReferenceChanged.getNode().getResid(), (Object)nodeReferenceChanged.getReference());
        }
    }

    protected static class Messages {
        private Collection<String> messageCollection = new ArrayList<String>();

        public void addMessage(String msg) {
            this.messageCollection.add(msg);
        }

        public Collection<String> getMessageCollection() {
            return this.messageCollection;
        }
    }
}

