/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.customreport;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.chart.ChartInstance;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportFolder;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.chart.ChartModificationService;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.web.internal.controller.chart.JsonChartInstance;
import org.squashtest.tm.web.internal.model.builder.JsonCustomExportBuilder;
import org.squashtest.tm.web.internal.model.builder.JsonCustomReportDashboardBuilder;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.model.json.JsonCustomReportCustomExport;
import org.squashtest.tm.web.internal.model.json.JsonCustomReportDashboard;
import org.squashtest.tm.web.internal.model.json.JsonDynamicScope;

@Controller
public class CustomReportController {
    public static final Logger LOGGER = LoggerFactory.getLogger(CustomReportController.class);
    private static final String NEW_NAME = "newName";
    @Inject
    private CustomReportLibraryNodeService customReportLibraryNodeService;
    @Inject
    private ChartModificationService chartService;
    @Inject
    private CustomReportDashboardService dashboardService;
    @Inject
    @Named(value="customReport.dashboardBuilder")
    private Provider<JsonCustomReportDashboardBuilder> builderProvider;
    @Inject
    @Named(value="customReport.customExportBuilder")
    private Provider<JsonCustomExportBuilder> customExportBuilderProvider;

    @ResponseBody
    @RequestMapping(value={"custom-report-library/{id}"}, method={RequestMethod.GET})
    public CustomReportLibrary getLibraryDetails(@PathVariable Long id) {
        return this.customReportLibraryNodeService.findLibraryByTreeNodeId(id);
    }

    @ResponseBody
    @RequestMapping(value={"custom-report-folder/{id}"}, method={RequestMethod.GET})
    public CustomReportFolder getFolderDetails(@PathVariable Long id) {
        return this.customReportLibraryNodeService.findFolderByTreeNodeId(id);
    }

    @ResponseBody
    @RequestMapping(value={"custom-report-chart/{id}"}, method={RequestMethod.GET})
    public JsonChartInstance getChartDetails(@PathVariable Long id) {
        ChartDefinition chartDef = this.customReportLibraryNodeService.findChartDefinitionByNodeId(id);
        ChartInstance instance = this.chartService.generateChart(chartDef.getId().longValue(), null, null);
        return new JsonChartInstance(instance);
    }

    @ResponseBody
    @RequestMapping(value={"custom-report-report/{id}"}, method={RequestMethod.GET})
    public ReportDefinition getReportDetails(@PathVariable Long id) {
        ReportDefinition ReportDef = this.customReportLibraryNodeService.findReportDefinitionByNodeId(id);
        return ReportDef;
    }

    @ResponseBody
    @RequestMapping(value={"custom-report-dashboard/{id}"}, method={RequestMethod.GET})
    public JsonCustomReportDashboard getDashboardDetails(@PathVariable Long id, Locale locale) {
        CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(id);
        return ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dashboard, locale);
    }

    @ResponseBody
    @RequestMapping(value={"custom-report-custom-export/{id}"}, method={RequestMethod.GET})
    public JsonCustomReportCustomExport getCustomExportDetails(@PathVariable Long id, Locale locale) {
        CustomReportCustomExport customExport = this.customReportLibraryNodeService.findCustomExportByNodeId(id);
        return ((JsonCustomExportBuilder)this.customExportBuilderProvider.get()).build(customExport, locale);
    }

    @ResponseBody
    @RequestMapping(value={"custom-report-dashboard/{id}"}, method={RequestMethod.POST})
    public JsonCustomReportDashboard getDashboardDetailsWithDynamicScope(@PathVariable Long id, Locale locale, @RequestBody JsonDynamicScope dynamicScope) {
        List<EntityReference> entityReferences = dynamicScope.convertToEntityReferences();
        CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(id);
        Workspace workspace = Workspace.getWorkspaceFromShortName((String)dynamicScope.getWorkspaceName());
        return ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dashboard, locale, entityReferences, dynamicScope.isMilestoneDashboard(), workspace);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"custom-report-folders/{nodeId}"}, params={"newName"})
    @ResponseBody
    public RenameModel renameCRF(@PathVariable long nodeId, @RequestParam String newName) {
        return this.renameNode(nodeId, newName);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"custom-report-dashboard/{nodeId}"}, params={"newName"})
    @ResponseBody
    public RenameModel renameCRD(@PathVariable long nodeId, @RequestParam String newName) {
        return this.renameNode(nodeId, newName);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"custom-report-chart/{nodeId}"}, params={"newName"})
    @ResponseBody
    public RenameModel renameChartDefinition(@PathVariable long nodeId, @RequestParam String newName) {
        return this.renameNode(nodeId, newName);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"custom-report-report/{nodeId}"}, params={"newName"})
    @ResponseBody
    public RenameModel renameReportDefinition(@PathVariable long nodeId, @RequestParam String newName) {
        return this.renameNode(nodeId, newName);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"custom-report-custom-export/{nodeId}"}, params={"newName"})
    @ResponseBody
    public RenameModel renameCustomExport(@PathVariable long nodeId, @RequestParam String newName) {
        return this.renameNode(nodeId, newName);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"custom-report-dashboard/favorite/{workspace}/{nodeId}"})
    @ResponseBody
    public void changeFavoriteDashboard(@PathVariable long nodeId, @PathVariable String workspace) {
        Workspace workspaceId = Workspace.getWorkspaceFromShortName((String)workspace);
        this.dashboardService.chooseFavoriteDashboardForCurrentUser(workspaceId, nodeId);
    }

    private RenameModel renameNode(long nodeId, String newName) {
        this.customReportLibraryNodeService.renameNode(Long.valueOf(nodeId), newName);
        return new RenameModel(newName);
    }
}

