/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.customreport;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.customreport.CustomReportChartBinding;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportReportBinding;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.web.internal.model.builder.JsonCustomReportChartBindingBuilder;
import org.squashtest.tm.web.internal.model.json.FormCustomReportChartBinding;
import org.squashtest.tm.web.internal.model.json.JsonCustomReportChartBinding;
import org.squashtest.tm.web.internal.model.json.JsonCustomReportGridElement;

@Controller
public class CustomReportChartBindingController {
    private static final String CHART = "chart";
    private static final String REPORT = "report";
    @Inject
    private CustomReportLibraryNodeService crlnservice;
    @Inject
    private CustomReportDashboardService dashboardService;
    @Inject
    @Named(value="customReport.chartBindingBuilder")
    private Provider<JsonCustomReportChartBindingBuilder> builderProvider;

    @ResponseBody
    @RequestMapping(value={"/custom-report-chart-binding"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public JsonCustomReportChartBinding createCustomReportChartBinding(@RequestBody FormCustomReportChartBinding formChartBinding) {
        CustomReportChartBinding crcb = formChartBinding.convertToEntity();
        ChartDefinition chartDefinition = this.crlnservice.findChartDefinitionByNodeId(formChartBinding.getChartNodeId());
        CustomReportDashboard dashboard = this.crlnservice.findCustomReportDashboardById(formChartBinding.getDashboardNodeId());
        crcb.setChart(chartDefinition);
        crcb.setDashboard(dashboard);
        this.dashboardService.bindChart(crcb);
        return ((JsonCustomReportChartBindingBuilder)this.builderProvider.get()).build(crcb);
    }

    @ResponseBody
    @RequestMapping(value={"/custom-report-chart-binding-replace-chart/{bindingId}/{chartNodeId}"}, method={RequestMethod.POST})
    public JsonCustomReportChartBinding changeBindedChart(@PathVariable long bindingId, @PathVariable long chartNodeId) {
        CustomReportChartBinding crcb = this.dashboardService.changeBindedChart(bindingId, chartNodeId);
        return ((JsonCustomReportChartBindingBuilder)this.builderProvider.get()).build(crcb);
    }

    @ResponseBody
    @RequestMapping(value={"/custom-report-chart-binding"}, method={RequestMethod.PUT})
    public void updateGrid(@RequestBody JsonCustomReportGridElement[] gridElements) {
        ArrayList<CustomReportReportBinding> reportBindings = new ArrayList<CustomReportReportBinding>();
        JsonCustomReportGridElement[] jsonCustomReportGridElementArray = gridElements;
        int n = gridElements.length;
        int n2 = 0;
        while (n2 < n) {
            JsonCustomReportGridElement gridElement = jsonCustomReportGridElementArray[n2];
            if (gridElement.getElementType().equals(REPORT)) {
                reportBindings.add(gridElement.convertToReportEntity());
            }
            ++n2;
        }
        ArrayList<CustomReportChartBinding> chartBindings = new ArrayList<CustomReportChartBinding>();
        JsonCustomReportGridElement[] jsonCustomReportGridElementArray2 = gridElements;
        int n3 = gridElements.length;
        n = 0;
        while (n < n3) {
            JsonCustomReportGridElement gridElement = jsonCustomReportGridElementArray2[n];
            if (gridElement.getElementType().equals(CHART)) {
                chartBindings.add(gridElement.convertToChartEntity());
            }
            ++n;
        }
        this.dashboardService.updateGridPosition(chartBindings, reportBindings);
    }

    @ResponseBody
    @RequestMapping(value={"/custom-report-chart-binding/{id}"}, method={RequestMethod.DELETE})
    public void unbindChart(@PathVariable long id) {
        this.dashboardService.unbindChart(Long.valueOf(id));
    }
}

