/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.customfield;

import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.MultiSelectField;
import org.squashtest.tm.domain.customfield.NumericField;
import org.squashtest.tm.domain.customfield.RichTextField;
import org.squashtest.tm.domain.customfield.SingleSelectField;

public class NewCustomField
extends CustomField {
    private InputType inputType;
    private String[][] options;

    public NewCustomField() {
        super(InputType.PLAIN_TEXT);
    }

    public CustomField createTransientEntity() {
        CustomField res;
        switch (this.inputType) {
            case DROPDOWN_LIST: {
                res = this.createSingleSelectField();
                break;
            }
            case RICH_TEXT: {
                res = this.createRichTextField();
                break;
            }
            case TAG: {
                res = this.createTag();
                break;
            }
            case NUMERIC: {
                res = this.createNumeric();
                break;
            }
            default: {
                res = new CustomField(this.inputType);
            }
        }
        res.setCode(this.getCode());
        res.setLabel(this.getLabel());
        res.setName(this.getName());
        res.setOptional(this.isOptional());
        res.setDefaultValue(this.getDefaultValue());
        return res;
    }

    private CustomField createNumeric() {
        return new NumericField();
    }

    private CustomField createSingleSelectField() {
        SingleSelectField ssf = new SingleSelectField();
        String[][] stringArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            String[] option = stringArray[n2];
            String label = option[0];
            String code = option[1];
            String colour = option[2];
            ssf.addOption(new CustomFieldOption(label, code, colour));
            ++n2;
        }
        SingleSelectField res = ssf;
        return res;
    }

    private CustomField createRichTextField() {
        return new RichTextField();
    }

    private CustomField createTag() {
        return new MultiSelectField();
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public void setInputType(InputType inputType) {
        this.inputType = inputType;
    }

    public String[][] getOptions() {
        return this.options;
    }

    public void setOptions(String[][] options) {
        this.options = (String[][])options.clone();
    }
}

