/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.customfield;

import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.service.denormalizedfield.DenormalizedFieldValueManager;
import org.squashtest.tm.service.internal.dto.CustomFieldJsonConverter;
import org.squashtest.tm.service.internal.dto.CustomFieldValueModel;
import org.squashtest.tm.service.internal.dto.RawValueModel;

@Controller
@RequestMapping(value={"/denormalized-fields/values"})
public class DenormalizedFieldValuesController {
    private static final String DENORMALIZED_FIELD_HOLDER_TYPE = "denormalizedFieldHolderType";
    private static final String DENORMALIZED_FIELD_HOLDER_ID = "denormalizedFieldHolderId";
    @Inject
    private DenormalizedFieldValueManager denormalizedFieldValueFinder;
    @Inject
    private CustomFieldJsonConverter converter;

    @RequestMapping(method={RequestMethod.GET}, params={"denormalizedFieldHolderId", "denormalizedFieldHolderType"}, headers={"Accept=application/json, text/javascript"})
    @ResponseBody
    public List<CustomFieldValueModel> getDenormalizedFieldValuesForEntity(@RequestParam(value="denormalizedFieldHolderId") long id, @RequestParam(value="denormalizedFieldHolderType") DenormalizedFieldHolderType entityType) {
        List values = this.denormalizedFieldValueFinder.findAllForEntity(Long.valueOf(id), entityType);
        return this.valuesToJson(values);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public void updateDenormalizedValue(@PathVariable long id, @RequestBody RawValueModel value) {
        this.denormalizedFieldValueFinder.changeValue(id, value.toRawValue());
    }

    private List<CustomFieldValueModel> valuesToJson(List<DenormalizedFieldValue> values) {
        LinkedList<CustomFieldValueModel> models = new LinkedList<CustomFieldValueModel>();
        for (DenormalizedFieldValue value : values) {
            CustomFieldValueModel model = this.converter.toJson(value);
            models.add(model);
        }
        return models;
    }
}

