/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.customfield;

import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.service.customfield.CustomFieldValueManagerService;
import org.squashtest.tm.service.internal.dto.CustomFieldJsonConverter;
import org.squashtest.tm.service.internal.dto.CustomFieldValueModel;
import org.squashtest.tm.service.internal.dto.RawValueModel;

@Controller
@RequestMapping(value={"/custom-fields/values"})
public class CustomFieldValuesController {
    private static final String BOUND_ENTITY_TYPE = "boundEntityType";
    private static final String BOUND_ENTITY_ID = "boundEntityId";
    @Inject
    private CustomFieldValueManagerService managerService;
    @Inject
    private CustomFieldJsonConverter converter;

    @RequestMapping(method={RequestMethod.GET}, params={"boundEntityId", "boundEntityType"}, headers={"Accept=application/json, text/javascript"})
    @ResponseBody
    public List<CustomFieldValueModel> getCustomFieldValuesForEntity(@RequestParam(value="boundEntityId") long id, @RequestParam(value="boundEntityType") BindableEntity entityType) {
        List values = this.managerService.findAllCustomFieldValues(id, entityType);
        return this.valuesToJson(values);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public void updateCustomValue(@PathVariable long id, @RequestBody RawValueModel value) {
        this.managerService.changeValue(id, value.toRawValue());
    }

    private List<CustomFieldValueModel> valuesToJson(List<CustomFieldValue> values) {
        LinkedList<CustomFieldValueModel> models = new LinkedList<CustomFieldValueModel>();
        for (CustomFieldValue value : values) {
            models.add(this.converter.toJson(value));
        }
        return models;
    }
}

