/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.customfield;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.Pagings;
import org.squashtest.tm.core.foundation.collection.SinglePageCollectionHolder;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.service.customfield.CustomFieldManagerService;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.web.internal.controller.customfield.NewCustomField;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/custom-fields"})
public class CustomFieldController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldController.class);
    private static final String CUSTOM_FIELD = "customField";
    private static final String NUMERIC_CUSTOM_FIELD_VALUE = "numericCustomFieldValue";
    private static final String CUSTOM_FIELD_ID_MAPPING = "/{customFieldId}";
    @Inject
    private CustomFieldManagerService customFieldManager;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private MessageSource messageSource;

    @ModelAttribute(value="customFieldOptionsPageSize")
    public long populateCustomFieldsPageSize() {
        return Pagings.DEFAULT_PAGING.getPageSize();
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public void createNew(@RequestBody NewCustomField field) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Will create custom field {}", (Object)ToStringBuilder.reflectionToString((Object)((Object)field)));
        }
        this.customFieldManager.persist(field.createTransientEntity());
    }

    @RequestMapping(value={"/{customFieldId}"}, method={RequestMethod.GET})
    public String showCustomFieldModificationPage(@PathVariable Long customFieldId, Model model) {
        CustomField customField = this.customFieldManager.findById(customFieldId);
        switch (customField.getInputType()) {
            case DROPDOWN_LIST: {
                SingleSelectField cuf = this.customFieldManager.findSingleSelectFieldById(customFieldId);
                List options = cuf.getOptions();
                for (CustomFieldOption option : options) {
                    option.setLabel(HtmlUtils.htmlUnescape((String)option.getLabel()));
                }
                model.addAttribute(CUSTOM_FIELD, (Object)cuf);
                break;
            }
            case NUMERIC: {
                model.addAttribute(CUSTOM_FIELD, (Object)customField);
                model.addAttribute(NUMERIC_CUSTOM_FIELD_VALUE, (Object)NumericCufHelper.formatOutputNumericCufValue((String)customField.getDefaultValue()));
                break;
            }
            default: {
                model.addAttribute(CUSTOM_FIELD, (Object)customField);
            }
        }
        return "custom-field-modification.html";
    }

    @RequestMapping(value={"/name/{name}"}, params={"id"})
    @ResponseBody
    public Object getIdByName(@PathVariable String name) {
        CustomField field = this.customFieldManager.findByName(name);
        if (field != null) {
            HashMap<String, Long> res = new HashMap<String, Long>(1);
            res.put("id", field.getId());
            return res;
        }
        return null;
    }

    @RequestMapping(value={"/{customFieldId}"}, method={RequestMethod.POST}, params={"id=cuf-label", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String changeLabel(@PathVariable long customFieldId, @RequestParam(value="value") String label) {
        this.customFieldManager.changeLabel(customFieldId, label);
        return HtmlUtils.htmlEscape((String)label);
    }

    @RequestMapping(value={"/{customFieldId}"}, method={RequestMethod.POST}, params={"id=cuf-code", "value"})
    @ResponseBody
    public String changeCode(@PathVariable long customFieldId, @RequestParam(value="value") String code) {
        this.customFieldManager.changeCode(customFieldId, code);
        return HtmlUtils.htmlEscape((String)code);
    }

    @RequestMapping(value={"/{customFieldId}/name"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public Object changeName(@PathVariable long customFieldId, @RequestParam(value="value") String name) {
        this.customFieldManager.changeName(customFieldId, name);
        return new RenameModel(name);
    }

    @RequestMapping(value={"/{customFieldId}/optional"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public boolean changeOptional(@PathVariable long customFieldId, @RequestParam(value="value") Boolean optional) {
        this.customFieldManager.changeOptional(Long.valueOf(customFieldId), optional);
        return optional;
    }

    @RequestMapping(value={"/{customFieldId}"}, method={RequestMethod.POST}, params={"id=cuf-default-value", "value"})
    @ResponseBody
    public String changeDefaultValueJedit(@PathVariable long customFieldId, @RequestParam(value="value") String defaultValue, Locale locale) {
        this.customFieldManager.changeDefaultValue(customFieldId, defaultValue);
        CustomField customField = this.customFieldManager.findById(Long.valueOf(customFieldId));
        String toReturn = defaultValue;
        if (customField.getInputType() == InputType.CHECKBOX) {
            toReturn = this.messageSource.getMessage("label." + defaultValue, null, locale);
        }
        return toReturn;
    }

    @RequestMapping(value={"/{customFieldId}/defaultValue"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String changeDefaultValue(@PathVariable long customFieldId, @RequestParam(value="value") String defaultValue) {
        this.customFieldManager.changeDefaultValue(customFieldId, defaultValue);
        return defaultValue;
    }

    @RequestMapping(value={"/{customFieldId}/options/label"}, method={RequestMethod.POST}, params={"value", "optionLabel"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void changeOptionLabel(@PathVariable long customFieldId, @RequestParam(value="value") String newLabel, @RequestParam(value="optionLabel") String optionLabel) {
        try {
            this.customFieldManager.changeOptionLabel(Long.valueOf(customFieldId), optionLabel, newLabel);
        }
        catch (DomainException e) {
            e.setObjectName("rename-cuf-option");
            throw e;
        }
    }

    @RequestMapping(value={"/{customFieldId}/options/colour"}, method={RequestMethod.POST}, params={"value", "optionLabel"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void changeOptionColour(@PathVariable long customFieldId, @RequestParam(value="value") String newLabel, @RequestParam(value="optionLabel") String optionLabel) {
        try {
            this.customFieldManager.changeOptionColour(customFieldId, optionLabel, newLabel);
        }
        catch (DomainException e) {
            e.setObjectName("change-cuf-option-colour");
            throw e;
        }
    }

    @RequestMapping(value={"/{customFieldId}/options/code"}, method={RequestMethod.POST}, params={"value", "optionLabel"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void changeOptionCode(@PathVariable long customFieldId, @RequestParam(value="value") String newCode, @RequestParam(value="optionLabel") String optionLabel) {
        try {
            this.customFieldManager.changeOptionCode(customFieldId, optionLabel, newCode);
        }
        catch (DomainException e) {
            e.setObjectName("change-cuf-option");
            throw e;
        }
    }

    @RequestMapping(value={"/{customFieldId}/options/new"}, method={RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addOption(@PathVariable long customFieldId, @Valid @ModelAttribute(value="new-cuf-option") CustomFieldOption option) {
        try {
            this.customFieldManager.addOption(Long.valueOf(customFieldId), option);
        }
        catch (DomainException e) {
            e.setObjectName("new-cuf-option");
            throw e;
        }
    }

    @RequestMapping(value={"/{customFieldId}/options/**"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeOption(@PathVariable long customFieldId, HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        String bestMatchPattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        AntPathMatcher apm = new AntPathMatcher();
        String optionLabel = apm.extractPathWithinPattern(bestMatchPattern, path);
        this.customFieldManager.removeOption(customFieldId, HtmlUtils.htmlUnescape((String)optionLabel));
    }

    @RequestMapping(value={"/{customFieldId}/options"}, method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getCustomFieldsTableModel(@PathVariable long customFieldId, DataTableDrawParameters params) {
        SingleSelectField customField = this.customFieldManager.findSingleSelectFieldById(Long.valueOf(customFieldId));
        List customFieldOptions = customField.getOptions();
        SinglePageCollectionHolder holder = new SinglePageCollectionHolder((Collection)customFieldOptions);
        return new CustomFieldOptionsDataTableModelHelper((CustomField)customField).buildDataModel(holder, params.getsEcho());
    }

    @RequestMapping(value={"/{customFieldId}/options/positions"}, method={RequestMethod.POST}, params={"itemIds[]", "newIndex"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void changeOptionsPositions(@PathVariable long customFieldId, @RequestParam int newIndex, @RequestParam(value="itemIds[]") List<String> optionsLabels) {
        this.customFieldManager.changeOptionsPositions(customFieldId, newIndex, optionsLabels);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @RequestMapping(value={"/{customFieldIds}"}, method={RequestMethod.DELETE})
    public void deleteCustomField(@PathVariable(value="customFieldIds") List<Long> customFieldIds) {
        this.customFieldManager.deleteCustomField(customFieldIds);
    }

    @RequestMapping(value={"/tags/{boundEntity}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getPossibleTagValues(@PathVariable(value="boundEntity") String boundEntity) {
        List projectIds = (List)CollectionUtils.collect((Collection)this.projectFinder.findAllOrderedByName(), (Transformer)new Transformer(){

            public Object transform(Object input) {
                return ((GenericProject)input).getId();
            }
        });
        return this.customFieldManager.getAvailableTagsForEntity(boundEntity, projectIds);
    }

    private static final class CustomFieldOptionsDataTableModelHelper
    extends DataTableModelBuilder<CustomFieldOption> {
        private CustomField customField;

        private CustomFieldOptionsDataTableModelHelper(CustomField customField) {
            this.customField = customField;
        }

        public Map<String, Object> buildItemData(CustomFieldOption item) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            String checked = " ";
            if (this.customField.getDefaultValue().equals(item.getLabel())) {
                checked = " checked='checked' ";
            }
            res.put("entity-index", this.getCurrentIndex());
            res.put("opt-label", HtmlUtils.htmlEscape((String)item.getLabel()));
            res.put("opt-code", HtmlUtils.htmlEscape((String)item.getCode()));
            res.put("opt-colour", HTMLCleanupUtils.escapeOrDefault(item.getColour(), ""));
            res.put("opt-default", "<input type='checkbox' name='default' value='" + HtmlUtils.htmlEscape((String)item.getLabel()) + "'" + checked + "/>");
            res.put("empty-delete-holder", " ");
            return res;
        }
    }
}

