/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.customfield;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.internal.project.ProjectHelper;
import org.squashtest.tm.service.project.GenericProjectFinder;

@Controller
@RequestMapping(value={"administration/projects/{projectId}/custom-fields-binding"})
public class CustomFieldBindingManagerController {
    @Inject
    private CustomFieldBindingFinderService service;
    @Inject
    private GenericProjectFinder projectService;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getManager(@PathVariable(value="projectId") Long projectId) {
        ModelAndView mav;
        GenericProject project = this.projectService.findById(projectId.longValue());
        List customFields = this.service.findAvailableCustomFields();
        if (!customFields.isEmpty()) {
            List testCaseBindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.TEST_CASE);
            Collections.sort(testCaseBindings, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
            List testStepBindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.TEST_STEP);
            Collections.sort(testStepBindings, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
            List requirementBindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.REQUIREMENT_VERSION);
            Collections.sort(requirementBindings, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
            List campaignBindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.CAMPAIGN);
            Collections.sort(campaignBindings, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
            List iterationBindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.ITERATION);
            Collections.sort(iterationBindings, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
            List testSuiteBindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.TEST_SUITE);
            Collections.sort(testSuiteBindings, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
            List executionBindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.EXECUTION);
            Collections.sort(executionBindings, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
            List executionStepBindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.EXECUTION_STEP);
            Collections.sort(executionStepBindings, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
            List projectsBindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.PROJECT);
            Collections.sort(projectsBindings, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
            List campaignFoldersBindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.CAMPAIGN_FOLDER);
            Collections.sort(campaignFoldersBindings, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
            List reqFoldersBindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.REQUIREMENT_FOLDER);
            Collections.sort(reqFoldersBindings, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
            List tcFoldersBindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.TESTCASE_FOLDER);
            Collections.sort(tcFoldersBindings, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
            mav = new ModelAndView("project-tabs/custom-field-binding.html");
            mav.addObject("testCaseBindings", (Object)testCaseBindings);
            mav.addObject("testStepBindings", (Object)testStepBindings);
            mav.addObject("requirementBindings", (Object)requirementBindings);
            mav.addObject("campaignBindings", (Object)campaignBindings);
            mav.addObject("iterationBindings", (Object)iterationBindings);
            mav.addObject("testSuiteBindings", (Object)testSuiteBindings);
            mav.addObject("executionBindings", (Object)executionBindings);
            mav.addObject("executionStepBindings", (Object)executionStepBindings);
            mav.addObject("projectsBindings", (Object)projectsBindings);
            mav.addObject("tcFoldersBindings", (Object)tcFoldersBindings);
            mav.addObject("reqFoldersBindings", (Object)reqFoldersBindings);
            mav.addObject("campaignFoldersBindings", (Object)campaignFoldersBindings);
            mav.addObject("projectIdentifier", (Object)projectId);
            mav.addObject("isTemplate", (Object)ProjectHelper.isTemplate((GenericProject)project));
            mav.addObject("isBoundToTemplate", (Object)project.isBoundToTemplate());
        } else {
            mav = new ModelAndView("fragment/project/project-no-cuf-exists");
            mav.addObject("msg", (Object)"message.project.cuf.noCufExists");
        }
        return mav;
    }
}

