/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.customfield;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.RenderingLocation;
import org.squashtest.tm.service.customfield.CustomFieldBindingModificationService;
import org.squashtest.tm.service.internal.dto.CustomFieldBindingModel;
import org.squashtest.tm.service.internal.dto.CustomFieldJsonConverter;
import org.squashtest.tm.service.internal.dto.CustomFieldModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTablePaging;

@Controller
@RequestMapping(value={"/custom-fields-binding"})
public class CustomFieldBindingController {
    private static final String BINDABLE_ENTITY = "bindableEntity";
    @Inject
    private CustomFieldBindingModificationService service;
    @Inject
    private CustomFieldJsonConverter converter;

    @RequestMapping(method={RequestMethod.GET}, params={"projectId", "!bindableEntity"}, headers={"Accept=application/json, text/javascript"})
    @ResponseBody
    public List<CustomFieldBindingModel> findAllCustomFieldsForProject(@RequestParam(value="projectId") Long projectId) {
        List bindings = this.service.findCustomFieldsForGenericProject(projectId.longValue());
        return this.bindingToJson(bindings);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"projectId", "bindableEntity", "!sEcho"}, headers={"Accept=application/json, text/javascript"})
    @ResponseBody
    public List<CustomFieldBindingModel> findAllCustomFieldsForProject(@RequestParam(value="projectId") Long projectId, @RequestParam(value="bindableEntity") BindableEntity bindableEntity) {
        List bindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), bindableEntity);
        return this.bindingToJson(bindings);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"projectId", "bindableEntity", "!sEcho", "optional=false"}, produces={"application/json"})
    @ResponseBody
    public List<CustomFieldModel> findJsonRequiredAtCreationTime(@RequestParam(value="projectId") Long projectId, @RequestParam(value="bindableEntity") BindableEntity bindableEntity, Model model) {
        List bindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), bindableEntity);
        model.addAttribute("bindings", (Object)bindings);
        ArrayList<CustomField> fields = new ArrayList<CustomField>(bindings.size());
        for (CustomFieldBinding binding : bindings) {
            fields.add(binding.getCustomField());
        }
        return this.fieldToJson(fields);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"projectId", "bindableEntity", "sEcho"})
    @ResponseBody
    public DataTableModel findAllCustomFieldsTableForProject(@RequestParam(value="projectId") Long projectId, @RequestParam(value="bindableEntity") BindableEntity bindableEntity, DataTableDrawParameters params) {
        DataTablePaging paging = new DataTablePaging(params);
        PagedCollectionHolder bindings = this.service.findCustomFieldsForProjectAndEntity(projectId.longValue(), bindableEntity, (Paging)paging);
        CUFBindingDataTableModelHelper helper = new CUFBindingDataTableModelHelper(this.converter);
        return helper.buildDataModel(bindings, params.getsEcho());
    }

    @RequestMapping(value={"/{bindingIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindCustomField(@PathVariable(value="bindingIds") List<Long> bindingIds) {
        this.service.removeCustomFieldBindings(bindingIds);
    }

    @RequestMapping(value={"/available"}, method={RequestMethod.GET}, params={"projectId", "bindableEntity"}, headers={"Accept=application/json, text/javascript"})
    @ResponseBody
    public List<CustomFieldModel> findAllAvailableCustomFieldsForProjectAndEntity(@RequestParam(value="projectId") Long projectId, @RequestParam(value="bindableEntity") BindableEntity bindableEntity) {
        List fields = this.service.findAvailableCustomFields(projectId.longValue(), bindableEntity);
        return this.fieldToJson(fields);
    }

    @RequestMapping(value={"/{bindingIds}/position"}, method={RequestMethod.POST}, params={"newPosition"})
    @ResponseBody
    public void reorderBindings(@PathVariable(value="bindingIds") List<Long> bindingIds, @RequestParam(value="newPosition") int newIndex) {
        this.service.moveCustomFieldbindings(bindingIds, newIndex);
    }

    @RequestMapping(value={"/new-batch"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public void createNewBindings(@RequestBody CustomFieldBindingModel[] bindingModels) {
        this.service.createNewBindings(bindingModels);
    }

    @RequestMapping(value={"/{bindingId}/renderingLocations/{location}"}, method={RequestMethod.PUT})
    @ResponseBody
    public void addRenderingLocation(@PathVariable Long bindingId, @PathVariable RenderingLocation location) {
        this.service.addRenderingLocation(bindingId.longValue(), location);
    }

    @RequestMapping(value={"/{bindingId}/renderingLocations/{location}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeRenderingLocation(@PathVariable Long bindingId, @PathVariable RenderingLocation location) {
        this.service.removeRenderingLocation(bindingId.longValue(), location);
    }

    private List<CustomFieldBindingModel> bindingToJson(List<CustomFieldBinding> bindings) {
        LinkedList<CustomFieldBindingModel> result = new LinkedList<CustomFieldBindingModel>();
        for (CustomFieldBinding binding : bindings) {
            CustomFieldBindingModel model = this.converter.toJson(binding);
            result.add(model);
        }
        return result;
    }

    private List<CustomFieldModel> fieldToJson(List<CustomField> fields) {
        LinkedList<CustomFieldModel> result = new LinkedList<CustomFieldModel>();
        for (CustomField field : fields) {
            CustomFieldModel model = this.converter.toJson(field);
            result.add(model);
        }
        Collections.sort(result, (a, b) -> a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1));
        return result;
    }

    private static final class CUFBindingDataTableModelHelper
    extends DataTableModelBuilder<CustomFieldBinding> {
        private CustomFieldJsonConverter converter;

        private CUFBindingDataTableModelHelper(CustomFieldJsonConverter converter) {
            this.converter = converter;
        }

        @Override
        public Object buildItemData(CustomFieldBinding item) {
            CustomFieldBindingModel json = this.converter.toJson(item);
            json.getCustomField().setName(json.getCustomField().getName());
            json.getCustomField().setLabel(json.getCustomField().getLabel());
            return json;
        }
    }
}

