/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.customexport;

import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.service.campaign.CustomCampaignModificationService;
import org.squashtest.tm.service.campaign.IterationFinder;
import org.squashtest.tm.service.campaign.TestSuiteFinder;
import org.squashtest.tm.service.customfield.CustomFieldFinderService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.customreport.CustomReportCustomExportCSVService;
import org.squashtest.tm.service.customreport.CustomReportCustomExportModificationService;
import org.squashtest.tm.service.customreport.CustomReportCustomExportService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.dto.CustomFieldBindingModel;
import org.squashtest.tm.service.internal.repository.ExecutionStepDao;
import org.squashtest.tm.web.internal.controller.customexport.CustomExportCSVHelper;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.JsonProjectBuilder;

@Controller
@RequestMapping(value={"custom-exports"})
public class CustomExportController {
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private CustomReportLibraryNodeService reportLibraryNodeService;
    @Inject
    private CustomReportCustomExportModificationService customExportModificationService;
    @Inject
    private CustomReportCustomExportService customExportService;
    @Inject
    private CustomReportCustomExportCSVService csvExportService;
    @Inject
    private CustomCampaignModificationService customCampaignModificationService;
    @Inject
    private IterationFinder iterationFinder;
    @Inject
    private TestSuiteFinder testSuiteFinder;
    @Inject
    private JsonProjectBuilder jsonProjectBuilder;
    @Inject
    private CustomFieldFinderService cufService;
    @Inject
    private CustomFieldValueFinderService cufValueService;
    @Inject
    private ExecutionStepDao executionStepDao;

    @RequestMapping(value={"/wizard/{parentId}"})
    public ModelAndView getWizard(@PathVariable Long parentId, Locale locale) {
        ModelAndView mav = new ModelAndView("custom-exports/wizard/wizard.html");
        CustomReportLibraryNode crln = this.reportLibraryNodeService.findCustomReportLibraryNodeById(parentId);
        if (crln.getEntityType().getTypeName().equals("CUSTOM_EXPORT")) {
            CustomReportCustomExport customExportDefinition = (CustomReportCustomExport)crln.getEntity();
            mav.addObject("customExportDefinition", (Object)JsonHelper.serialize(customExportDefinition));
            mav.addObject("scopeEntityName", (Object)this.getScopeEntityName((EntityReference)customExportDefinition.getScope().get(0)));
            mav.addObject("availableCustomFields", this.getCustomFieldBindingsData(((EntityReference)customExportDefinition.getScope().get(0)).getType(), ((EntityReference)customExportDefinition.getScope().get(0)).getId()));
        }
        mav.addObject("parentId", (Object)parentId);
        return mav;
    }

    private String getScopeEntityName(EntityReference entityReference) {
        String scopeEntityName = this.customExportService.getScopeEntityName(entityReference);
        return scopeEntityName.isEmpty() ? this.i18nHelper.internationalize("wizard.perimeter.msg.perimeter.choose", LocaleContextHolder.getLocale()) : scopeEntityName;
    }

    @ResponseBody
    @RequestMapping(value={"/new/{parentNodeId}"}, method={RequestMethod.POST}, consumes={"application/json"})
    public String createNewCustomExport(@RequestBody @Valid CustomReportCustomExport customExport, @PathVariable(value="parentNodeId") long parentNodeId) {
        CustomReportLibraryNode newNode = this.reportLibraryNodeService.createNewNode(Long.valueOf(parentNodeId), (CustomReportTreeEntity)customExport);
        return String.valueOf(newNode.getId());
    }

    @ResponseBody
    @RequestMapping(value={"/update/{nodeId}"}, method={RequestMethod.POST}, consumes={"application/json"})
    public String updateCustomExport(@RequestBody CustomReportCustomExport modifiedCustomExport, @PathVariable(value="nodeId") long nodeId) {
        this.customExportModificationService.updateCustomExport(Long.valueOf(nodeId), modifiedCustomExport);
        return String.valueOf(nodeId);
    }

    @ResponseBody
    @RequestMapping(value={"/generate/{customExportId}"}, method={RequestMethod.GET})
    public FileSystemResource generateCustomExport(@PathVariable long customExportId, HttpServletResponse response, Locale locale) {
        CustomReportCustomExport customExport = this.reportLibraryNodeService.findCustomExportByNodeId(Long.valueOf(customExportId));
        response.setContentType("application/octet-stream");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        response.setHeader("Content-Disposition", "attachment; filename=EXPORT_" + customExport.getName().replace(" ", "_") + "_" + sdf.format(new Date()) + ".csv");
        File exported = this.createCustomExportFile(customExport, locale);
        return new FileSystemResource(exported);
    }

    private File createCustomExportFile(CustomReportCustomExport customExport, Locale locale) {
        CustomExportCSVHelper csvHelper = new CustomExportCSVHelper(this.csvExportService, this.cufService, this.cufValueService, this.i18nHelper, locale, this.executionStepDao);
        try (PrintWriter writer = null;){
            File file = File.createTempFile("custom-export", "tmp");
            file.deleteOnExit();
            writer = new PrintWriter(file);
            writer.write(csvHelper.getInternationalizedHeaders(customExport));
            writer.write(csvHelper.getWritableRowsData(customExport));
            writer.close();
            File file2 = file;
            return file2;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/cuf-data"}, method={RequestMethod.GET})
    public Map<String, List<CustomFieldBindingModel>> getCustomFieldBindingsData(@RequestParam EntityType entityType, @RequestParam Long entityId) {
        Long mainProjectId = null;
        List itpis = null;
        switch (entityType) {
            case CAMPAIGN: {
                Campaign campaign = this.customCampaignModificationService.findCampaigWithExistenceCheck(entityId.longValue());
                if (campaign == null) break;
                itpis = campaign.getIterations().stream().map(Iteration::getTestPlans).flatMap(Collection::stream).collect(Collectors.toList());
                mainProjectId = campaign.getProject().getId();
                break;
            }
            case ITERATION: {
                Iteration iteration = (Iteration)this.iterationFinder.findById(entityId.longValue());
                if (iteration == null) break;
                mainProjectId = iteration.getProject().getId();
                itpis = iteration.getTestPlans();
                break;
            }
            case TEST_SUITE: {
                try {
                    TestSuite testSuite = (TestSuite)this.testSuiteFinder.findById(entityId.longValue());
                    mainProjectId = testSuite.getProject().getId();
                    itpis = testSuite.getTestPlan();
                    break;
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    return new HashMap<String, List<CustomFieldBindingModel>>();
                }
            }
            default: {
                throw new IllegalArgumentException("Entity of type " + entityType.name() + " is not supported");
            }
        }
        return mainProjectId != null ? this.getCustomFieldsData(mainProjectId, itpis) : new HashMap();
    }

    private Map<String, List<CustomFieldBindingModel>> getCustomFieldsData(Long mainProjectId, List<IterationTestPlanItem> itpis) {
        Map<String, List<CustomFieldBindingModel>> map = this.jsonProjectBuilder.buildProjectCufBindingsMap(mainProjectId);
        return this.customExportService.getCustomFieldsData(mainProjectId, itpis, map);
    }
}

