/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.config;

import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.service.feature.FeatureManager;

@Controller
@RequestMapping(value={"/features"})
public class SquashFeatureController {
    private static final String ENABLED = "enabled";
    private final Object monitor = new Object();
    @Inject
    private FeatureManager featureManager;
    @Inject
    private ServletContext applicationScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/milestones"}, method={RequestMethod.POST}, params={"enabled"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"ROLE_ADMIN"})
    public void setMilestonesFeature(@RequestParam(value="enabled") boolean enabled) {
        Object object = this.monitor;
        synchronized (object) {
            Object prevState = this.applicationScope.getAttribute("milestoneFeatureEnabled");
            this.applicationScope.setAttribute("milestoneFeatureEnabled", (Object)false);
            try {
                this.featureManager.setEnabled(FeatureManager.Feature.MILESTONE, enabled);
                this.applicationScope.setAttribute("milestoneFeatureEnabled", (Object)enabled);
            }
            catch (RuntimeException ex) {
                this.applicationScope.setAttribute("milestoneFeatureEnabled", prevState);
                throw ex;
            }
        }
    }

    @RequestMapping(value={"/case-insensitive-login"}, method={RequestMethod.POST}, params={"enabled"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"ROLE_ADMIN"})
    public void setCaseInsensitiveLoginFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN, enabled);
    }

    @RequestMapping(value={"/stack-trace"}, method={RequestMethod.POST}, params={"enabled"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"ROLE_ADMIN"})
    public void setStackTraceFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.STACK_TRACE, enabled);
    }

    @RequestMapping(value={"/autoconnect-on-connection"}, method={RequestMethod.POST}, params={"enabled"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"ROLE_ADMIN"})
    public void setAutoconnectOnConnectionFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.AUTOCONNECT_ON_CONNECTION, enabled);
    }
}

